/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.catalina.ant.jmx.JMXAccessorTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class JMXAccessorCondition
extends ProjectComponent
implements Condition {
    private String url = null;
    private String host = "localhost";
    private String port = "8050";
    private String password = null;
    private String username = null;
    private String name = null;
    private String attribute;
    private String value;
    private String operation = "==";
    private String type = "long";
    private String ref = "jmx.server";
    private String unlessCondition;
    private String ifCondition;
    private static final String info = "org.apache.catalina.ant.JMXAccessorCondition/1.1";

    public String getInfo() {
        return info;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String objectName) {
        this.name = objectName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String refId) {
        this.ref = refId;
    }

    public String getIf() {
        return this.ifCondition;
    }

    public void setIf(String c) {
        this.ifCondition = c;
    }

    public String getUnless() {
        return this.unlessCondition;
    }

    public void setUnless(String c) {
        this.unlessCondition = c;
    }

    protected MBeanServerConnection getJMXConnection() throws MalformedURLException, IOException {
        return JMXAccessorTask.accessJMXConnection(this.getProject(), this.getUrl(), this.getHost(), this.getPort(), this.getUsername(), this.getPassword(), this.ref);
    }

    protected String accessJMXValue() {
        try {
            Object result = this.getJMXConnection().getAttribute(new ObjectName(this.name), this.attribute);
            if (result != null) {
                return result.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected boolean testIfCondition() {
        if (this.ifCondition == null || "".equals(this.ifCondition)) {
            return true;
        }
        return this.getProject().getProperty(this.ifCondition) != null;
    }

    protected boolean testUnlessCondition() {
        if (this.unlessCondition == null || "".equals(this.unlessCondition)) {
            return true;
        }
        return this.getProject().getProperty(this.unlessCondition) == null;
    }

    public boolean eval() {
        if (this.operation == null) {
            throw new BuildException("operation attribute is not set");
        }
        if (this.value == null) {
            throw new BuildException("value attribute is not set");
        }
        if (this.name == null || this.attribute == null) {
            throw new BuildException("Must specify a 'attribute', name for equals condition");
        }
        if (this.testIfCondition() && this.testUnlessCondition()) {
            String jmxValue = this.accessJMXValue();
            if (jmxValue != null) {
                String op = this.getOperation();
                if ("==".equals(op)) {
                    return jmxValue.equals(this.value);
                }
                if ("!=".equals(op)) {
                    return !jmxValue.equals(this.value);
                }
                if ("long".equals(this.type)) {
                    long jvalue = Long.parseLong(jmxValue);
                    long lvalue = Long.parseLong(this.value);
                    if (">".equals(op)) {
                        return jvalue > lvalue;
                    }
                    if (">=".equals(op)) {
                        return jvalue >= lvalue;
                    }
                    if ("<".equals(op)) {
                        return jvalue < lvalue;
                    }
                    if ("<=".equals(op)) {
                        return jvalue <= lvalue;
                    }
                } else if ("double".equals(this.type)) {
                    double jvalue = Double.parseDouble(jmxValue);
                    double dvalue = Double.parseDouble(this.value);
                    if (">".equals(op)) {
                        return jvalue > dvalue;
                    }
                    if (">=".equals(op)) {
                        return jvalue >= dvalue;
                    }
                    if ("<".equals(op)) {
                        return jvalue < dvalue;
                    }
                    if ("<=".equals(op)) {
                        return jvalue <= dvalue;
                    }
                }
            }
            return false;
        }
        return true;
    }
}

