/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.ReceiverBase;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.net.SocketConnectorBase;
import ch.qos.logback.core.util.CloseUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.net.SocketFactory;

public class SocketReceiver
extends ReceiverBase
implements Runnable,
SocketConnector.ExceptionHandler {
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private String remoteHost;
    private InetAddress address;
    private int port;
    private int reconnectionDelay;
    private int acceptConnectionTimeout = 5000;
    private String remoteId;
    private volatile Socket socket;

    protected boolean shouldStart() {
        int errorCount = 0;
        if (this.port == 0) {
            ++errorCount;
            this.addError("No port was configured for remote. For more information, please visit http://logback.qos.ch/codes.html#receiver_no_port");
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.addError("No host name or address was configured for remote. For more information, please visit http://logback.qos.ch/codes.html#receiver_no_host");
        }
        if (this.reconnectionDelay == 0) {
            this.reconnectionDelay = 30000;
        }
        if (errorCount == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException ex) {
                this.addError("unknown host: " + this.remoteHost);
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            this.remoteId = "remote " + this.remoteHost + ":" + this.port + ": ";
        }
        return errorCount == 0;
    }

    protected void onStop() {
        if (this.socket != null) {
            CloseUtil.closeQuietly(this.socket);
        }
    }

    protected Runnable getRunnableTask() {
        return this;
    }

    public void run() {
        try {
            LoggerContext lc = (LoggerContext)this.getContext();
            SocketConnector connector = this.createConnector(this.address, this.port, 0, this.reconnectionDelay);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.getContext().getExecutorService().execute(connector);
                }
                catch (RejectedExecutionException ex) {
                    continue;
                }
                this.socket = connector.awaitConnection();
                this.dispatchEvents(lc);
                connector = this.createConnector(this.address, this.port, this.reconnectionDelay);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addInfo("shutting down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dispatchEvents(LoggerContext lc) {
        try {
            this.socket.setSoTimeout(this.acceptConnectionTimeout);
            ObjectInputStream ois = new ObjectInputStream(this.socket.getInputStream());
            this.socket.setSoTimeout(0);
            this.addInfo(this.remoteId + "connection established");
            while (true) {
                ILoggingEvent event;
                Logger remoteLogger;
                if (!(remoteLogger = lc.getLogger((event = (ILoggingEvent)ois.readObject()).getLoggerName())).isEnabledFor(event.getLevel())) {
                    continue;
                }
                remoteLogger.callAppenders(event);
            }
        }
        catch (EOFException ex) {
            this.addInfo(this.remoteId + "end-of-stream detected");
            CloseUtil.closeQuietly(this.socket);
            this.socket = null;
            this.addInfo(this.remoteId + "connection closed");
        }
        catch (IOException ex) {
            this.addInfo(this.remoteId + "connection failed: " + ex);
        }
        catch (ClassNotFoundException ex) {
            this.addInfo(this.remoteId + "unknown event class: " + ex);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            CloseUtil.closeQuietly(this.socket);
            this.socket = null;
            this.addInfo(this.remoteId + "connection closed");
        }
        {
            finally {
                CloseUtil.closeQuietly(this.socket);
                this.socket = null;
                this.addInfo(this.remoteId + "connection closed");
            }
        }
    }

    public void connectionFailed(SocketConnector connector, Exception ex) {
        if (ex instanceof InterruptedException) {
            this.addInfo("connector interrupted");
        } else if (ex instanceof ConnectException) {
            this.addInfo(this.remoteId + "connection refused");
        } else {
            this.addInfo(this.remoteId + ex);
        }
    }

    private SocketConnector createConnector(InetAddress address, int port, int delay2) {
        return this.createConnector(address, port, delay2, delay2);
    }

    private SocketConnector createConnector(InetAddress address, int port, int initialDelay, int retryDelay) {
        SocketConnector connector = this.newConnector(address, port, initialDelay, retryDelay);
        connector.setExceptionHandler(this);
        connector.setSocketFactory(this.getSocketFactory());
        return connector;
    }

    protected SocketConnector newConnector(InetAddress address, int port, int initialDelay, int retryDelay) {
        return new SocketConnectorBase(address, port, initialDelay, retryDelay);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    protected ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool();
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setReconnectionDelay(int reconnectionDelay) {
        this.reconnectionDelay = reconnectionDelay;
    }

    public void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        this.acceptConnectionTimeout = acceptConnectionTimeout;
    }
}

