/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.PainlessScriptEngine;
import org.elasticsearch.painless.spi.PainlessExtension;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;

public final class PainlessPlugin
extends Plugin
implements ScriptPlugin,
ExtensiblePlugin {
    private final Map<ScriptContext<?>, List<Whitelist>> extendedWhitelists = new HashMap();

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        HashMap contextsWithWhitelists = new HashMap();
        for (ScriptContext<?> context : contexts) {
            List<Whitelist> whitelists = this.extendedWhitelists.get(context);
            if (whitelists == null) {
                whitelists = new ArrayList<Whitelist>(Whitelist.BASE_WHITELISTS);
            }
            contextsWithWhitelists.put(context, whitelists);
        }
        return new PainlessScriptEngine(settings, contextsWithWhitelists);
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CompilerSettings.REGEX_ENABLED);
    }

    public void reloadSPI(ClassLoader loader) {
        for (PainlessExtension extension : ServiceLoader.load(PainlessExtension.class, loader)) {
            for (Map.Entry entry : extension.getContextWhitelists().entrySet()) {
                List existing = this.extendedWhitelists.computeIfAbsent((ScriptContext)entry.getKey(), c -> new ArrayList(Whitelist.BASE_WHITELISTS));
                existing.addAll((Collection)entry.getValue());
            }
        }
    }
}

