/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.SuppressForbidden;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;

public abstract class Command
implements Closeable {
    protected final String description;
    private final Runnable beforeMain;
    protected final OptionParser parser = new OptionParser();
    private final OptionSpec<Void> helpOption = this.parser.acceptsAll(Arrays.asList("h", "help"), "show help").forHelp();
    private final OptionSpec<Void> silentOption = this.parser.acceptsAll(Arrays.asList("s", "silent"), "show minimal output");
    private final OptionSpec<Void> verboseOption = this.parser.acceptsAll(Arrays.asList("v", "verbose"), "show verbose output").availableUnless(this.silentOption, new OptionSpec[0]);
    private Thread shutdownHookThread;

    public Command(String description, Runnable beforeMain) {
        this.description = description;
        this.beforeMain = beforeMain;
    }

    public final int main(String[] args, Terminal terminal) throws Exception {
        if (this.addShutdownHook()) {
            this.shutdownHookThread = new Thread(() -> {
                try {
                    this.close();
                }
                catch (IOException e) {
                    try {
                        StringWriter sw = new StringWriter();
                        Throwable throwable = null;
                        try {
                            PrintWriter pw = new PrintWriter(sw);
                            Throwable throwable2 = null;
                            try {
                                e.printStackTrace(pw);
                                terminal.println(sw.toString());
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                Command.$closeResource(throwable2, pw);
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            Command.$closeResource(throwable, sw);
                        }
                    }
                    catch (IOException impossible) {
                        throw new AssertionError((Object)impossible);
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.beforeMain.run();
        try {
            this.mainWithoutErrorHandling(args, terminal);
        }
        catch (OptionException e) {
            this.printHelp(terminal);
            terminal.println(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage());
            return 64;
        }
        catch (UserException e) {
            if (e.exitCode == 64) {
                this.printHelp(terminal);
            }
            terminal.println(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage());
            return e.exitCode;
        }
        return 0;
    }

    void mainWithoutErrorHandling(String[] args, Terminal terminal) throws Exception {
        OptionSet options = this.parser.parse(args);
        if (options.has(this.helpOption)) {
            this.printHelp(terminal);
            return;
        }
        if (options.has(this.silentOption)) {
            terminal.setVerbosity(Terminal.Verbosity.SILENT);
        } else if (options.has(this.verboseOption)) {
            terminal.setVerbosity(Terminal.Verbosity.VERBOSE);
        } else {
            terminal.setVerbosity(Terminal.Verbosity.NORMAL);
        }
        this.execute(terminal, options);
    }

    private void printHelp(Terminal terminal) throws IOException {
        terminal.println(this.description);
        terminal.println("");
        this.printAdditionalHelp(terminal);
        this.parser.printHelpOn((Writer)terminal.getWriter());
    }

    protected void printAdditionalHelp(Terminal terminal) {
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    protected static void exit(int status) {
        System.exit(status);
    }

    protected abstract void execute(Terminal var1, OptionSet var2) throws Exception;

    protected boolean addShutdownHook() {
        return true;
    }

    Thread getShutdownHookThread() {
        return this.shutdownHookThread;
    }

    @Override
    public void close() throws IOException {
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

