/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class PublishClusterStateStats
implements Writeable,
ToXContentObject {
    private final long fullClusterStateReceivedCount;
    private final long incompatibleClusterStateDiffReceivedCount;
    private final long compatibleClusterStateDiffReceivedCount;

    public PublishClusterStateStats(long fullClusterStateReceivedCount, long incompatibleClusterStateDiffReceivedCount, long compatibleClusterStateDiffReceivedCount) {
        this.fullClusterStateReceivedCount = fullClusterStateReceivedCount;
        this.incompatibleClusterStateDiffReceivedCount = incompatibleClusterStateDiffReceivedCount;
        this.compatibleClusterStateDiffReceivedCount = compatibleClusterStateDiffReceivedCount;
    }

    public PublishClusterStateStats(StreamInput in) throws IOException {
        this.fullClusterStateReceivedCount = in.readVLong();
        this.incompatibleClusterStateDiffReceivedCount = in.readVLong();
        this.compatibleClusterStateDiffReceivedCount = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.fullClusterStateReceivedCount);
        out.writeVLong(this.incompatibleClusterStateDiffReceivedCount);
        out.writeVLong(this.compatibleClusterStateDiffReceivedCount);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("published_cluster_states");
        builder.field("full_states", this.fullClusterStateReceivedCount);
        builder.field("incompatible_diffs", this.incompatibleClusterStateDiffReceivedCount);
        builder.field("compatible_diffs", this.compatibleClusterStateDiffReceivedCount);
        builder.endObject();
        return builder;
    }

    long getFullClusterStateReceivedCount() {
        return this.fullClusterStateReceivedCount;
    }

    long getIncompatibleClusterStateDiffReceivedCount() {
        return this.incompatibleClusterStateDiffReceivedCount;
    }

    long getCompatibleClusterStateDiffReceivedCount() {
        return this.compatibleClusterStateDiffReceivedCount;
    }

    public String toString() {
        return "PublishClusterStateStats(full=" + this.fullClusterStateReceivedCount + ", incompatible=" + this.incompatibleClusterStateDiffReceivedCount + ", compatible=" + this.compatibleClusterStateDiffReceivedCount + ")";
    }
}

