/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.util.Set;
import org.gradle.api.Named;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.component.UsageContext;

class DefaultUsageContext
implements UsageContext,
Named {
    private final String name;
    private final Usage usage;
    private final AttributeContainer attributes;
    private final Set<? extends PublishArtifact> artifacts;
    private final Set<? extends ModuleDependency> dependencies;
    private final Set<? extends DependencyConstraint> dependencyConstraints;

    DefaultUsageContext(String name, Usage usage, Set<? extends PublishArtifact> artifacts, Configuration configuration) {
        this.name = name;
        this.usage = usage;
        this.attributes = configuration.getAttributes();
        this.artifacts = artifacts;
        this.dependencies = configuration.getAllDependencies().withType(ModuleDependency.class);
        this.dependencyConstraints = configuration.getAllDependencyConstraints();
    }

    DefaultUsageContext(String name, Usage usage, AttributeContainer attributes, Set<? extends PublishArtifact> artifacts, Set<? extends ModuleDependency> dependencies, Set<? extends DependencyConstraint> dependencyConstraints) {
        this.name = name;
        this.usage = usage;
        this.attributes = attributes;
        this.artifacts = artifacts;
        this.dependencies = dependencies;
        this.dependencyConstraints = dependencyConstraints;
    }

    public String getName() {
        return this.name;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public Set<? extends PublishArtifact> getArtifacts() {
        return this.artifacts;
    }

    public Set<? extends ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    public Set<? extends DependencyConstraint> getDependencyConstraints() {
        return this.dependencyConstraints;
    }
}

