/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.language.swift.tasks.internal.DefaultSwiftCompileSpec;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.compilespec.SwiftCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.swift.IncrementalSwiftCompiler;

@Incubating
@CacheableTask
public class SwiftCompile
extends DefaultTask {
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private boolean debug;
    private boolean optimize;
    private final Property<String> moduleName;
    private final RegularFileProperty moduleFile;
    private final ConfigurableFileCollection modules;
    private final ListProperty<String> compilerArgs;
    private final DirectoryProperty objectFileDir;
    private final ConfigurableFileCollection source;
    private final Property<SwiftVersion> sourceCompatibility;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final Map<String, String> macros = new LinkedHashMap<String, String>();

    @Inject
    public SwiftCompile(CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory) {
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.source = this.getProject().files(new Object[0]);
        this.compilerArgs = this.getProject().getObjects().listProperty(String.class);
        this.objectFileDir = this.newOutputDirectory();
        this.moduleName = this.getProject().getObjects().property(String.class);
        this.moduleFile = this.newOutputFile();
        this.modules = this.getProject().files(new Object[0]);
        this.sourceCompatibility = this.getProject().getObjects().property(SwiftVersion.class);
    }

    @Internal
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
    }

    @Nested
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    @Input
    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros.clear();
        this.macros.putAll(macros);
    }

    @Input
    public boolean isDebuggable() {
        return this.debug;
    }

    public void setDebuggable(boolean debug) {
        this.debug = debug;
    }

    @Input
    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimized(boolean optimize) {
        this.optimize = optimize;
    }

    @Input
    public ListProperty<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @OutputDirectory
    public DirectoryProperty getObjectFileDir() {
        return this.objectFileDir;
    }

    @OutputFile
    public RegularFileProperty getModuleFile() {
        return this.moduleFile;
    }

    @Optional
    @Input
    public Property<String> getModuleName() {
        return this.moduleName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public ConfigurableFileCollection getModules() {
        return this.modules;
    }

    @Input
    public Property<SwiftVersion> getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    @Nested
    protected CompilerVersion getCompilerVersion() {
        NativeToolChainInternal toolChain = (NativeToolChainInternal)this.getToolChain();
        NativePlatformInternal targetPlatform = (NativePlatformInternal)this.getTargetPlatform();
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        VersionAwareCompiler compiler = (VersionAwareCompiler)toolProvider.newCompiler(SwiftCompileSpec.class);
        return compiler.getVersion();
    }

    @TaskAction
    void compile(IncrementalTaskInputs inputs) {
        final ArrayList removedFiles = Lists.newArrayList();
        final HashSet changedFiles = Sets.newHashSet();
        boolean isIncremental = inputs.isIncremental();
        if (isIncremental) {
            inputs.outOfDate((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails inputFileDetails) {
                    if (inputFileDetails.isModified()) {
                        changedFiles.add(inputFileDetails.getFile());
                    }
                }
            });
            inputs.removed((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails removed) {
                    removedFiles.add(removed.getFile());
                }
            });
            Set allSourceFiles = this.getSource().getFiles();
            if (!allSourceFiles.containsAll(changedFiles)) {
                isIncremental = false;
            }
        }
        BuildOperationLogger operationLogger = ((BuildOperationLoggerFactory)this.getServices().get(BuildOperationLoggerFactory.class)).newOperationLogger(this.getName(), this.getTemporaryDir());
        SwiftCompileSpec spec = this.createSpec(operationLogger, isIncremental, changedFiles, removedFiles);
        PlatformToolProvider platformToolProvider = this.toolChain.select(this.targetPlatform);
        IncrementalSwiftCompiler baseCompiler = new IncrementalSwiftCompiler(platformToolProvider.newCompiler(SwiftCompileSpec.class), this.getOutputs(), this.compilerOutputFileNamingSchemeFactory);
        Compiler loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap((Compiler)baseCompiler);
        WorkResult result = loggingCompiler.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private SwiftCompileSpec createSpec(BuildOperationLogger operationLogger, boolean isIncremental, Collection<File> changedFiles, Collection<File> removedFiles) {
        DefaultSwiftCompileSpec spec = new DefaultSwiftCompileSpec();
        spec.setModuleName((String)this.moduleName.getOrNull());
        spec.setModuleFile(((RegularFile)this.moduleFile.get()).getAsFile());
        for (File file : this.modules.getFiles()) {
            if (file.isFile()) {
                spec.include(new File[]{file.getParentFile()});
                continue;
            }
            spec.include(new File[]{file});
        }
        spec.setTargetPlatform((NativePlatform)this.targetPlatform);
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(((Directory)this.objectFileDir.get()).getAsFile());
        spec.source((Iterable)this.getSource());
        spec.setRemovedSourceFiles(removedFiles);
        spec.setChangedFiles(changedFiles);
        spec.setMacros(this.getMacros());
        spec.args((List)this.getCompilerArgs().get());
        spec.setDebuggable(this.isDebuggable());
        spec.setOptimized(this.isOptimized());
        spec.setIncrementalCompile(isIncremental);
        spec.setOperationLogger(operationLogger);
        spec.setSourceCompatibility((SwiftVersion)this.sourceCompatibility.get());
        return spec;
    }
}

