/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderImpl;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubSerializer;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.PairConsumer;
import org.jetbrains.kotlin.com.intellij.util.TimeoutUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;

public class DebugUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DebugUtil");
    public static boolean CHECK = false;
    public static final boolean DO_EXPENSIVE_CHECKS;
    public static final boolean CHECK_INSIDE_ATOMIC_ACTION_ENABLED;
    private static final ThreadLocal<Object> ourPsiModificationTrace;
    private static final ThreadLocal<Integer> ourPsiModificationDepth;
    private static final Set<Integer> ourNonTransactedTraces;

    public static String psiTreeToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "psiTreeToString"));
        }
        ASTNode node = SourceTreeToPsiMap.psiElementToTree(element);
        assert (node != null) : element;
        return DebugUtil.treeToString(node, skipWhitespaces);
    }

    public static String treeToString(@NotNull ASTNode root2, boolean skipWhitespaces) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "treeToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBuffer(ruler, root2, 0, skipWhitespaces, false, false, true);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBuffer(buffer, root2, 0, skipWhitespaces, false, false, true);
        return buffer.toString();
    }

    public static String nodeTreeToString(@NotNull ASTNode root2, boolean skipWhitespaces) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "nodeTreeToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBuffer(ruler, root2, 0, skipWhitespaces, false, false, false);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBuffer(buffer, root2, 0, skipWhitespaces, false, false, false);
        return buffer.toString();
    }

    public static String treeToString(@NotNull ASTNode root2, boolean skipWhitespaces, boolean showRanges) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "treeToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBuffer(ruler, root2, 0, skipWhitespaces, showRanges, false, true);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBuffer(buffer, root2, 0, skipWhitespaces, showRanges, false, true);
        return buffer.toString();
    }

    public static String treeToStringWithUserData(TreeElement root2, boolean skipWhitespaces) {
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBufferWithUserData((Appendable)ruler, root2, 0, skipWhitespaces);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBufferWithUserData((Appendable)buffer, root2, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static String treeToStringWithUserData(PsiElement root2, boolean skipWhitespaces) {
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.treeToBufferWithUserData((Appendable)ruler, root2, 0, skipWhitespaces);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.treeToBufferWithUserData((Appendable)buffer, root2, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root2, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "treeToBuffer"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "treeToBuffer"));
        }
        DebugUtil.treeToBuffer(buffer, root2, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, null);
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root2, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, @Nullable PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "treeToBuffer"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "treeToBuffer"));
        }
        ((TreeElement)root2).acceptTree(new TreeToBuffer(buffer, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, extra));
    }

    public static String lightTreeToString(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, boolean skipWhitespaces) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "lightTreeToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.lightTreeToBuffer(tree, tree.getRoot(), ruler, 0, skipWhitespaces);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.lightTreeToBuffer(tree, tree.getRoot(), buffer, 0, skipWhitespaces);
        return buffer.toString();
    }

    public static void lightTreeToBuffer(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode node, @NotNull Appendable buffer, int indent, boolean skipWhiteSpaces) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "lightTreeToBuffer"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "lightTreeToBuffer"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "lightTreeToBuffer"));
        }
        IElementType tokenType = node.getTokenType();
        if (skipWhiteSpaces && tokenType == TokenType.WHITE_SPACE) {
            return;
        }
        boolean isLeaf = node instanceof LighterASTTokenNode;
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            if (tokenType == TokenType.ERROR_ELEMENT) {
                buffer.append("PsiErrorElement:").append(PsiBuilderImpl.getErrorMessage(node));
            } else if (tokenType == TokenType.WHITE_SPACE) {
                buffer.append("PsiWhiteSpace");
            } else {
                buffer.append(isLeaf ? "PsiElement" : "Element").append('(').append(tokenType.toString()).append(')');
            }
            if (isLeaf) {
                String text2 = ((LighterASTTokenNode)node).getText().toString();
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text2)).append("')");
            }
            buffer.append('\n');
            if (!isLeaf) {
                Ref<T[]> kids = new Ref<T[]>();
                int numKids = tree.getChildren(node, kids);
                if (numKids == 0) {
                    StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                    buffer.append("<empty list>\n");
                } else {
                    for (int i = 0; i < numKids; ++i) {
                        DebugUtil.lightTreeToBuffer(tree, ((LighterASTNode[])kids.get())[i], buffer, indent + 2, skipWhiteSpaces);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static String stubTreeToString(Stub root2) {
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.stubTreeToBuffer(root2, ruler, 0);
        StringBuilder builder = new StringBuilder(ruler.getLength());
        DebugUtil.stubTreeToBuffer(root2, builder, 0);
        return builder.toString();
    }

    public static void stubTreeToBuffer(Stub node, Appendable buffer, int indent) {
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            ObjectStubSerializer stubType = node.getStubType();
            if (stubType != null) {
                buffer.append(stubType.toString()).append(':');
            }
            buffer.append(node.toString()).append('\n');
            List<? extends Stub> children2 = node.getChildrenStubs();
            for (Stub stub : children2) {
                DebugUtil.stubTreeToBuffer(stub, buffer, indent + 2);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    private static void treeToBufferWithUserData(Appendable buffer, TreeElement root2, int indent, boolean skipWhiteSpaces) {
        if (skipWhiteSpaces && root2.getElementType() == TokenType.WHITE_SPACE) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            PsiElement psi = SourceTreeToPsiMap.treeElementToPsi(root2);
            assert (psi != null) : root2;
            if (root2 instanceof CompositeElement) {
                buffer.append(psi.toString());
            } else {
                String text2 = DebugUtil.fixWhiteSpaces(root2.getText());
                buffer.append(root2.toString()).append("('").append(text2).append("')");
            }
            buffer.append(root2.getUserDataString());
            buffer.append("\n");
            if (root2 instanceof CompositeElement) {
                PsiElement[] children2;
                for (PsiElement child : children2 = psi.getChildren()) {
                    DebugUtil.treeToBufferWithUserData(buffer, (TreeElement)SourceTreeToPsiMap.psiElementToTree(child), indent + 2, skipWhiteSpaces);
                }
                if (children2.length == 0) {
                    StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                    buffer.append("<empty list>\n");
                }
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    private static void treeToBufferWithUserData(Appendable buffer, PsiElement root2, int indent, boolean skipWhiteSpaces) {
        if (skipWhiteSpaces && root2 instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            PsiElement[] children2;
            if (root2 instanceof CompositeElement) {
                buffer.append(root2.toString());
            } else {
                String text2 = DebugUtil.fixWhiteSpaces(root2.getText());
                buffer.append(root2.toString()).append("('").append(text2).append("')");
            }
            buffer.append(((UserDataHolderBase)((Object)root2)).getUserDataString());
            buffer.append("\n");
            for (PsiElement child : children2 = root2.getChildren()) {
                DebugUtil.treeToBufferWithUserData(buffer, child, indent + 2, skipWhiteSpaces);
            }
            if (children2.length == 0) {
                StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                buffer.append("<empty list>\n");
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static void doCheckTreeStructure(@Nullable ASTNode anyElement) {
        if (anyElement == null) {
            return;
        }
        ASTNode root2 = anyElement;
        while (root2.getTreeParent() != null) {
            root2 = root2.getTreeParent();
        }
        if (root2 instanceof CompositeElement) {
            DebugUtil.checkSubtree((CompositeElement)root2);
        }
    }

    private static void checkSubtree(CompositeElement root2) {
        if (root2.rawFirstChild() == null) {
            if (root2.rawLastChild() != null) {
                throw new IncorrectTreeStructureException(root2, "firstChild == null, but lastChild != null");
            }
        } else {
            for (ASTNode child = root2.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child instanceof CompositeElement) {
                    DebugUtil.checkSubtree((CompositeElement)child);
                }
                if (child.getTreeParent() != root2) {
                    throw new IncorrectTreeStructureException(child, "child has wrong parent value");
                }
                if (child == root2.getFirstChildNode()) {
                    if (child.getTreePrev() != null) {
                        throw new IncorrectTreeStructureException(root2, "firstChild.prev != null");
                    }
                } else {
                    if (child.getTreePrev() == null) {
                        throw new IncorrectTreeStructureException(child, "not first child has prev == null");
                    }
                    if (child.getTreePrev().getTreeNext() != child) {
                        throw new IncorrectTreeStructureException(child, "element.prev.next != element");
                    }
                }
                if (child.getTreeNext() != null || root2.getLastChildNode() == child) continue;
                throw new IncorrectTreeStructureException(child, "not last child has next == null");
            }
        }
    }

    public static void checkParentChildConsistent(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "checkParentChildConsistent"));
        }
        ASTNode treeParent = element.getTreeParent();
        if (treeParent == null) {
            return;
        }
        ASTNode[] elements = treeParent.getChildren(null);
        if (ArrayUtil.find(elements, element) == -1) {
            throw new IncorrectTreeStructureException(element, "child cannot be found among parents children");
        }
    }

    public static void checkSameCharTabs(@NotNull ASTNode element1, @NotNull ASTNode element2) {
        CharTable toCharTab;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "checkSameCharTabs"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "checkSameCharTabs"));
        }
        CharTable fromCharTab = SharedImplUtil.findCharTableByTree(element1);
        LOG.assertTrue(fromCharTab == (toCharTab = SharedImplUtil.findCharTableByTree(element2)));
    }

    public static String psiToString(@NotNull PsiElement element, boolean skipWhitespaces) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "psiToString"));
        }
        return DebugUtil.psiToString(element, skipWhitespaces, false);
    }

    public static String psiToString(@NotNull PsiElement root2, boolean skipWhiteSpaces, boolean showRanges) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "psiToString"));
        }
        return DebugUtil.psiToString(root2, skipWhiteSpaces, showRanges, null);
    }

    public static String psiToString(@NotNull PsiElement root2, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "psiToString"));
        }
        LengthBuilder ruler = new LengthBuilder();
        DebugUtil.psiToBuffer(ruler, root2, skipWhiteSpaces, showRanges, extra);
        StringBuilder buffer = new StringBuilder(ruler.getLength());
        DebugUtil.psiToBuffer(buffer, root2, skipWhiteSpaces, showRanges, extra);
        return buffer.toString();
    }

    private static void psiToBuffer(Appendable buffer, PsiElement root2, boolean skipWhiteSpaces, boolean showRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        ASTNode node = root2.getNode();
        if (node == null) {
            DebugUtil.psiToBuffer(buffer, root2, 0, skipWhiteSpaces, showRanges, showRanges, extra);
        } else {
            DebugUtil.treeToBuffer(buffer, node, 0, skipWhiteSpaces, showRanges, showRanges, true, extra);
        }
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root2, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "psiToBuffer"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "psiToBuffer"));
        }
        DebugUtil.psiToBuffer(buffer, root2, indent, skipWhiteSpaces, showRanges, showChildrenRanges, null);
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root2, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "psiToBuffer"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "psiToBuffer"));
        }
        if (skipWhiteSpaces && root2 instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            buffer.append(root2.toString());
            PsiElement child = root2.getFirstChild();
            if (child == null) {
                String text2 = root2.getText();
                assert (text2 != null) : "text is null for <" + root2 + ">";
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text2)).append("')");
            }
            if (showRanges) {
                buffer.append(root2.getTextRange().toString());
            }
            buffer.append("\n");
            while (child != null) {
                DebugUtil.psiToBuffer(buffer, child, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, extra);
                child = child.getNextSibling();
            }
            if (extra != null) {
                extra.consume(root2, element -> {
                    if (buffer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "lambda$psiToBuffer$0"));
                    }
                    DebugUtil.psiToBuffer(buffer, element, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, null);
                });
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static String fixWhiteSpaces(String text2) {
        text2 = StringUtil.replace(text2, "\n", "\\n");
        text2 = StringUtil.replace(text2, "\r", "\\r");
        text2 = StringUtil.replace(text2, "\t", "\\t");
        return text2;
    }

    public static String currentStackTrace() {
        return ExceptionUtil.currentStackTrace();
    }

    public static void startPsiModification(@Nullable String trace) {
        Integer depth;
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        if (ourPsiModificationTrace.get() == null) {
            ourPsiModificationTrace.set(trace != null ? trace : new Throwable());
        }
        if ((depth = ourPsiModificationDepth.get()) == null) {
            depth = 0;
        }
        ourPsiModificationDepth.set(depth + 1);
    }

    public static void finishPsiModification() {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        Integer depth = ourPsiModificationDepth.get();
        if (depth == null) {
            LOG.warn("Unmatched PSI modification end", new Throwable());
            depth = 0;
        } else {
            Integer n = depth;
            Integer n2 = depth = Integer.valueOf(depth - 1);
            ourPsiModificationDepth.set(depth);
        }
        if (depth == 0) {
            ourPsiModificationTrace.set(null);
        }
    }

    public static void onInvalidated(@NotNull ASTNode treeElement) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "onInvalidated"));
        }
        Object trace = DebugUtil.calcInvalidationTrace(treeElement);
        if (trace != null) {
            PsiInvalidElementAccessException.setInvalidationTrace(treeElement, trace);
        }
    }

    public static void onInvalidated(@NotNull PsiElement o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "onInvalidated"));
        }
        Object trace = PsiInvalidElementAccessException.getInvalidationTrace(o);
        if (trace != null) {
            return;
        }
        PsiInvalidElementAccessException.setInvalidationTrace(o, DebugUtil.currentInvalidationTrace());
    }

    public static void onInvalidated(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "onInvalidated"));
        }
        Object trace = DebugUtil.calcInvalidationTrace(null);
        if (trace != null) {
            PsiInvalidElementAccessException.setInvalidationTrace(provider, trace);
        }
    }

    @Nullable
    private static Object calcInvalidationTrace(@Nullable ASTNode treeElement) {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return null;
        }
        if (PsiInvalidElementAccessException.findInvalidationTrace(treeElement) != null) {
            return null;
        }
        return DebugUtil.currentInvalidationTrace();
    }

    @NotNull
    private static Object currentInvalidationTrace() {
        Object trace = ourPsiModificationTrace.get();
        if (trace == null && ourNonTransactedTraces.add(ExceptionUtil.getThrowableText((Throwable)(trace = new Throwable())).hashCode())) {
            LOG.info("PSI invalidated outside transaction", (Throwable)trace);
        }
        Object object = trace;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "currentInvalidationTrace"));
        }
        return object;
    }

    public static void revalidateNode(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "revalidateNode"));
        }
        PsiInvalidElementAccessException.setInvalidationTrace(element, null);
    }

    public static void sleep(long millis) {
        TimeoutUtil.sleep(millis);
    }

    public static void checkTreeStructure(ASTNode element) {
        if (CHECK) {
            DebugUtil.doCheckTreeStructure(element);
        }
    }

    @NotNull
    public static String diagnosePsiDocumentInconsistency(@NotNull PsiElement element, @NotNull Document document) {
        int docLength;
        FileViewProvider actualViewProvider;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
        }
        PsiUtilCore.ensureValid(element);
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            String string = "no file for " + element + " of " + element.getClass();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        PsiUtilCore.ensureValid(file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiDocumentManager manager = PsiDocumentManager.getInstance(file2.getProject());
        Document actualDocument = manager.getDocument(file2);
        String fileDiagnostics = "File[" + file2 + " " + file2.getName() + ", " + file2.getLanguage() + ", " + viewProvider + "]";
        if (actualDocument != document) {
            String string = "wrong document for " + fileDiagnostics + "; expected " + document + "; actual " + actualDocument;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        PsiFile cachedPsiFile = manager.getCachedPsiFile(document);
        FileViewProvider fileViewProvider = actualViewProvider = cachedPsiFile == null ? null : cachedPsiFile.getViewProvider();
        if (actualViewProvider != viewProvider) {
            String string = "wrong view provider for " + document + ", expected " + viewProvider + "; actual " + actualViewProvider;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        if (!manager.isCommitted(document)) {
            String string = "not committed document " + document + ", " + fileDiagnostics;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        int fileLength = file2.getTextLength();
        if (fileLength != (docLength = document.getTextLength())) {
            String string = "file/doc text length different, " + fileDiagnostics + " file.length=" + fileLength + "; doc.length=" + docLength;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
            }
            return string;
        }
        String string = "unknown inconsistency in " + fileDiagnostics;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil", "diagnosePsiDocumentInconsistency"));
        }
        return string;
    }

    static {
        Application application = ApplicationManager.getApplication();
        CHECK_INSIDE_ATOMIC_ACTION_ENABLED = DO_EXPENSIVE_CHECKS = application != null && application.isUnitTestMode();
        ourPsiModificationTrace = new ThreadLocal();
        ourPsiModificationDepth = new ThreadLocal();
        ourNonTransactedTraces = ContainerUtil.newConcurrentSet();
    }

    public static class IncorrectTreeStructureException
    extends RuntimeException {
        private final ASTNode myElement;

        public IncorrectTreeStructureException(ASTNode element, String message) {
            super(message);
            this.myElement = element;
        }

        public ASTNode getElement() {
            return this.myElement;
        }
    }

    private static class TreeToBuffer
    extends RecursiveTreeElementWalkingVisitor {
        final Appendable buffer;
        final boolean skipWhiteSpaces;
        final boolean showRanges;
        final boolean showChildrenRanges;
        final boolean usePsi;
        final PairConsumer<PsiElement, Consumer<PsiElement>> extra;
        int indent;

        TreeToBuffer(Appendable buffer, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, PairConsumer<PsiElement, Consumer<PsiElement>> extra) {
            this.buffer = buffer;
            this.skipWhiteSpaces = skipWhiteSpaces;
            this.showRanges = showRanges;
            this.showChildrenRanges = showChildrenRanges;
            this.usePsi = usePsi;
            this.extra = extra;
            this.indent = indent;
        }

        @Override
        protected void visitNode(TreeElement root2) {
            if (this.skipWhiteSpaces && root2.getElementType() == TokenType.WHITE_SPACE) {
                this.indent += 2;
                return;
            }
            StringUtil.repeatSymbol(this.buffer, ' ', this.indent);
            try {
                if (root2 instanceof CompositeElement) {
                    if (this.usePsi) {
                        PsiElement psiElement = root2.getPsi();
                        if (psiElement != null) {
                            this.buffer.append(psiElement.toString());
                        } else {
                            this.buffer.append(root2.getElementType().toString());
                        }
                    } else {
                        this.buffer.append(root2.toString());
                    }
                } else {
                    String text2 = DebugUtil.fixWhiteSpaces(root2.getText());
                    this.buffer.append(root2.toString()).append("('").append(text2).append("')");
                }
                if (this.showRanges) {
                    this.buffer.append(root2.getTextRange().toString());
                }
                this.buffer.append("\n");
                this.indent += 2;
                if (root2 instanceof CompositeElement && root2.getFirstChildNode() == null) {
                    StringUtil.repeatSymbol(this.buffer, ' ', this.indent);
                    this.buffer.append("<empty list>\n");
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
            super.visitNode(root2);
        }

        @Override
        protected void elementFinished(@NotNull ASTNode e) {
            PsiElement psiElement;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/com/intellij/psi/impl/DebugUtil$TreeToBuffer", "elementFinished"));
            }
            PsiElement psiElement2 = psiElement = this.extra != null && this.usePsi && e instanceof CompositeElement ? e.getPsi() : null;
            if (psiElement != null) {
                this.extra.consume(psiElement, element -> DebugUtil.treeToBuffer(this.buffer, element.getNode(), this.indent, this.skipWhiteSpaces, this.showRanges, this.showChildrenRanges, true, null));
            }
            this.indent -= 2;
        }
    }

    public static class LengthBuilder
    implements Appendable {
        private int myLength = 0;

        public int getLength() {
            return this.myLength;
        }

        @Override
        public Appendable append(CharSequence csq) {
            this.myLength += csq.length();
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) {
            this.myLength += csq.subSequence(start, end).length();
            return this;
        }

        @Override
        public Appendable append(char c) {
            ++this.myLength;
            return this;
        }
    }
}

