/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Conditions;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSet;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterator;

public abstract class TreeTraversal {
    private final String debugName;
    @NotNull
    public static final TreeTraversal PRE_ORDER_DFS = new TreeTraversal("PRE_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$6", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$6", "createIterator"));
            }
            PreOrderIt<? extends T> preOrderIt = new PreOrderIt<T>(roots2, tree);
            if (preOrderIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$6", "createIterator"));
            }
            return preOrderIt;
        }
    };
    @NotNull
    public static final TreeTraversal POST_ORDER_DFS = new TreeTraversal("POST_ORDER_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$7", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$7", "createIterator"));
            }
            PostOrderIt<? extends T> postOrderIt = new PostOrderIt<T>(roots2, tree);
            if (postOrderIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$7", "createIterator"));
            }
            return postOrderIt;
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_DFS = new TreeTraversal("LEAVES_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$8", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$8", "createIterator"));
            }
            LeavesDfsIt<? extends T> leavesDfsIt = new LeavesDfsIt<T>(roots2, tree);
            if (leavesDfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$8", "createIterator"));
            }
            return leavesDfsIt;
        }
    };
    @NotNull
    public static final TreeTraversal INTERLEAVED_DFS = new TreeTraversal("INTERLEAVED_DFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$9", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$9", "createIterator"));
            }
            InterleavedIt<? extends T> interleavedIt = new InterleavedIt<T>(roots2, tree);
            if (interleavedIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$9", "createIterator"));
            }
            return interleavedIt;
        }
    };
    @NotNull
    public static final TreeTraversal PLAIN_BFS = new TreeTraversal("PLAIN_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$10", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$10", "createIterator"));
            }
            PlainBfsIt<? extends T> plainBfsIt = new PlainBfsIt<T>(roots2, tree);
            if (plainBfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$10", "createIterator"));
            }
            return plainBfsIt;
        }
    };
    @NotNull
    public static final TreeTraversal TRACING_BFS = new TreeTraversal("TRACING_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$11", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$11", "createIterator"));
            }
            TracingBfsIt<? extends T> tracingBfsIt = new TracingBfsIt<T>(roots2, tree);
            if (tracingBfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$11", "createIterator"));
            }
            return tracingBfsIt;
        }
    };
    @NotNull
    public static final TreeTraversal LEAVES_BFS = new TreeTraversal("LEAVES_BFS"){

        @Override
        @NotNull
        public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$12", "createIterator"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$12", "createIterator"));
            }
            LeavesBfsIt<? extends T> leavesBfsIt = new LeavesBfsIt<T>(roots2, tree);
            if (leavesBfsIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$12", "createIterator"));
            }
            return leavesBfsIt;
        }
    };

    protected TreeTraversal(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "<init>"));
        }
        this.debugName = debugName;
    }

    @NotNull
    public final <T> JBIterable<T> traversal(final @NotNull Iterable<? extends T> roots2, final @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (roots2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        JBIterable jBIterable = new JBIterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                It it = TreeTraversal.this.createIterator(roots2, tree);
                if (it == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$1", "iterator"));
                }
                return it;
            }
        };
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> traversal(@Nullable T root2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        JBIterable<List<T>> jBIterable = this.traversal((T)ContainerUtil.createMaybeSingletonList(root2), tree);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "traversal"));
        }
        return jBIterable;
    }

    @NotNull
    public TreeTraversal unique(final @NotNull Function<?, ?> identity) {
        if (identity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identity", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "unique"));
        }
        final TreeTraversal original = this;
        TreeTraversal treeTraversal = new TreeTraversal(this.debugName + " (UNIQUE)"){

            @Override
            @NotNull
            public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, final @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
                if (roots2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$3", "createIterator"));
                }
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$3", "createIterator"));
                }
                if (tree instanceof WrappedTree) {
                    It<? extends T> it = original.createIterator(roots2, tree);
                    if (it == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$3", "createIterator"));
                    }
                    return it;
                }
                class WrappedTree
                implements Condition<T>,
                Function<T, Iterable<? extends T>> {
                    HashSet<Object> visited;

                    WrappedTree() {
                    }

                    @Override
                    public boolean value(T e) {
                        if (this.visited == null) {
                            this.visited = new HashSet();
                        }
                        return this.visited.add(identity.fun(e));
                    }

                    @Override
                    public Iterable<? extends T> fun(T t) {
                        return JBIterable.from((Iterable)tree.fun(t)).filter(this);
                    }
                }
                WrappedTree wrappedTree = new WrappedTree();
                It<? extends T> it = original.createIterator(JBIterable.from(roots2).filter(wrappedTree), wrappedTree);
                if (it == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$3", "createIterator"));
                }
                return it;
            }
        };
        if (treeTraversal == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "unique"));
        }
        return treeTraversal;
    }

    @NotNull
    public TreeTraversal onRange(final @NotNull Condition<?> rangeCondition) {
        if (rangeCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeCondition", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "onRange"));
        }
        final TreeTraversal original = this;
        TreeTraversal treeTraversal = new TreeTraversal(original.toString() + " (ON_RANGE)"){

            @Override
            @NotNull
            public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, final @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
                if (roots2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$4", "createIterator"));
                }
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$4", "createIterator"));
                }
                final Condition inRangeCondition = rangeCondition;
                final Condition notInRangeCondition = Conditions.not(rangeCondition);
                if (tree instanceof WrappedTree) {
                    It<? extends T> it = original.createIterator(roots2, tree);
                    if (it == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$4", "createIterator"));
                    }
                    return it;
                }
                class WrappedTree
                implements Function<T, Iterable<? extends T>> {
                    WrappedTree() {
                    }

                    @Override
                    public Iterable<? extends T> fun(T t) {
                        return JBIterable.from((Iterable)tree.fun(t)).skipWhile(notInRangeCondition).takeWhile(inRangeCondition);
                    }
                }
                WrappedTree wrappedTree = new WrappedTree();
                It<? extends T> it = original.createIterator(JBIterable.from(roots2).filter(inRangeCondition), wrappedTree);
                if (it == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$4", "createIterator"));
                }
                return it;
            }
        };
        if (treeTraversal == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "onRange"));
        }
        return treeTraversal;
    }

    @NotNull
    public abstract <T> It<T> createIterator(@NotNull Iterable<? extends T> var1, @NotNull Function<T, ? extends Iterable<? extends T>> var2);

    public final String toString() {
        return this.debugName;
    }

    @NotNull
    public static TreeTraversal GUIDED_TRAVERSAL(final @NotNull GuidedIt.Guide<?> guide) {
        if (guide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guide", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "GUIDED_TRAVERSAL"));
        }
        TreeTraversal treeTraversal = new TreeTraversal("GUIDED_TRAVERSAL"){

            @Override
            @NotNull
            public <T> It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
                if (roots2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$5", "createIterator"));
                }
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$5", "createIterator"));
                }
                GuidedItImpl<? extends T> guidedItImpl = new GuidedItImpl<T>(roots2, tree, guide);
                if (guidedItImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$5", "createIterator"));
                }
                return guidedItImpl;
            }
        };
        if (treeTraversal == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal", "GUIDED_TRAVERSAL"));
        }
        return treeTraversal;
    }

    private static final class P2<T>
    extends P<T, P2<T>> {
        P2<T> next;
        P2<T> prev;

        private P2() {
        }

        static <T> P2<T> create(T node) {
            return P2.create(new P2<T>(), node);
        }

        static <T> P2<T> create(Iterable<? extends T> it) {
            return P2.create(new P2<T>(), it);
        }

        P2<T> add(@NotNull P2<T> next) {
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$P2", "add"));
            }
            next.next = this.next;
            next.prev = this;
            this.next = next;
            return next;
        }

        P2<T> remove() {
            P2<T> p = this.prev;
            P2<T> n = this.next;
            this.next = null;
            this.prev = null;
            if (p != null) {
                p.next = n;
            }
            if (n != null) {
                n.prev = p;
            }
            return p;
        }

        public String toString() {
            int h = 0;
            int t = 0;
            P2<T> p = this.prev;
            while (p != null) {
                ++h;
                p = p.prev;
            }
            p = this.next;
            while (p != null) {
                ++t;
                p = p.next;
            }
            return h + " of " + (h + t + 1) + ": " + this.node;
        }
    }

    private static final class P1<T>
    extends P<T, P1<T>> {
        private P1() {
        }

        static <T> P1<T> create(T node) {
            return P1.create(new P1<T>(), node);
        }

        static <T> P1<T> create(Iterable<? extends T> it) {
            return P1.create(new P1<T>(), it);
        }

        P1<T> add(@NotNull P1<T> next) {
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$P1", "add"));
            }
            next.parent = this;
            return next;
        }

        P1<T> remove() {
            P1 p = (P1)this.parent;
            this.parent = null;
            return p;
        }

        public String toString() {
            int h = 0;
            P1 p = (P1)this.parent;
            while (p != null) {
                ++h;
                p = (P1)p.parent;
            }
            return h + ": " + this.node;
        }
    }

    private static class P<T, Self extends P<T, Self>> {
        T node;
        Iterable<? extends T> itle;
        Iterator<? extends T> it;
        boolean empty;
        Self parent;
        static final Function TO_NODE = new Function<P<?, ?>, Object>(){

            @Override
            public Object fun(P<?, ?> tp) {
                return tp.node;
            }
        };
        static final Function TO_PREV = new Function.Mono<P<?, ?>>(){

            @Override
            public P<?, ?> fun(P<?, ?> tp) {
                return tp.parent;
            }
        };

        private P() {
        }

        static <T, Self extends P<T, Self>> Self create(Self p, T node) {
            p.node = node;
            return p;
        }

        static <T, Self extends P<T, Self>> Self create(Self p, Iterable<? extends T> it) {
            p.itle = it;
            return p;
        }

        final Iterator<? extends T> iterator(@NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$P", "iterator"));
            }
            if (this.it != null) {
                return this.it;
            }
            this.it = this.iterable(tree).iterator();
            this.empty = this.itle == null || !this.it.hasNext();
            return this.it;
        }

        final Iterable<? extends T> iterable(@NotNull Function<T, ? extends Iterable<? extends T>> tree) {
            Iterable<? extends T> iterable;
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$P", "iterable"));
            }
            if (this.itle != null) {
                iterable = this.itle;
            } else {
                this.itle = tree.fun(this.node);
                iterable = JBIterable.from(this.itle);
            }
            return iterable;
        }
    }

    private static final class GuidedItImpl<T>
    extends GuidedIt<T> {
        final GuidedIt.Guide<T> guide;
        P1<T> first;
        P1<T> last;
        T curResult;

        GuidedItImpl(@NotNull Iterable<? extends T> roots2, @NotNull Function<T, ? extends Iterable<? extends T>> tree, @NotNull GuidedIt.Guide<T> guide) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$GuidedItImpl", "<init>"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$GuidedItImpl", "<init>"));
            }
            if (guide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guide", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$GuidedItImpl", "<init>"));
            }
            super(tree);
            this.last = P1.create(roots2);
            this.first = this.last;
            this.guide = guide;
        }

        @Override
        public GuidedIt<T> queueNext(T child) {
            if (child != null) {
                this.last = this.last.add(P1.create(child));
            }
            return this;
        }

        @Override
        public GuidedIt<T> result(T node) {
            this.curResult = node;
            return this;
        }

        @Override
        public T nextImpl() {
            if (this.guide == null) {
                return (T)this.stop();
            }
            while (this.last != null) {
                P1<T> top = this.last;
                Iterator it = top.iterator(this.tree);
                boolean hasNext = it.hasNext();
                this.curResult = null;
                if (top.node != null || hasNext) {
                    this.curChild = hasNext ? it.next() : null;
                    this.curParent = top.node;
                    this.curChildren = top.itle;
                    this.curNoChildren = top.empty;
                    this.guide.guide(this);
                }
                if (!hasNext) {
                    this.last = this.last.remove();
                }
                if (this.curResult == null) continue;
                return this.curResult;
            }
            return (T)this.stop();
        }
    }

    private static final class TracingBfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<T> queue;
        final Map<T, T> paths;
        P1<T> top;

        TracingBfsIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$TracingBfsIt", "<init>"));
            }
            super(tree);
            this.queue = new ArrayDeque();
            this.paths = ContainerUtil.newTroveMap(ContainerUtil.identityStrategy());
            JBIterable.from(roots2).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                for (Object t : this.top.iterable(this.tree)) {
                    if (this.paths.containsKey(t)) continue;
                    this.queue.add(t);
                    this.paths.put(t, this.top.node);
                }
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P1.create(this.queue.remove());
            return (T)this.top.node;
        }
    }

    private static final class LeavesBfsIt<T>
    extends TracingIt<T> {
        final ArrayDeque<T> queue;

        LeavesBfsIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$LeavesBfsIt", "<init>"));
            }
            super(tree);
            this.queue = new ArrayDeque();
            JBIterable.from(roots2).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            while (!this.queue.isEmpty()) {
                Iterator it;
                T result2 = this.queue.remove();
                Iterable children2 = (Iterable)this.tree.fun(result2);
                Iterator iterator2 = it = children2 == null ? null : children2.iterator();
                if (it == null || !it.hasNext()) {
                    return result2;
                }
                while (it.hasNext()) {
                    this.queue.add(it.next());
                }
            }
            return (T)this.stop();
        }
    }

    private static final class PlainBfsIt<T>
    extends It<T> {
        final ArrayDeque<T> queue;
        P1<T> top;

        PlainBfsIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$PlainBfsIt", "<init>"));
            }
            super(tree);
            this.queue = new ArrayDeque();
            JBIterable.from(roots2).addAllTo(this.queue);
        }

        @Override
        public T nextImpl() {
            if (this.top != null) {
                JBIterable.from(this.top.iterable(this.tree)).addAllTo(this.queue);
                this.top = null;
            }
            if (this.queue.isEmpty()) {
                return (T)this.stop();
            }
            this.top = P1.create(this.queue.remove());
            return (T)this.top.node;
        }
    }

    private static final class InterleavedIt<T>
    extends DfsIt<T, P2<T>> {
        P2<T> cur;
        P2<T> max;

        InterleavedIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$InterleavedIt", "<init>"));
            }
            super(tree);
            this.last = P2.create(roots2);
            this.cur = this.max = (P2)this.last;
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Iterator it;
                if (this.cur == null) {
                    this.cur = this.max;
                    this.max = this.max.next;
                }
                if ((it = this.cur.iterator(this.tree)).hasNext()) {
                    Object result2 = it.next();
                    this.last = ((P2)this.last).add(P2.create(result2));
                    ((P2)this.last).parent = this.cur;
                    this.cur = this.cur.prev;
                    if (this.max == null) {
                        this.max = (P2)this.last;
                    }
                    return result2;
                }
                if (this.cur == this.last) {
                    this.last = this.cur.prev;
                }
                this.cur = this.cur.remove();
            }
            return (T)this.stop();
        }
    }

    private static final class LeavesDfsIt<T>
    extends DfsIt<T, P1<T>> {
        LeavesDfsIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$LeavesDfsIt", "<init>"));
            }
            super(tree);
            this.last = P1.create(roots2);
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                P1 top = (P1)this.last;
                if (top.iterator(this.tree).hasNext() && !top.empty) {
                    Object child = top.iterator(this.tree).next();
                    this.last = ((P1)this.last).add(P1.create(child));
                    continue;
                }
                this.last = ((P1)this.last).remove();
                if (!top.empty) continue;
                return (T)(this.last == null ? this.stop() : top.node);
            }
            return (T)this.stop();
        }
    }

    private static final class PostOrderIt<T>
    extends DfsIt<T, P1<T>> {
        PostOrderIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$PostOrderIt", "<init>"));
            }
            super(tree);
            for (T root2 : roots2) {
                P1<T> p = P1.create(root2);
                this.last = this.last == null ? p : ((P1)this.last).add(p);
            }
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Object result2;
                Iterator it = ((P1)this.last).iterator(this.tree);
                if (it.hasNext()) {
                    result2 = it.next();
                    this.last = ((P1)this.last).add(P1.create(result2));
                    continue;
                }
                result2 = ((P1)this.last).node;
                this.last = ((P1)this.last).remove();
                return result2;
            }
            return (T)this.stop();
        }
    }

    private static final class PreOrderIt<T>
    extends DfsIt<T, P1<T>> {
        PreOrderIt(@NotNull Iterable<? extends T> roots2, Function<T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/util/containers/TreeTraversal$PreOrderIt", "<init>"));
            }
            super(tree);
            this.last = P1.create(roots2);
        }

        @Override
        public T nextImpl() {
            while (this.last != null) {
                Iterator it = ((P1)this.last).iterator(this.tree);
                if (it.hasNext()) {
                    Object result2 = it.next();
                    this.last = ((P1)this.last).add(P1.create(result2));
                    return result2;
                }
                this.last = ((P1)this.last).remove();
            }
            return (T)this.stop();
        }
    }

    private static abstract class DfsIt<T, H extends P<T, H>>
    extends TracingIt<T> {
        H last;

        protected DfsIt(Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }
    }

    public static abstract class GuidedIt<T>
    extends It<T> {
        @Nullable
        public T curChild;
        @Nullable
        public T curParent;
        @Nullable
        public Iterable<? extends T> curChildren;
        public boolean curNoChildren;

        public abstract GuidedIt<T> queueNext(@Nullable T var1);

        public abstract GuidedIt<T> result(@Nullable T var1);

        protected GuidedIt(Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }

        public static interface Guide<T> {
            public void guide(@NotNull GuidedIt<T> var1);
        }
    }

    public static abstract class TracingIt<T>
    extends It<T> {
        protected TracingIt(Function<T, ? extends Iterable<? extends T>> tree) {
            super(tree);
        }
    }

    public static abstract class It<T>
    extends JBIterator<T> {
        protected final Function<T, ? extends Iterable<? extends T>> tree;

        protected It(Function<T, ? extends Iterable<? extends T>> tree) {
            this.tree = tree;
        }
    }
}

