/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;
import org.jetbrains.kotlin.util.ExtensionProvider;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 *2\u00020\u0001:\b*+,-./01B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u000eH&J\u001e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0002J(\u0010\"\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0004J\u001e\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(2\u0006\u0010)\u001a\u00020\u0018H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "", "()V", "diagnosticSuppressors", "Lorg/jetbrains/kotlin/util/ExtensionProvider;", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticSuppressor;", "filter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "getFilter", "()Lkotlin/jvm/functions/Function1;", "suppressors", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "getOrCreateSuppressor", "annotated", "getSuppressingStrings", "", "", "getSuppressionAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "isSuppressed", "psiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "suppressionKey", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "diagnostic", "request", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SuppressRequest;", "isSuppressedByAnnotated", "debugDepth", "", "processAnnotation", "", "builder", "Lorg/jetbrains/kotlin/com/google/common/collect/ImmutableSet$Builder;", "annotationDescriptor", "Companion", "DiagnosticSuppressRequest", "EmptySuppressor", "MultiSuppressor", "SingularSuppressor", "StringSuppressRequest", "SuppressRequest", "Suppressor", "frontend"})
public abstract class KotlinSuppressCache {
    private final ExtensionProvider<DiagnosticSuppressor> diagnosticSuppressors = ExtensionProvider.Companion.create(DiagnosticSuppressor.Companion.getEP_NAME());
    private final ConcurrentMap<KtAnnotated, Suppressor> suppressors = ContainerUtil.createConcurrentWeakValueMap();
    @NotNull
    private final Function1<Diagnostic, Boolean> filter = (Function1)new Function1<Diagnostic, Boolean>(this){
        final /* synthetic */ KotlinSuppressCache this$0;

        public final boolean invoke(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            return !this.this$0.isSuppressed(diagnostic);
        }
        {
            this.this$0 = kotlinSuppressCache;
            super(1);
        }
    };
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Function1<Diagnostic, Boolean> getFilter() {
        return this.filter;
    }

    public final boolean isSuppressed(@NotNull PsiElement psiElement, @NotNull String suppressionKey, @NotNull Severity severity) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
        Intrinsics.checkParameterIsNotNull((Object)suppressionKey, (String)"suppressionKey");
        Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
        String string2 = suppressionKey;
        Severity severity2 = severity;
        PsiElement psiElement2 = psiElement;
        KotlinSuppressCache kotlinSuppressCache = this;
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string = string3;
        Severity severity3 = severity2;
        PsiElement psiElement3 = psiElement2;
        return kotlinSuppressCache.isSuppressed(new StringSuppressRequest(psiElement3, severity3, string4));
    }

    public final boolean isSuppressed(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        return this.isSuppressed(new DiagnosticSuppressRequest(diagnostic));
    }

    private final boolean isSuppressed(SuppressRequest request) {
        PsiElement element = request.getElement();
        if (!element.isValid()) {
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null) {
            return true;
        }
        if (request instanceof DiagnosticSuppressRequest) {
            for (DiagnosticSuppressor suppressor : (List)this.diagnosticSuppressors.get()) {
                if (!suppressor.isSuppressed(((DiagnosticSuppressRequest)request).getDiagnostic())) continue;
                return true;
            }
        }
        KtAnnotated ktAnnotated = KtStubbedPsiUtil.getPsiOrStubParent(element, KtAnnotated.class, false);
        if (ktAnnotated == null) {
            return false;
        }
        KtAnnotated annotated = ktAnnotated;
        String string = request.getSuppressKey();
        Severity severity = request.getSeverity();
        KtAnnotated ktAnnotated2 = annotated;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotated2, (String)"annotated");
        return this.isSuppressedByAnnotated(string, severity, ktAnnotated2, 0);
    }

    protected final boolean isSuppressedByAnnotated(@NotNull String suppressionKey, @NotNull Severity severity, @NotNull KtAnnotated annotated, int debugDepth) {
        KtAnnotated annotatedAbove;
        Intrinsics.checkParameterIsNotNull((Object)suppressionKey, (String)"suppressionKey");
        Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
        Intrinsics.checkParameterIsNotNull((Object)annotated, (String)"annotated");
        Suppressor suppressor = this.getOrCreateSuppressor(annotated);
        if (suppressor.isSuppressed(suppressionKey, severity)) {
            return true;
        }
        KtAnnotated ktAnnotated = KtStubbedPsiUtil.getPsiOrStubParent(suppressor.getAnnotatedElement(), KtAnnotated.class, true);
        if (ktAnnotated == null) {
            return false;
        }
        KtAnnotated ktAnnotated2 = annotatedAbove = ktAnnotated;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotated2, (String)"annotatedAbove");
        boolean suppressed = this.isSuppressedByAnnotated(suppressionKey, severity, ktAnnotated2, debugDepth + 1);
        Suppressor suppressorAbove = (Suppressor)this.suppressors.get(annotatedAbove);
        if (suppressorAbove != null && suppressorAbove.dominates(suppressor)) {
            this.suppressors.put(annotated, suppressorAbove);
        }
        return suppressed;
    }

    private final Suppressor getOrCreateSuppressor(KtAnnotated annotated) {
        Suppressor suppressor = (Suppressor)this.suppressors.get(annotated);
        if (suppressor == null) {
            Set<String> strings = this.getSuppressingStrings(annotated);
            suppressor = strings.isEmpty() ? (Suppressor)new EmptySuppressor(annotated) : (strings.size() == 1 ? (Suppressor)new SingularSuppressor(annotated, strings.iterator().next()) : (Suppressor)new MultiSuppressor(annotated, strings));
            this.suppressors.put(annotated, suppressor);
        }
        return suppressor;
    }

    @NotNull
    public abstract List<AnnotationDescriptor> getSuppressionAnnotations(@NotNull KtAnnotated var1);

    private final Set<String> getSuppressingStrings(KtAnnotated annotated) {
        ImmutableSet.Builder<String> builder = ImmutableSet.builder();
        for (AnnotationDescriptor annotationDescriptor : this.getSuppressionAnnotations(annotated)) {
            ImmutableSet.Builder<String> builder2 = builder;
            Intrinsics.checkExpressionValueIsNotNull(builder2, (String)"builder");
            this.processAnnotation(builder2, annotationDescriptor);
        }
        ImmutableSet immutableSet = builder.build();
        Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"builder.build()");
        return immutableSet;
    }

    private final void processAnnotation(ImmutableSet.Builder<String> builder, AnnotationDescriptor annotationDescriptor) {
        if (Intrinsics.areEqual((Object)annotationDescriptor.getFqName(), (Object)KotlinBuiltIns.FQ_NAMES.suppress) ^ true) {
            return;
        }
        for (ConstantValue<?> arrayValue : annotationDescriptor.getAllValueArguments().values()) {
            if (!(arrayValue instanceof ArrayValue)) continue;
            for (ConstantValue value : (List)((ArrayValue)arrayValue).getValue()) {
                String string;
                if (!(value instanceof StringValue)) continue;
                String string2 = (String)((StringValue)value).getValue();
                ImmutableSet.Builder<String> builder2 = builder;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                builder2.add((Object)string);
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0000H&J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "", "annotatedElement", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;)V", "getAnnotatedElement", "()Lorg/jetbrains/kotlin/psi/KtAnnotated;", "dominates", "", "other", "isSuppressed", "suppressionKey", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "frontend"})
    private static abstract class Suppressor {
        @NotNull
        private final KtAnnotated annotatedElement;

        public abstract boolean isSuppressed(@NotNull Diagnostic var1);

        public abstract boolean isSuppressed(@NotNull String var1, @NotNull Severity var2);

        public abstract boolean dominates(@NotNull Suppressor var1);

        @NotNull
        public final KtAnnotated getAnnotatedElement() {
            return this.annotatedElement;
        }

        protected Suppressor(@NotNull KtAnnotated annotatedElement) {
            Intrinsics.checkParameterIsNotNull((Object)annotatedElement, (String)"annotatedElement");
            this.annotatedElement = annotatedElement;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0016J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$EmptySuppressor;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;)V", "dominates", "", "other", "isSuppressed", "suppressionKey", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "frontend"})
    private static final class EmptySuppressor
    extends Suppressor {
        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            return false;
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkParameterIsNotNull((Object)suppressionKey, (String)"suppressionKey");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            return false;
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return other instanceof EmptySuppressor;
        }

        public EmptySuppressor(@NotNull KtAnnotated annotated) {
            Intrinsics.checkParameterIsNotNull((Object)annotated, (String)"annotated");
            super(annotated);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0016J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SingularSuppressor;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "string", "", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;Ljava/lang/String;)V", "dominates", "", "other", "isSuppressed", "suppressionKey", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "frontend"})
    private static final class SingularSuppressor
    extends Suppressor {
        private final String string;

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            String string = Companion.getDiagnosticSuppressKey(diagnostic);
            Severity severity = diagnostic.getSeverity();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)severity), (String)"diagnostic.severity");
            return this.isSuppressed(string, severity);
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkParameterIsNotNull((Object)suppressionKey, (String)"suppressionKey");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            ImmutableSet<String> immutableSet = ImmutableSet.of(this.string);
            Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"ImmutableSet.of(string)");
            return Companion.isSuppressedByStrings(suppressionKey, (Set<String>)immutableSet, severity);
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return other instanceof EmptySuppressor || other instanceof SingularSuppressor && Intrinsics.areEqual((Object)((SingularSuppressor)other).string, (Object)this.string);
        }

        public SingularSuppressor(@NotNull KtAnnotated annotated, @NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)annotated, (String)"annotated");
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            super(annotated);
            this.string = string;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$MultiSuppressor;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Suppressor;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "strings", "", "", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;Ljava/util/Set;)V", "dominates", "", "other", "isSuppressed", "suppressionKey", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "frontend"})
    private static final class MultiSuppressor
    extends Suppressor {
        private final Set<String> strings;

        @Override
        public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            String string = Companion.getDiagnosticSuppressKey(diagnostic);
            Severity severity = diagnostic.getSeverity();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)severity), (String)"diagnostic.severity");
            return this.isSuppressed(string, severity);
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkParameterIsNotNull((Object)suppressionKey, (String)"suppressionKey");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            return Companion.isSuppressedByStrings(suppressionKey, this.strings, severity);
        }

        @Override
        public boolean dominates(@NotNull Suppressor other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return other instanceof EmptySuppressor;
        }

        public MultiSuppressor(@NotNull KtAnnotated annotated, @NotNull Set<String> strings) {
            Intrinsics.checkParameterIsNotNull((Object)annotated, (String)"annotated");
            Intrinsics.checkParameterIsNotNull(strings, (String)"strings");
            super(annotated);
            this.strings = strings;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SuppressRequest;", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getElement", "()Lcom/intellij/psi/PsiElement;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "getSuppressKey", "()Ljava/lang/String;", "frontend"})
    private static interface SuppressRequest {
        @NotNull
        public PsiElement getElement();

        @NotNull
        public Severity getSeverity();

        @NotNull
        public String getSuppressKey();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$StringSuppressRequest;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SuppressRequest;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/Severity;Ljava/lang/String;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSuppressKey", "()Ljava/lang/String;", "frontend"})
    private static final class StringSuppressRequest
    implements SuppressRequest {
        @NotNull
        private final PsiElement element;
        @NotNull
        private final Severity severity;
        @NotNull
        private final String suppressKey;

        @Override
        @NotNull
        public PsiElement getElement() {
            return this.element;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return this.severity;
        }

        @Override
        @NotNull
        public String getSuppressKey() {
            return this.suppressKey;
        }

        public StringSuppressRequest(@NotNull PsiElement element, @NotNull Severity severity, @NotNull String suppressKey) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)suppressKey, (String)"suppressKey");
            this.element = element;
            this.severity = severity;
            this.suppressKey = suppressKey;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$DiagnosticSuppressRequest;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$SuppressRequest;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "getDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getElement", "()Lcom/intellij/psi/PsiElement;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "getSuppressKey", "()Ljava/lang/String;", "frontend"})
    private static final class DiagnosticSuppressRequest
    implements SuppressRequest {
        @NotNull
        private final Diagnostic diagnostic;

        @Override
        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"diagnostic.psiElement");
            return psiElement;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            Severity severity = this.diagnostic.getSeverity();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)severity), (String)"diagnostic.severity");
            return severity;
        }

        @Override
        @NotNull
        public String getSuppressKey() {
            return Companion.getDiagnosticSuppressKey(this.diagnostic);
        }

        @NotNull
        public final Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        public DiagnosticSuppressRequest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            this.diagnostic = diagnostic;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Companion;", "", "()V", "getDiagnosticSuppressKey", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isSuppressedByStrings", "", "key", "strings", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "frontend"})
    public static final class Companion {
        @NotNull
        public final String getDiagnosticSuppressKey(@NotNull Diagnostic diagnostic) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
            String string2 = diagnosticFactory.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"diagnostic.factory.name");
            String string3 = string = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            return string4;
        }

        public final boolean isSuppressedByStrings(@NotNull String key, @NotNull Set<String> strings, @NotNull Severity severity) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull(strings, (String)"strings");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            if (strings.contains("warnings") && Intrinsics.areEqual((Object)((Object)severity), (Object)((Object)Severity.WARNING))) {
                return true;
            }
            return strings.contains(key);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

