/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.VariantResolveMetadata;

public class DefaultLocalComponentMetadata
implements LocalComponentMetadata,
BuildableLocalComponentMetadata {
    private final Map<String, DefaultLocalConfigurationMetadata> allConfigurations = Maps.newLinkedHashMap();
    private final Multimap<String, LocalComponentArtifactMetadata> allArtifacts = ArrayListMultimap.create();
    private final SetMultimap<String, DefaultVariantMetadata> allVariants = LinkedHashMultimap.create();
    private final ModuleVersionIdentifier id;
    private final ComponentIdentifier componentIdentifier;
    private final String status;
    private final AttributesSchemaInternal attributesSchema;
    private ImmutableList<ConfigurationMetadata> consumableConfigurations;

    public DefaultLocalComponentMetadata(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier, String status, AttributesSchemaInternal attributesSchema) {
        this.id = id;
        this.componentIdentifier = componentIdentifier;
        this.status = status;
        this.attributesSchema = attributesSchema;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    public DefaultLocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts, Transformer<LocalOriginDependencyMetadata, LocalOriginDependencyMetadata> dependencies) {
        DefaultLocalComponentMetadata copy = new DefaultLocalComponentMetadata(this.id, componentIdentifier, this.status, this.attributesSchema);
        for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
            copy.addConfiguration(configuration.getName(), configuration.description, configuration.extendsFrom, configuration.hierarchy, configuration.visible, configuration.transitive, configuration.attributes, configuration.canBeConsumed, configuration.canBeResolved);
        }
        HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts = new HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>();
        for (Map.Entry entry : this.allArtifacts.entries()) {
            LocalComponentArtifactMetadata oldArtifact = (LocalComponentArtifactMetadata)entry.getValue();
            LocalComponentArtifactMetadata newArtifact = this.copyArtifact(oldArtifact, artifacts, transformedArtifacts);
            copy.allArtifacts.put(entry.getKey(), (Object)newArtifact);
        }
        for (Map.Entry entry : this.allVariants.entries()) {
            DefaultVariantMetadata oldVariant = (DefaultVariantMetadata)entry.getValue();
            ArrayList<LocalComponentArtifactMetadata> newArtifacts = new ArrayList<LocalComponentArtifactMetadata>(oldVariant.getArtifacts().size());
            for (ComponentArtifactMetadata componentArtifactMetadata : oldVariant.getArtifacts()) {
                newArtifacts.add(this.copyArtifact((LocalComponentArtifactMetadata)componentArtifactMetadata, artifacts, transformedArtifacts));
            }
            copy.allVariants.put(entry.getKey(), (Object)new DefaultVariantMetadata(oldVariant.asDescribable(), oldVariant.getAttributes(), newArtifacts));
        }
        for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
            configuration.realizeDependencies();
            DefaultLocalConfigurationMetadata configurationCopy = copy.allConfigurations.get(configuration.getName());
            for (LocalOriginDependencyMetadata dependency : configuration.definedDependencies) {
                configurationCopy.definedDependencies.add(dependencies.transform((Object)dependency));
            }
            configurationCopy.definedExcludes.addAll(configuration.definedExcludes);
        }
        return copy;
    }

    private LocalComponentArtifactMetadata copyArtifact(LocalComponentArtifactMetadata oldArtifact, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer, Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts) {
        LocalComponentArtifactMetadata newArtifact = transformedArtifacts.get(oldArtifact);
        if (newArtifact == null) {
            newArtifact = (LocalComponentArtifactMetadata)transformer.transform((Object)oldArtifact);
            transformedArtifacts.put(oldArtifact, newArtifact);
        }
        return newArtifact;
    }

    @Override
    public void addArtifacts(String configuration, Iterable<? extends PublishArtifact> artifacts) {
        for (PublishArtifact publishArtifact : artifacts) {
            PublishArtifactLocalArtifactMetadata artifactMetadata = new PublishArtifactLocalArtifactMetadata(this.componentIdentifier, publishArtifact);
            this.allArtifacts.put((Object)configuration, (Object)artifactMetadata);
        }
    }

    @Override
    public void addVariant(String configuration, OutgoingVariant variant) {
        ImmutableList artifacts;
        if (variant.getArtifacts().isEmpty()) {
            artifacts = ImmutableList.of();
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (PublishArtifact publishArtifact : variant.getArtifacts()) {
                builder.add((Object)new PublishArtifactLocalArtifactMetadata(this.componentIdentifier, publishArtifact));
            }
            artifacts = builder.build();
        }
        this.allVariants.put((Object)configuration, (Object)new DefaultVariantMetadata(variant.asDescribable(), (AttributeContainerInternal)variant.getAttributes().asImmutable(), (List<? extends ComponentArtifactMetadata>)artifacts));
    }

    @Override
    public BuildableLocalConfigurationMetadata addConfiguration(String name, String description, Set<String> extendsFrom, Set<String> hierarchy, boolean visible, boolean transitive, ImmutableAttributes attributes, boolean canBeConsumed, boolean canBeResolved) {
        assert (hierarchy.contains(name));
        DefaultLocalConfigurationMetadata conf = new DefaultLocalConfigurationMetadata(name, description, visible, transitive, extendsFrom, hierarchy, attributes, canBeConsumed, canBeResolved);
        this.allConfigurations.put(name, conf);
        return conf;
    }

    @Override
    public void addDependenciesAndExcludesForConfiguration(ConfigurationInternal configuration, LocalConfigurationMetadataBuilder localConfigurationMetadataBuilder) {
        DefaultLocalConfigurationMetadata configurationMetadata = this.allConfigurations.get(configuration.getName());
        configurationMetadata.configurationMetadataBuilder = localConfigurationMetadataBuilder;
        configurationMetadata.backingConfiguration = configuration;
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    public ModuleSource getSource() {
        return null;
    }

    @Override
    public ComponentResolveMetadata withSource(ModuleSource source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return DEFAULT_STATUS_SCHEME;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.allConfigurations.keySet();
    }

    @Override
    public synchronized ImmutableList<? extends ConfigurationMetadata> getVariantsForGraphTraversal() {
        if (this.consumableConfigurations == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (DefaultLocalConfigurationMetadata metadata : this.allConfigurations.values()) {
                if (!metadata.isCanBeConsumed() || metadata.getAttributes().isEmpty()) continue;
                builder.add((Object)metadata);
            }
            this.consumableConfigurations = builder.build();
        }
        return this.consumableConfigurations;
    }

    @Override
    public DefaultLocalConfigurationMetadata getConfiguration(String name) {
        return this.allConfigurations.get(name);
    }

    @Override
    public AttributesSchemaInternal getAttributesSchema() {
        return this.attributesSchema;
    }

    public AttributeContainer getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    protected class DefaultLocalConfigurationMetadata
    implements LocalConfigurationMetadata,
    BuildableLocalConfigurationMetadata {
        private final String name;
        private final String description;
        private final boolean transitive;
        private final boolean visible;
        private final Set<String> hierarchy;
        private final Set<String> extendsFrom;
        private final ImmutableAttributes attributes;
        private final boolean canBeConsumed;
        private final boolean canBeResolved;
        private ConfigurationInternal backingConfiguration;
        private LocalConfigurationMetadataBuilder configurationMetadataBuilder;
        private List<LocalOriginDependencyMetadata> definedDependencies = Lists.newArrayList();
        private List<ExcludeMetadata> definedExcludes = Lists.newArrayList();
        private List<LocalFileDependencyMetadata> definedFiles = Lists.newArrayList();
        private ImmutableList<LocalOriginDependencyMetadata> configurationDependencies;
        private ImmutableSet<LocalFileDependencyMetadata> configurationFileDependencies;
        private ImmutableList<ExcludeMetadata> configurationExcludes;
        private List<LocalComponentArtifactMetadata> configurationArtifacts;

        private DefaultLocalConfigurationMetadata(String name, String description, boolean visible, boolean transitive, Set<String> extendsFrom, Set<String> hierarchy, ImmutableAttributes attributes, boolean canBeConsumed, boolean canBeResolved) {
            this.name = name;
            this.description = description;
            this.transitive = transitive;
            this.visible = visible;
            this.hierarchy = hierarchy;
            this.extendsFrom = extendsFrom;
            this.attributes = attributes;
            this.canBeConsumed = canBeConsumed;
            this.canBeResolved = canBeResolved;
        }

        @Override
        public ComponentIdentifier getComponentId() {
            return DefaultLocalComponentMetadata.this.componentIdentifier;
        }

        @Override
        public void addDependency(LocalOriginDependencyMetadata dependency) {
            this.definedDependencies.add(dependency);
        }

        @Override
        public void addExclude(ExcludeMetadata exclude) {
            this.definedExcludes.add(exclude);
        }

        @Override
        public void addFiles(LocalFileDependencyMetadata files) {
            this.definedFiles.add(files);
        }

        public String toString() {
            return this.asDescribable().getDisplayName();
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of((Object)DefaultLocalComponentMetadata.this.componentIdentifier, (Object)"configuration", (Object)this.name);
        }

        public ComponentResolveMetadata getComponent() {
            return DefaultLocalComponentMetadata.this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Set<String> getExtendsFrom() {
            return this.extendsFrom;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Collection<String> getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        @Override
        public Set<? extends VariantResolveMetadata> getVariants() {
            return DefaultLocalComponentMetadata.this.allVariants.get((Object)this.name);
        }

        @Override
        public boolean isCanBeConsumed() {
            return this.canBeConsumed;
        }

        @Override
        public boolean isCanBeResolved() {
            return this.canBeResolved;
        }

        @Override
        public List<? extends LocalOriginDependencyMetadata> getDependencies() {
            if (this.configurationDependencies == null) {
                ImmutableList.Builder result = ImmutableList.builder();
                for (DefaultLocalConfigurationMetadata configuration : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration)) continue;
                    configuration.addDefinedDependencies((ImmutableList.Builder<LocalOriginDependencyMetadata>)result);
                }
                this.configurationDependencies = result.build();
            }
            return this.configurationDependencies;
        }

        void addDefinedDependencies(ImmutableList.Builder<LocalOriginDependencyMetadata> result) {
            this.realizeDependencies();
            result.addAll(this.definedDependencies);
        }

        @Override
        public Set<LocalFileDependencyMetadata> getFiles() {
            if (this.configurationFileDependencies == null) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (DefaultLocalConfigurationMetadata configuration : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration)) continue;
                    configuration.addDefinedFiles((ImmutableSet.Builder<LocalFileDependencyMetadata>)result);
                }
                this.configurationFileDependencies = result.build();
            }
            return this.configurationFileDependencies;
        }

        void addDefinedFiles(ImmutableSet.Builder<LocalFileDependencyMetadata> result) {
            this.realizeDependencies();
            result.addAll(this.definedFiles);
        }

        @Override
        public ImmutableList<ExcludeMetadata> getExcludes() {
            if (this.configurationExcludes == null) {
                ImmutableList.Builder result = ImmutableList.builder();
                for (DefaultLocalConfigurationMetadata configuration : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration)) continue;
                    configuration.addDefinedExcludes((ImmutableList.Builder<ExcludeMetadata>)result);
                }
                this.configurationExcludes = result.build();
            }
            return this.configurationExcludes;
        }

        void addDefinedExcludes(ImmutableList.Builder<ExcludeMetadata> result) {
            this.realizeDependencies();
            result.addAll(this.definedExcludes);
        }

        @Override
        public List<? extends LocalComponentArtifactMetadata> getArtifacts() {
            if (this.configurationArtifacts == null) {
                if (DefaultLocalComponentMetadata.this.allArtifacts.isEmpty()) {
                    this.configurationArtifacts = ImmutableList.of();
                } else {
                    ImmutableList.Builder result = ImmutableList.builder();
                    for (String config : this.hierarchy) {
                        result.addAll((Iterable)DefaultLocalComponentMetadata.this.allArtifacts.get((Object)config));
                    }
                    this.configurationArtifacts = result.build();
                }
            }
            return this.configurationArtifacts;
        }

        @Override
        public ComponentArtifactMetadata artifact(IvyArtifactName ivyArtifactName) {
            for (ComponentArtifactMetadata componentArtifactMetadata : this.getArtifacts()) {
                if (!componentArtifactMetadata.getName().equals(ivyArtifactName)) continue;
                return componentArtifactMetadata;
            }
            return new MissingLocalArtifactMetadata(DefaultLocalComponentMetadata.this.componentIdentifier, ivyArtifactName);
        }

        private boolean include(DefaultLocalConfigurationMetadata configuration) {
            return this.hierarchy.contains(configuration.getName());
        }

        synchronized void realizeDependencies() {
            if (this.backingConfiguration != null) {
                this.backingConfiguration.runDependencyActions();
                this.configurationMetadataBuilder.addDependenciesAndExcludes(this, this.backingConfiguration);
                this.backingConfiguration = null;
            }
        }
    }
}

