/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestExecutable;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestSuite;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;

@Incubating
public class CppUnitTestPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;

    @Inject
    public CppUnitTestPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        final DefaultCppTestSuite testComponent = (DefaultCppTestSuite)this.componentFactory.newInstance(CppTestSuite.class, DefaultCppTestSuite.class, "test");
        project.getExtensions().add(CppTestSuite.class, "unitTest", (Object)testComponent);
        project.getComponents().add((Object)testComponent);
        testComponent.getBaseName().set((Object)(project.getName() + "Test"));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                ToolChainSelector.Result result = CppUnitTestPlugin.this.toolChainSelector.select(CppPlatform.class);
                testComponent.addExecutable("executable", (CppPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                final TaskContainer tasks = project.getTasks();
                final ProductionCppComponent mainComponent = (ProductionCppComponent)project.getComponents().withType(ProductionCppComponent.class).findByName("main");
                if (mainComponent != null) {
                    testComponent.getTestedComponent().set((Object)mainComponent);
                }
                testComponent.getBinaries().whenElementKnown(DefaultCppTestExecutable.class, (Action)new Action<DefaultCppTestExecutable>(){

                    public void execute(final DefaultCppTestExecutable executable) {
                        if (mainComponent != null) {
                            mainComponent.getBinaries().whenElementFinalized((Action)new Action<CppBinary>(){

                                public void execute(CppBinary cppBinary) {
                                    if (cppBinary == mainComponent.getDevelopmentBinary().get()) {
                                        AbstractLinkTask linkTest = (AbstractLinkTask)executable.getLinkTask().get();
                                        linkTest.source((Object)cppBinary.getObjects());
                                    }
                                }
                            });
                        }
                        RunTestExecutable testTask = (RunTestExecutable)tasks.create(executable.getNames().getTaskName("run"), RunTestExecutable.class);
                        testTask.setGroup("verification");
                        testTask.setDescription("Executes C++ unit tests.");
                        InstallExecutable installTask = (InstallExecutable)executable.getInstallTask().get();
                        testTask.onlyIf((Spec)new Spec<Task>(){

                            public boolean isSatisfiedBy(Task element) {
                                return ((Directory)executable.getInstallDirectory().get()).getAsFile().exists();
                            }
                        });
                        testTask.setExecutable(installTask.getRunScript());
                        testTask.dependsOn(new Object[]{((CppTestExecutable)testComponent.getTestBinary().get()).getInstallDirectory()});
                        testTask.setOutputDir(((Directory)project.getLayout().getBuildDirectory().dir("test-results/" + executable.getNames().getDirName()).get()).getAsFile());
                        executable.getRunTask().set((Object)testTask);
                    }
                });
                testComponent.getBinaries().realizeNow();
            }
        });
    }
}

