/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

abstract class IncrementalFiler
implements Filer {
    private final Filer delegate;
    private final Messager messager;

    IncrementalFiler(Filer delegate, Messager messager) {
        this.delegate = delegate;
        this.messager = messager;
    }

    @Override
    public final JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        this.checkOriginatingElements(name, originatingElements, this.messager);
        return this.delegate.createSourceFile(name, originatingElements);
    }

    @Override
    public final JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
        this.checkOriginatingElements(name, originatingElements, this.messager);
        return this.delegate.createClassFile(name, originatingElements);
    }

    protected abstract void checkOriginatingElements(CharSequence var1, Element[] var2, Messager var3);

    @Override
    public final FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        this.messager.printMessage(Diagnostic.Kind.ERROR, "Incremental annotation processors are not allowed to create resources.");
        return this.delegate.createResource(location, pkg, relativeName, originatingElements);
    }

    @Override
    public final FileObject getResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName) throws IOException {
        this.messager.printMessage(Diagnostic.Kind.ERROR, "Incremental annotation processors are not allowed to read resources.");
        return this.delegate.getResource(location, pkg, relativeName);
    }
}

