/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gradle.api.Action;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.ide.visualstudio.XmlConfigFile;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.CollectionUtils;

public class DefaultVisualStudioProject
implements VisualStudioProjectInternal {
    private final DefaultConfigFile projectFile;
    private final DefaultConfigFile filtersFile;
    private final String name;
    private final String projectPath;
    private final String componentName;
    private final List<File> additionalFiles = new ArrayList<File>();
    private final Map<VisualStudioTargetBinary, VisualStudioProjectConfiguration> configurations = new LinkedHashMap<VisualStudioTargetBinary, VisualStudioProjectConfiguration>();
    private final DefaultTaskDependency buildDependencies = new DefaultTaskDependency();

    public DefaultVisualStudioProject(String name, String projectPath, String componentName, PathToFileResolver fileResolver, Instantiator instantiator) {
        this.name = name;
        this.projectPath = projectPath;
        this.componentName = componentName;
        this.projectFile = (DefaultConfigFile)instantiator.newInstance(DefaultConfigFile.class, new Object[]{fileResolver, this.getName() + ".vcxproj"});
        this.filtersFile = (DefaultConfigFile)instantiator.newInstance(DefaultConfigFile.class, new Object[]{fileResolver, this.getName() + ".vcxproj.filters"});
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public DefaultConfigFile getProjectFile() {
        return this.projectFile;
    }

    @Override
    public DefaultConfigFile getFiltersFile() {
        return this.filtersFile;
    }

    public void addSourceFile(File sourceFile) {
        this.additionalFiles.add(sourceFile);
    }

    public static String getUUID(File projectFile) {
        return "{" + UUID.nameUUIDFromBytes(projectFile.getAbsolutePath().getBytes()).toString().toUpperCase() + "}";
    }

    public Set<File> getSourceFiles() {
        LinkedHashSet<File> allSources = new LinkedHashSet<File>();
        for (VisualStudioTargetBinary binary : this.configurations.keySet()) {
            allSources.addAll(binary.getSourceFiles().getFiles());
        }
        allSources.addAll(this.additionalFiles);
        return allSources;
    }

    public Set<File> getResourceFiles() {
        LinkedHashSet<File> allResources = new LinkedHashSet<File>();
        for (VisualStudioTargetBinary binary : this.configurations.keySet()) {
            allResources.addAll(binary.getResourceFiles().getFiles());
        }
        return allResources;
    }

    public Set<File> getHeaderFiles() {
        LinkedHashSet<File> allHeaders = new LinkedHashSet<File>();
        for (VisualStudioTargetBinary binary : this.configurations.keySet()) {
            allHeaders.addAll(binary.getHeaderFiles().getFiles());
        }
        return allHeaders;
    }

    public List<VisualStudioProjectConfiguration> getConfigurations() {
        return CollectionUtils.toList(this.configurations.values());
    }

    public void addConfiguration(VisualStudioTargetBinary nativeBinary, VisualStudioProjectConfiguration configuration) {
        this.configurations.put(nativeBinary, configuration);
        this.builtBy(nativeBinary.getSourceFiles());
        this.builtBy(nativeBinary.getResourceFiles());
        this.builtBy(nativeBinary.getHeaderFiles());
    }

    public VisualStudioProjectConfiguration getConfiguration(VisualStudioTargetBinary nativeBinary) {
        return this.configurations.get(nativeBinary);
    }

    @Override
    public void builtBy(Object ... tasks) {
        this.buildDependencies.add(tasks);
    }

    public TaskDependency getBuildDependencies() {
        return this.buildDependencies;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public PublishArtifact getPublishArtifact() {
        return new VisualStudioProjectArtifact();
    }

    public static class DefaultConfigFile
    implements XmlConfigFile {
        private final List<Action<? super XmlProvider>> actions = new ArrayList<Action<? super XmlProvider>>();
        private final PathToFileResolver fileResolver;
        private Object location;

        public DefaultConfigFile(PathToFileResolver fileResolver, String defaultLocation) {
            this.fileResolver = fileResolver;
            this.location = defaultLocation;
        }

        @Override
        public File getLocation() {
            return this.fileResolver.resolve(this.location);
        }

        @Override
        public void setLocation(Object location) {
            this.location = location;
        }

        @Override
        public void withXml(Action<? super XmlProvider> action) {
            this.actions.add(action);
        }

        public List<Action<? super XmlProvider>> getXmlActions() {
            return this.actions;
        }
    }

    private class VisualStudioProjectArtifact
    extends DefaultPublishArtifact {
        public VisualStudioProjectArtifact() {
            super(DefaultVisualStudioProject.this.name, "vcxproj", "visualStudioProject", null, null, null, new Object[]{DefaultVisualStudioProject.this.buildDependencies});
        }

        public File getFile() {
            return DefaultVisualStudioProject.this.projectFile.getLocation();
        }
    }
}

