/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.io.File;
import java.util.List;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.IncludedBuildRegistry;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.SettingsLoader;
import org.gradle.plugin.management.internal.DefaultPluginRequests;

public class CompositeBuildSettingsLoader
implements SettingsLoader {
    private final SettingsLoader delegate;
    private final NestedBuildFactory nestedBuildFactory;
    private final IncludedBuildRegistry includedBuildRegistry;

    public CompositeBuildSettingsLoader(SettingsLoader delegate, NestedBuildFactory nestedBuildFactory, IncludedBuildRegistry includedBuildRegistry) {
        this.delegate = delegate;
        this.nestedBuildFactory = nestedBuildFactory;
        this.includedBuildRegistry = includedBuildRegistry;
    }

    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings = this.delegate.findAndLoadSettings(gradle);
        List<IncludedBuildSpec> includedBuilds = settings.getIncludedBuilds();
        if (!includedBuilds.isEmpty()) {
            for (IncludedBuildSpec includedBuildSpec : includedBuilds) {
                ConfigurableIncludedBuild includedBuild = this.includedBuildRegistry.addExplicitBuild(BuildDefinition.fromStartParameterForBuild(gradle.getStartParameter(), includedBuildSpec.rootDir, DefaultPluginRequests.EMPTY), this.nestedBuildFactory);
                includedBuildSpec.configurer.execute((Object)includedBuild);
            }
        }
        for (File rootDir : gradle.getStartParameter().getIncludedBuilds()) {
            this.includedBuildRegistry.addExplicitBuild(BuildDefinition.fromStartParameterForBuild(gradle.getStartParameter(), rootDir, DefaultPluginRequests.EMPTY), this.nestedBuildFactory);
        }
        this.includedBuildRegistry.validateExplicitIncludedBuilds(settings);
        return settings;
    }
}

