/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.tasks;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ProjectLayoutSetupRegistry;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;

public class InitBuild
extends DefaultTask {
    private String type;
    private String dsl;
    private String testFramework;
    @Internal
    private ProjectLayoutSetupRegistry projectLayoutRegistry;

    @Input
    public String getType() {
        return Strings.isNullOrEmpty((String)this.type) ? this.detectType() : this.type;
    }

    @Incubating
    @Optional
    @Input
    public String getDsl() {
        return Strings.isNullOrEmpty((String)this.dsl) ? BuildInitDsl.GROOVY.getId() : this.dsl;
    }

    @Optional
    @Input
    public String getTestFramework() {
        return this.testFramework;
    }

    public ProjectLayoutSetupRegistry getProjectLayoutRegistry() {
        if (this.projectLayoutRegistry == null) {
            this.projectLayoutRegistry = (ProjectLayoutSetupRegistry)this.getServices().get(ProjectLayoutSetupRegistry.class);
        }
        return this.projectLayoutRegistry;
    }

    @TaskAction
    public void setupProjectLayout() {
        String type = this.getType();
        BuildInitDsl dsl = BuildInitDsl.fromName(this.getDsl());
        BuildInitTestFramework testFramework = BuildInitTestFramework.fromName(this.getTestFramework());
        ProjectLayoutSetupRegistry projectLayoutRegistry = this.getProjectLayoutRegistry();
        if (!projectLayoutRegistry.supports(type)) {
            String supportedTypes = Joiner.on((String)", ").join(Iterables.transform(projectLayoutRegistry.getSupportedTypes(), (Function)new Function<String, String>(){

                public String apply(String input) {
                    return "'" + input + "'";
                }
            }));
            throw new GradleException("The requested build setup type '" + type + "' is not supported. Supported types: " + supportedTypes + ".");
        }
        ProjectInitDescriptor initDescriptor = projectLayoutRegistry.get(type);
        if (!testFramework.equals((Object)BuildInitTestFramework.NONE) && !initDescriptor.supports(testFramework)) {
            throw new GradleException("The requested test framework '" + testFramework.getId() + "' is not supported in '" + type + "' setup type");
        }
        initDescriptor.generate(dsl, testFramework);
    }

    @Option(option="type", description="Set type of build to create.")
    public void setType(String type) {
        this.type = type;
    }

    @OptionValues(value={"type"})
    public List<String> getAvailableBuildTypes() {
        return this.getProjectLayoutRegistry().getSupportedTypes();
    }

    @Incubating
    @Option(option="dsl", description="Set alternative build script DSL to be used.")
    public void setDsl(String dsl) {
        this.dsl = dsl;
    }

    @Incubating
    @OptionValues(value={"dsl"})
    public List<String> getAvailableDSLs() {
        return BuildInitDsl.listSupported();
    }

    @Option(option="test-framework", description="Set alternative test framework to be used.")
    public void setTestFramework(String testFramework) {
        this.testFramework = testFramework;
    }

    @OptionValues(value={"test-framework"})
    public List<String> getAvailableTestFrameworks() {
        return BuildInitTestFramework.listSupported();
    }

    public void setProjectLayoutRegistry(ProjectLayoutSetupRegistry projectLayoutRegistry) {
        this.projectLayoutRegistry = projectLayoutRegistry;
    }

    private String detectType() {
        return this.file("pom.xml").exists() ? "pom" : "basic";
    }

    private File file(String path) {
        return this.getProject().file((Object)path);
    }
}

