/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.api.GenericLineReader;
import javajs.api.GenericZipTools;
import javajs.util.AU;
import javajs.util.Base64;
import javajs.util.Encoding;
import javajs.util.OC;
import javajs.util.SB;

public class Rdr
implements GenericLineReader {
    BufferedReader reader;

    public Rdr(BufferedReader reader) {
        this.reader = reader;
    }

    @Override
    public String readNextLine() throws Exception {
        return this.reader.readLine();
    }

    public static Map<String, Object> readCifData(GenericCifDataParser parser, BufferedReader br) {
        return parser.set(null, br, false).getAllCifData();
    }

    public static String fixUTF(byte[] bytes) {
        Encoding encoding = Rdr.getUTFEncoding(bytes);
        if (encoding != Encoding.NONE) {
            try {
                String s = new String(bytes, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        s = s.substring(1);
                        break;
                    }
                }
                return s;
            }
            catch (UnsupportedEncodingException e) {
                System.out.println(e);
            }
        }
        return new String(bytes);
    }

    private static Encoding getUTFEncoding(byte[] bytes) {
        if (bytes.length >= 3 && (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191) {
            return Encoding.UTF8;
        }
        if (bytes.length >= 4 && (bytes[0] & 0xFF) == 0 && (bytes[1] & 0xFF) == 0 && (bytes[2] & 0xFF) == 254 && (bytes[3] & 0xFF) == 255) {
            return Encoding.UTF_32BE;
        }
        if (bytes.length >= 4 && (bytes[0] & 0xFF) == 255 && (bytes[1] & 0xFF) == 254 && (bytes[2] & 0xFF) == 0 && (bytes[3] & 0xFF) == 0) {
            return Encoding.UTF_32LE;
        }
        if (bytes.length >= 2 && (bytes[0] & 0xFF) == 255 && (bytes[1] & 0xFF) == 254) {
            return Encoding.UTF_16LE;
        }
        if (bytes.length >= 2 && (bytes[0] & 0xFF) == 254 && (bytes[1] & 0xFF) == 255) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    private static Encoding getUTFEncodingForStream(BufferedInputStream is) throws IOException {
        byte[] abMagic = new byte[4];
        abMagic[3] = 1;
        try {
            is.mark(5);
        }
        catch (Exception e) {
            return Encoding.NONE;
        }
        is.read(abMagic, 0, 4);
        is.reset();
        return Rdr.getUTFEncoding(abMagic);
    }

    public static boolean isBase64(SB sb) {
        return sb.indexOf(";base64,") == 0;
    }

    public static boolean isCompoundDocumentS(InputStream is) {
        return Rdr.isCompoundDocumentB(Rdr.getMagic(is, 8));
    }

    public static boolean isCompoundDocumentB(byte[] bytes) {
        return bytes.length >= 8 && (bytes[0] & 0xFF) == 208 && (bytes[1] & 0xFF) == 207 && (bytes[2] & 0xFF) == 17 && (bytes[3] & 0xFF) == 224 && (bytes[4] & 0xFF) == 161 && (bytes[5] & 0xFF) == 177 && (bytes[6] & 0xFF) == 26 && (bytes[7] & 0xFF) == 225;
    }

    public static boolean isBZip2S(InputStream is) {
        return Rdr.isBZip2B(Rdr.getMagic(is, 3));
    }

    public static boolean isGzipS(InputStream is) {
        return Rdr.isGzipB(Rdr.getMagic(is, 2));
    }

    public static boolean isBZip2B(byte[] bytes) {
        return bytes != null && bytes.length >= 3 && (bytes[0] & 0xFF) == 66 && (bytes[1] & 0xFF) == 90 && (bytes[2] & 0xFF) == 104;
    }

    public static boolean isGzipB(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && (bytes[0] & 0xFF) == 31 && (bytes[1] & 0xFF) == 139;
    }

    public static boolean isPickleS(InputStream is) {
        return Rdr.isPickleB(Rdr.getMagic(is, 2));
    }

    public static boolean isPickleB(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && (bytes[0] & 0xFF) == 125 && (bytes[1] & 0xFF) == 113;
    }

    public static boolean isMessagePackS(InputStream is) {
        return Rdr.isMessagePackB(Rdr.getMagic(is, 2));
    }

    public static boolean isMessagePackB(byte[] bytes) {
        int b;
        return bytes != null && bytes.length >= 1 && ((b = bytes[0] & 0xFF) == 222 || (b & 0xE0) == 128 && bytes[1] != 80);
    }

    public static boolean isPngZipStream(InputStream is) {
        return Rdr.isPngZipB(Rdr.getMagic(is, 55));
    }

    public static boolean isPngZipB(byte[] bytes) {
        return bytes[50] == 0 && bytes[51] == 80 && bytes[52] == 78 && bytes[53] == 71 && bytes[54] == 74;
    }

    public static boolean isZipS(InputStream is) {
        return Rdr.isZipB(Rdr.getMagic(is, 4));
    }

    public static boolean isZipB(byte[] bytes) {
        return bytes.length >= 4 && bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 3 && bytes[3] == 4;
    }

    public static byte[] getMagic(InputStream is, int n) {
        byte[] abMagic = new byte[n];
        try {
            is.mark(n + 1);
            is.read(abMagic, 0, n);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            is.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return abMagic;
    }

    public static String guessMimeTypeForBytes(byte[] bytes) {
        switch (bytes.length < 2 ? -1 : bytes[1]) {
            case 0: {
                return "image/jpg";
            }
            case 73: {
                return "image/gif";
            }
            case 77: {
                return "image/BMP";
            }
            case 80: {
                return "image/png";
            }
        }
        return "image/unknown";
    }

    public static BufferedInputStream getBIS(byte[] bytes) {
        return new BufferedInputStream(new ByteArrayInputStream(bytes));
    }

    public static BufferedReader getBR(String string) {
        return new BufferedReader(new StringReader(string));
    }

    public static BufferedInputStream getUnzippedInputStream(GenericZipTools jzt, BufferedInputStream bis) throws IOException {
        while (Rdr.isGzipS(bis)) {
            bis = new BufferedInputStream(jzt.newGZIPInputStream(bis));
        }
        return bis;
    }

    public static BufferedInputStream getUnzippedInputStreamBZip2(GenericZipTools jzt, BufferedInputStream bis) throws IOException {
        while (Rdr.isBZip2S(bis)) {
            bis = new BufferedInputStream(jzt.newBZip2InputStream(bis));
        }
        return bis;
    }

    public static byte[] getBytesFromSB(SB sb) {
        return Rdr.isBase64(sb) ? Base64.decodeBase64(sb.substring(8)) : sb.toBytes(0, -1);
    }

    public static Object getStreamAsBytes(BufferedInputStream bis, OC out) throws IOException {
        byte[] buf = new byte[1024];
        byte[] bytes = out == null ? new byte[4096] : null;
        int len = 0;
        int totalLen = 0;
        while ((len = bis.read(buf, 0, 1024)) > 0) {
            totalLen += len;
            if (out == null) {
                if (totalLen >= bytes.length) {
                    bytes = AU.ensureLengthByte(bytes, totalLen * 2);
                }
                System.arraycopy(buf, 0, bytes, totalLen - len, len);
                continue;
            }
            out.write(buf, 0, len);
        }
        bis.close();
        if (out == null) {
            return AU.arrayCopyByte(bytes, totalLen);
        }
        return totalLen + " bytes";
    }

    public static BufferedReader getBufferedReader(BufferedInputStream bis, String charSet) throws IOException {
        if (Rdr.getUTFEncodingForStream(bis) == Encoding.NONE) {
            return new StreamReader(bis, charSet);
        }
        byte[] bytes = Rdr.getLimitedStreamBytes(bis, -1L);
        bis.close();
        return Rdr.getBR(charSet == null ? Rdr.fixUTF(bytes) : new String(bytes, charSet));
    }

    public static byte[] getLimitedStreamBytes(InputStream is, long n) throws IOException {
        int buflen = n > 0L && n < 1024L ? (int)n : 1024;
        byte[] buf = new byte[buflen];
        byte[] bytes = new byte[n < 0L ? 4096 : (int)n];
        int len = 0;
        int totalLen = 0;
        if (n < 0L) {
            n = Integer.MAX_VALUE;
        }
        while ((long)totalLen < n && (len = is.read(buf, 0, buflen)) > 0) {
            if ((totalLen += len) > bytes.length) {
                bytes = AU.ensureLengthByte(bytes, totalLen * 2);
            }
            System.arraycopy(buf, 0, bytes, totalLen - len, len);
            if (n == Integer.MAX_VALUE || totalLen + buflen <= bytes.length) continue;
            buflen = bytes.length - totalLen;
        }
        if (totalLen == bytes.length) {
            return bytes;
        }
        buf = new byte[totalLen];
        System.arraycopy(bytes, 0, buf, 0, totalLen);
        return buf;
    }

    public static String streamToUTF8String(BufferedInputStream bis) {
        String[] data = new String[1];
        try {
            Rdr.readAllAsString(Rdr.getBufferedReader(bis, "UTF-8"), -1, true, data, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data[0];
    }

    public static boolean readAllAsString(BufferedReader br, int nBytesMax, boolean allowBinary, String[] data, int i) {
        try {
            SB sb = SB.newN(8192);
            if (nBytesMax < 0) {
                String line = br.readLine();
                if (allowBinary || line != null && line.indexOf(0) < 0 && (line.length() != 4 || line.charAt(0) != '\ufffd' || line.indexOf("PNG") != 1)) {
                    sb.append(line).appendC('\n');
                    while ((line = br.readLine()) != null) {
                        sb.append(line).appendC('\n');
                    }
                }
            } else {
                String line;
                int len;
                for (int n = 0; n < nBytesMax && (line = br.readLine()) != null; n += len + 1) {
                    len = line.length();
                    if (nBytesMax - n < len + 1) {
                        line = line.substring(0, nBytesMax - n - 1);
                    }
                    sb.append(line).appendC('\n');
                }
            }
            br.close();
            data[i] = sb.toString();
            return true;
        }
        catch (Exception ioe) {
            data[i] = ioe.toString();
            return false;
        }
    }

    static void getPngZipPointAndCount(BufferedInputStream bis, int[] pt_count) {
        bis.mark(75);
        try {
            byte[] data = Rdr.getLimitedStreamBytes(bis, 74L);
            bis.reset();
            int pt = 0;
            int i = 64;
            int f = 1;
            while (--i > 54) {
                pt += (data[i] - 48) * f;
                f *= 10;
            }
            int n = 0;
            int i2 = 74;
            int f2 = 1;
            while (--i2 > 64) {
                n += (data[i2] - 48) * f2;
                f2 *= 10;
            }
            pt_count[0] = pt;
            pt_count[1] = n;
        }
        catch (Throwable e) {
            pt_count[1] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedInputStream getPngZipStream(BufferedInputStream bis, boolean asNewStream) {
        if (!Rdr.isPngZipStream(bis)) {
            return bis;
        }
        byte[] data = new byte[]{};
        bis.mark(75);
        try {
            int[] pt_count = new int[2];
            Rdr.getPngZipPointAndCount(bis, pt_count);
            if (pt_count[1] != 0) {
                int pt = pt_count[0];
                while (pt > 0) {
                    pt = (int)((long)pt - bis.skip(pt));
                }
                if (!asNewStream) {
                    BufferedInputStream bufferedInputStream = bis;
                    return bufferedInputStream;
                }
                data = Rdr.getLimitedStreamBytes(bis, pt_count[1]);
            }
        }
        catch (Throwable e) {
        }
        finally {
            try {
                if (asNewStream) {
                    bis.close();
                }
            }
            catch (Exception e) {}
        }
        return Rdr.getBIS(data);
    }

    public static String getZipRoot(String fileName) {
        int pt = fileName.indexOf("|");
        return pt < 0 ? fileName : fileName.substring(0, pt);
    }

    public static class StreamReader
    extends BufferedReader {
        private BufferedInputStream stream;

        public StreamReader(BufferedInputStream bis, String charSet) throws UnsupportedEncodingException {
            super(new InputStreamReader((InputStream)bis, charSet == null ? "UTF-8" : charSet));
            this.stream = bis;
        }

        public BufferedInputStream getStream() {
            try {
                this.stream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.stream;
        }
    }
}

