/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public final class Node
extends OsmPrimitive
implements INode {
    private double lat = Double.NaN;
    private double lon = Double.NaN;
    private double east = Double.NaN;
    private double north = Double.NaN;
    private Object eastNorthCacheKey;

    @Override
    public void setCoor(LatLon coor) {
        this.updateCoor(coor, null);
    }

    @Override
    public void setEastNorth(EastNorth eastNorth) {
        this.updateCoor(null, eastNorth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCoor(LatLon coor, EastNorth eastNorth) {
        if (this.getDataSet() != null) {
            boolean locked = this.writeLock();
            try {
                this.getDataSet().fireNodeMoved(this, coor, eastNorth);
            }
            finally {
                this.writeUnlock(locked);
            }
        } else {
            this.setCoorInternal(coor, eastNorth);
        }
    }

    @Override
    public LatLon getCoor() {
        if (!this.isLatLonKnown()) {
            return null;
        }
        return new LatLon(this.lat, this.lon);
    }

    @Override
    public double lat() {
        return this.lat;
    }

    @Override
    public double lon() {
        return this.lon;
    }

    public EastNorth getEastNorth() {
        return this.getEastNorth(Main.getProjection());
    }

    @Override
    public EastNorth getEastNorth(Projecting projection) {
        if (!this.isLatLonKnown()) {
            return null;
        }
        if (Double.isNaN(this.east) || Double.isNaN(this.north) || !Objects.equals(projection.getCacheKey(), this.eastNorthCacheKey)) {
            EastNorth en = projection.latlon2eastNorth(this);
            this.east = en.east();
            this.north = en.north();
            this.eastNorthCacheKey = projection.getCacheKey();
        }
        return new EastNorth(this.east, this.north);
    }

    void setCoorInternal(LatLon coor, EastNorth eastNorth) {
        if (coor != null) {
            this.lat = coor.lat();
            this.lon = coor.lon();
            this.invalidateEastNorthCache();
        } else if (eastNorth != null) {
            LatLon ll = Main.getProjection().eastNorth2latlon(eastNorth);
            this.lat = ll.lat();
            this.lon = ll.lon();
            this.east = eastNorth.east();
            this.north = eastNorth.north();
            this.eastNorthCacheKey = Main.getProjection().getCacheKey();
        } else {
            this.lat = Double.NaN;
            this.lon = Double.NaN;
            this.invalidateEastNorthCache();
            if (this.isVisible()) {
                this.setIncomplete(true);
            }
        }
    }

    protected Node(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Node() {
        this(0L, false);
    }

    public Node(long id) {
        super(id, false);
    }

    public Node(long id, int version) {
        super(id, version, false);
    }

    public Node(Node clone, boolean clearMetadata) {
        super(clone.getUniqueId(), true);
        this.cloneFrom(clone);
        if (clearMetadata) {
            this.clearOsmMetadata();
        }
    }

    public Node(Node clone) {
        this(clone, false);
    }

    public Node(LatLon latlon) {
        super(0L, false);
        this.setCoor(latlon);
    }

    public Node(EastNorth eastNorth) {
        super(0L, false);
        this.setEastNorth(eastNorth);
    }

    @Override
    void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        if (!this.isIncomplete() && this.isVisible() && !this.isLatLonKnown()) {
            throw new DataIntegrityProblemException("Complete node with null coordinates: " + this.toString());
        }
    }

    @Override
    public void accept(OsmPrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(PrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void cloneFrom(OsmPrimitive osm) {
        if (!(osm instanceof Node)) {
            throw new IllegalArgumentException("Not a node: " + osm);
        }
        boolean locked = this.writeLock();
        try {
            super.cloneFrom(osm);
            this.setCoor(((Node)osm).getCoor());
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void mergeFrom(OsmPrimitive other) {
        if (!(other instanceof Node)) {
            throw new IllegalArgumentException("Not a node: " + other);
        }
        boolean locked = this.writeLock();
        try {
            super.mergeFrom(other);
            if (!other.isIncomplete()) {
                this.setCoor(((Node)other).getCoor());
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public void load(PrimitiveData data) {
        if (!(data instanceof NodeData)) {
            throw new IllegalArgumentException("Not a node data: " + data);
        }
        boolean locked = this.writeLock();
        try {
            super.load(data);
            this.setCoor(((NodeData)data).getCoor());
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public NodeData save() {
        NodeData data = new NodeData();
        this.saveCommonAttributes(data);
        if (!this.isIncomplete()) {
            data.setCoor(this.getCoor());
        }
        return data;
    }

    public String toString() {
        String coorDesc = this.isLatLonKnown() ? "lat=" + this.lat + ",lon=" + this.lon : "";
        return "{Node id=" + this.getUniqueId() + " version=" + this.getVersion() + ' ' + this.getFlagsAsString() + ' ' + coorDesc + '}';
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive other, boolean testInterestingTagsOnly) {
        return other instanceof Node && this.hasEqualSemanticFlags(other) && this.hasEqualCoordinates((Node)other) && super.hasEqualSemanticAttributes(other, testInterestingTagsOnly);
    }

    private boolean hasEqualCoordinates(Node other) {
        LatLon c1 = this.getCoor();
        LatLon c2 = other.getCoor();
        return c1 == null && c2 == null || c1 != null && c2 != null && c1.equalsEpsilon(c2);
    }

    @Override
    public int compareTo(OsmPrimitive o) {
        return o instanceof Node ? Long.compare(this.getUniqueId(), o.getUniqueId()) : 1;
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    @Override
    public BBox getBBox() {
        return new BBox(this.lon, this.lat);
    }

    @Override
    protected void addToBBox(BBox box, Set<PrimitiveId> visited) {
        box.add(this.lon, this.lat);
    }

    @Override
    public void updatePosition() {
    }

    @Override
    public boolean isDrawable() {
        return super.isDrawable() && this.isLatLonKnown();
    }

    public boolean isConnectionNode() {
        return this.isReferredByWays(2);
    }

    public void invalidateEastNorthCache() {
        this.east = Double.NaN;
        this.north = Double.NaN;
        this.eastNorthCacheKey = null;
    }

    @Override
    public boolean concernsArea() {
        return false;
    }

    public boolean isConnectedTo(Collection<Node> otherNodes, int hops, Predicate<Node> predicate) {
        CheckParameterUtil.ensureParameterNotNull(otherNodes);
        CheckParameterUtil.ensureThat(!otherNodes.isEmpty(), "otherNodes must not be empty!");
        CheckParameterUtil.ensureThat(hops >= 0, "hops must be non-negative!");
        return hops == 0 ? this.isConnectedTo(otherNodes, hops, predicate, null) : this.isConnectedTo(otherNodes, hops, predicate, new TreeSet<Node>());
    }

    private boolean isConnectedTo(Collection<Node> otherNodes, int hops, Predicate<Node> predicate, Set<Node> visited) {
        if (otherNodes.contains(this)) {
            return true;
        }
        if (hops > 0 && visited != null) {
            visited.add(this);
            for (Way w : Utils.filteredCollection(this.getReferrers(), Way.class)) {
                for (Node n : w.getNodes()) {
                    boolean containsN = visited.contains(n);
                    visited.add(n);
                    if (containsN || predicate != null && !predicate.test(n) || !n.isConnectedTo(otherNodes, hops - 1, predicate, visited)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isOutsideDownloadArea() {
        if (this.isNewOrUndeleted() || this.getDataSet() == null) {
            return false;
        }
        Area area = this.getDataSet().getDataSourceArea();
        if (area == null) {
            return false;
        }
        LatLon coor = this.getCoor();
        return coor != null && !coor.isIn(area);
    }

    public List<Way> getParentWays() {
        return Node.getFilteredList(this.getReferrers(), Way.class);
    }
}

