/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.KeyGenerator;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;
import javax.net.ssl.SSLContext;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.bc.BcDSAContentVerifierProviderBuilder;
import org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;
import org.jruby.ext.openssl.OpenSSL;

public abstract class SecurityHelper {
    private static String BC_PROVIDER_CLASS;
    private static String BC_PROVIDER_NAME;
    static boolean setBouncyCastleProvider;
    static Provider securityProvider;
    private static volatile Boolean registerProvider;
    static final Map<String, Class> implEngines;
    static final boolean SPI_ACCESSIBLE;
    private static Boolean tryCipherInternal;
    private static final Class<?>[] STRING_PARAM;
    private static boolean providerSSLContext;

    public static void addCipher(String name2, Class<? extends CipherSpi> clazz) {
        implEngines.put("Cipher:" + name2, clazz);
        tryCipherInternal = true;
    }

    public static void addSignature(String name2, Class<? extends SignatureSpi> clazz) {
        implEngines.put("Signature:" + name2, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Provider getSecurityProvider() {
        if (setBouncyCastleProvider && securityProvider == null) {
            Class<SecurityHelper> clazz = SecurityHelper.class;
            // MONITORENTER : org.jruby.ext.openssl.SecurityHelper.class
            if (setBouncyCastleProvider && securityProvider == null) {
                SecurityHelper.setBouncyCastleProvider();
                setBouncyCastleProvider = false;
            }
            // MONITOREXIT : clazz
        }
        SecurityHelper.doRegisterProvider();
        return securityProvider;
    }

    static Provider getSecurityProviderIfAccessible() {
        return SPI_ACCESSIBLE ? SecurityHelper.getSecurityProvider() : null;
    }

    public static synchronized void setSecurityProvider(Provider provider) {
        if (provider != null) {
            OpenSSL.debug("using provider: " + provider);
        }
        securityProvider = provider;
    }

    static synchronized void setBouncyCastleProvider() {
        SecurityHelper.setSecurityProvider(SecurityHelper.newBouncyCastleProvider());
    }

    private static Provider newBouncyCastleProvider() {
        try {
            return (Provider)Class.forName(BC_PROVIDER_CLASS).newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static synchronized void setRegisterProvider(boolean register2) {
        registerProvider = register2;
        if (register2) {
            SecurityHelper.getSecurityProvider();
        }
    }

    static boolean isProviderAvailable(String name2) {
        return Security.getProvider(name2) != null;
    }

    public static boolean isProviderRegistered() {
        if (securityProvider == null) {
            return false;
        }
        return Security.getProvider(securityProvider.getName()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doRegisterProvider() {
        if (registerProvider == null) return;
        Class<SecurityHelper> clazz = SecurityHelper.class;
        synchronized (SecurityHelper.class) {
            Boolean register2 = registerProvider;
            if (register2 == null || !register2.booleanValue() || securityProvider == null) return;
            Security.addProvider(securityProvider);
            registerProvider = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static CertificateFactory getCertificateFactory(String type) throws CertificateException {
        try {
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null) {
                return SecurityHelper.getCertificateFactory(type, provider);
            }
        }
        catch (CertificateException e) {
            OpenSSL.debugStackTrace(e);
        }
        return CertificateFactory.getInstance(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CertificateFactory getCertificateFactory(String type, Provider provider) throws CertificateException {
        boolean addedBC = false;
        Class<SecurityHelper> clazz = SecurityHelper.class;
        synchronized (SecurityHelper.class) {
            CertificateFactorySpi spi;
            try {
                if (provider.getName().equals(BC_PROVIDER_NAME) && Security.getProvider(BC_PROVIDER_NAME) == null) {
                    Security.addProvider(provider);
                    addedBC = true;
                }
                spi = (CertificateFactorySpi)SecurityHelper.getImplEngine("CertificateFactory", type);
            }
            finally {
                if (addedBC) {
                    Security.removeProvider(BC_PROVIDER_NAME);
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (spi == null) {
                throw new CertificateException(type + " not found");
            }
            return SecurityHelper.newInstance(CertificateFactory.class, new Class[]{CertificateFactorySpi.class, Provider.class, String.class}, spi, provider, type);
        }
    }

    public static KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null) {
                return SecurityHelper.getKeyFactory(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return KeyFactory.getInstance(algorithm);
    }

    static KeyFactory getKeyFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        KeyFactorySpi spi = (KeyFactorySpi)SecurityHelper.getImplEngine("KeyFactory", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(KeyFactory.class, new Class[]{KeyFactorySpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null) {
                return SecurityHelper.getKeyPairGenerator(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return KeyPairGenerator.getInstance(algorithm);
    }

    static KeyPairGenerator getKeyPairGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator;
        Object spi = SecurityHelper.getImplEngine("KeyPairGenerator", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " KeyPairGenerator not available");
        }
        if (spi instanceof KeyPairGenerator) {
            keyPairGenerator = (KeyPairGenerator)spi;
        } else {
            Class<?> delegate;
            try {
                delegate = Class.forName(KeyPairGenerator.class.getName() + "$Delegate");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            keyPairGenerator = (KeyPairGenerator)SecurityHelper.newInstance(delegate, new Class[]{KeyPairGeneratorSpi.class, String.class}, spi, algorithm);
        }
        SecurityHelper.setField(keyPairGenerator, KeyPairGenerator.class, "provider", provider);
        return keyPairGenerator;
    }

    public static KeyStore getKeyStore(String type) throws KeyStoreException {
        try {
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null) {
                return SecurityHelper.getKeyStore(type, provider);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return KeyStore.getInstance(type);
    }

    static KeyStore getKeyStore(String type, Provider provider) throws KeyStoreException {
        return KeyStore.getInstance(type, provider);
    }

    public static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null) {
                return SecurityHelper.getMessageDigest(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return MessageDigest.getInstance(algorithm);
    }

    static MessageDigest getMessageDigest(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        MessageDigest messageDigest;
        Object spi = SecurityHelper.getImplEngine("MessageDigest", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        if (spi instanceof MessageDigest) {
            messageDigest = (MessageDigest)spi;
        } else {
            Class<?> delegate;
            try {
                delegate = Class.forName(MessageDigest.class.getName() + "$Delegate");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            messageDigest = (MessageDigest)SecurityHelper.newInstance(delegate, new Class[]{MessageDigestSpi.class, String.class}, spi, algorithm);
        }
        SecurityHelper.setField(messageDigest, MessageDigest.class, "provider", provider);
        return messageDigest;
    }

    public static SecureRandom getSecureRandom() {
        try {
            String algorithm;
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null && (algorithm = SecurityHelper.getSecureRandomAlgorithm(provider)) != null) {
                return SecurityHelper.getSecureRandom(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return new SecureRandom();
    }

    private static SecureRandom getSecureRandom(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        SecureRandomSpi spi = (SecureRandomSpi)SecurityHelper.getImplEngine("SecureRandom", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(SecureRandom.class, new Class[]{SecureRandomSpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    private static String getSecureRandomAlgorithm(Provider provider) {
        for (Provider.Service service : provider.getServices()) {
            if (!"SecureRandom".equals(service.getType())) continue;
            return service.getAlgorithm();
        }
        return null;
    }

    public static Cipher getCipher(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider provider2;
        try {
            if (tryCipherInternal == Boolean.FALSE && (provider2 = SecurityHelper.getSecurityProvider()) != null) {
                return SecurityHelper.getCipher(transformation, provider2);
            }
        }
        catch (NoSuchAlgorithmException provider2) {
        }
        catch (NoSuchPaddingException provider2) {
        }
        catch (SecurityException e) {
            if (tryCipherInternal != null) {
                tryCipherInternal = Boolean.TRUE;
            }
            OpenSSL.debugStackTrace(e);
        }
        if (tryCipherInternal == Boolean.TRUE) {
            try {
                provider2 = SecurityHelper.getSecurityProvider();
                if (provider2 != null) {
                    return SecurityHelper.getCipherInternal(transformation, provider2);
                }
            }
            catch (NoSuchAlgorithmException provider3) {
            }
            catch (RuntimeException e) {
                tryCipherInternal = null;
                OpenSSL.debugStackTrace(e);
            }
        }
        return Cipher.getInstance(transformation);
    }

    static Cipher getCipher(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(transformation, provider);
    }

    private static Cipher getCipherInternal(String transformation, Provider provider) throws NoSuchAlgorithmException {
        CipherSpi spi = (CipherSpi)SecurityHelper.getImplEngine("Cipher", transformation);
        if (spi == null) {
            StringTokenizer tok = new StringTokenizer(transformation, "/");
            String algorithm = tok.nextToken();
            spi = (CipherSpi)SecurityHelper.getImplEngine("Cipher", algorithm);
            if (spi == null) {
                throw new NoSuchAlgorithmException(transformation + " not found");
            }
            if (tok.hasMoreTokens() && !transformation.regionMatches(algorithm.length(), "//", 0, 2)) {
                SecurityHelper.invoke(spi, CipherSpi.class, "engineSetMode", STRING_PARAM, tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                SecurityHelper.invoke(spi, CipherSpi.class, "engineSetPadding", STRING_PARAM, tok.nextToken());
            }
        }
        try {
            Cipher cipher2 = SecurityHelper.newInstance(Cipher.class, new Class[]{CipherSpi.class, String.class}, spi, transformation);
            SecurityHelper.setField(cipher2, Cipher.class, "provider", provider);
            return cipher2;
        }
        catch (Exception e) {
            return SecurityHelper.newInstance(Cipher.class, new Class[]{CipherSpi.class, Provider.class, String.class}, spi, provider, transformation);
        }
    }

    public static Signature getSignature(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null) {
                return SecurityHelper.getSignature(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return Signature.getInstance(algorithm);
    }

    static Signature getSignature(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Signature signature;
        Object spi = SecurityHelper.getImplEngine("Signature", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " Signature not available");
        }
        if (spi instanceof Signature) {
            signature = (Signature)spi;
        } else {
            Class<?> delegate;
            try {
                delegate = Class.forName(Signature.class.getName() + "$Delegate");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            signature = (Signature)SecurityHelper.newInstance(delegate, new Class[]{SignatureSpi.class, String.class}, spi, algorithm);
        }
        SecurityHelper.setField(signature, Signature.class, "provider", provider);
        return signature;
    }

    public static Mac getMac(String algorithm) throws NoSuchAlgorithmException {
        Mac mac = null;
        Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
        if (provider != null) {
            mac = SecurityHelper.getMac(algorithm, provider, true);
        }
        if (mac == null) {
            mac = Mac.getInstance(algorithm);
        }
        return mac;
    }

    static Mac getMac(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        return SecurityHelper.getMac(algorithm, provider, false);
    }

    private static Mac getMac(String algorithm, Provider provider, boolean silent) throws NoSuchAlgorithmException {
        MacSpi spi = (MacSpi)SecurityHelper.getImplEngine("Mac", algorithm);
        if (spi == null) {
            if (silent) {
                return null;
            }
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(Mac.class, new Class[]{MacSpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    public static KeyGenerator getKeyGenerator(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null) {
                return SecurityHelper.getKeyGenerator(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException provider) {
        }
        catch (SecurityException e) {
            OpenSSL.debugStackTrace(e);
        }
        return KeyGenerator.getInstance(algorithm);
    }

    static KeyGenerator getKeyGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        KeyGeneratorSpi spi = (KeyGeneratorSpi)SecurityHelper.getImplEngine("KeyGenerator", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(KeyGenerator.class, new Class[]{KeyGeneratorSpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    public static KeyAgreement getKeyAgreement(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null) {
                return SecurityHelper.getKeyAgreement(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException provider) {
        }
        catch (SecurityException e) {
            OpenSSL.debugStackTrace(e);
        }
        return KeyAgreement.getInstance(algorithm);
    }

    static KeyAgreement getKeyAgreement(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        KeyAgreementSpi spi = (KeyAgreementSpi)SecurityHelper.getImplEngine("KeyAgreement", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(KeyAgreement.class, new Class[]{KeyAgreementSpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        try {
            Provider provider = SecurityHelper.getSecurityProviderIfAccessible();
            if (provider != null) {
                return SecurityHelper.getSecretKeyFactory(algorithm, provider);
            }
        }
        catch (NoSuchAlgorithmException provider) {
        }
        catch (SecurityException e) {
            OpenSSL.debugStackTrace(e);
        }
        return SecretKeyFactory.getInstance(algorithm);
    }

    static SecretKeyFactory getSecretKeyFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        SecretKeyFactorySpi spi = (SecretKeyFactorySpi)SecurityHelper.getImplEngine("SecretKeyFactory", algorithm);
        if (spi == null) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
        return SecurityHelper.newInstance(SecretKeyFactory.class, new Class[]{SecretKeyFactorySpi.class, Provider.class, String.class}, spi, provider, algorithm);
    }

    public static SSLContext getSSLContext(String protocol) throws NoSuchAlgorithmException {
        try {
            Provider provider;
            if (providerSSLContext && (provider = SecurityHelper.getSecurityProviderIfAccessible()) != null) {
                return SecurityHelper.getSSLContext(protocol, provider);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return SSLContext.getInstance(protocol);
    }

    private static SSLContext getSSLContext(String protocol, Provider provider) throws NoSuchAlgorithmException {
        return SSLContext.getInstance(protocol, provider);
    }

    public static boolean verify(X509CRL crl2, PublicKey publicKey) throws NoSuchAlgorithmException, CRLException, InvalidKeyException, SignatureException {
        return SecurityHelper.verify(crl2, publicKey, false);
    }

    static boolean verify(X509CRL crl2, PublicKey publicKey, boolean silent) throws NoSuchAlgorithmException, CRLException, InvalidKeyException, SignatureException {
        if (crl2 instanceof X509CRLObject) {
            CertificateList crlList = (CertificateList)SecurityHelper.getCertificateList(crl2);
            AlgorithmIdentifier tbsSignatureId = crlList.getTBSCertList().getSignature();
            if (!crlList.getSignatureAlgorithm().equals((Object)tbsSignatureId)) {
                if (silent) {
                    return false;
                }
                throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
            }
            Signature signature = SecurityHelper.getSignature(crl2.getSigAlgName(), securityProvider);
            signature.initVerify(publicKey);
            signature.update(crl2.getTBSCertList());
            if (!signature.verify(crl2.getSignature())) {
                if (silent) {
                    return false;
                }
                throw new SignatureException("CRL does not verify with supplied public key.");
            }
            return true;
        }
        try {
            ContentVerifierProvider verifierProvider;
            DefaultDigestAlgorithmIdentifierFinder digestAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
            if ("DSA".equalsIgnoreCase(publicKey.getAlgorithm())) {
                BigInteger y = ((DSAPublicKey)publicKey).getY();
                DSAParams params2 = ((DSAPublicKey)publicKey).getParams();
                DSAParameters parameters = new DSAParameters(params2.getP(), params2.getQ(), params2.getG());
                DSAPublicKeyParameters dsaKey = new DSAPublicKeyParameters(y, parameters);
                verifierProvider = new BcDSAContentVerifierProviderBuilder((DigestAlgorithmIdentifierFinder)digestAlgFinder).build((AsymmetricKeyParameter)dsaKey);
            } else {
                BigInteger mod2 = ((RSAPublicKey)publicKey).getModulus();
                BigInteger exp2 = ((RSAPublicKey)publicKey).getPublicExponent();
                RSAKeyParameters rsaKey = new RSAKeyParameters(false, mod2, exp2);
                verifierProvider = new BcRSAContentVerifierProviderBuilder((DigestAlgorithmIdentifierFinder)digestAlgFinder).build((AsymmetricKeyParameter)rsaKey);
            }
            return new X509CRLHolder(crl2.getEncoded()).isSignatureValid(verifierProvider);
        }
        catch (OperatorException e) {
            throw new SignatureException(e);
        }
        catch (CertException e) {
            throw new SignatureException(e);
        }
        catch (ClassCastException e) {
            throw new SignatureException(e);
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    private static Object getCertificateList(Object crl2) {
        try {
            Field cField = X509CRLObject.class.getDeclaredField("c");
            cField.setAccessible(true);
            return cField.get(crl2);
        }
        catch (NoSuchFieldException e) {
            OpenSSL.debugStackTrace(e);
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static Object getImplEngine(String baseName, String algorithm) {
        Object engine = SecurityHelper.findImplEngine(baseName, algorithm.toUpperCase(Locale.ENGLISH));
        if (engine == null) {
            engine = SecurityHelper.findImplEngine(baseName, algorithm);
        }
        return engine;
    }

    private static Object findImplEngine(String baseName, String algorithm) {
        String className;
        Class<?> implEngineClass = implEngines.get(baseName + ":" + algorithm);
        if (implEngineClass == null) {
            String alias;
            Provider bcProvider = securityProvider;
            while ((alias = bcProvider.getProperty("Alg.Alias." + baseName + "." + algorithm)) != null) {
                algorithm = alias;
            }
            className = bcProvider.getProperty(baseName + "." + algorithm);
            if (className != null) {
                try {
                    ClassLoader loader = bcProvider.getClass().getClassLoader();
                    implEngineClass = loader != null ? loader.loadClass(className) : Class.forName(className);
                    implEngineClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("algorithm " + algorithm + " in provider " + bcProvider.getName() + " but no class \"" + className + "\" found!");
                }
                catch (Exception e) {
                    throw new IllegalStateException("algorithm " + algorithm + " in provider " + bcProvider.getName() + " but class \"" + className + "\" inaccessible!");
                }
            } else {
                return null;
            }
            implEngines.put(baseName + ":" + algorithm, implEngineClass);
        }
        try {
            return implEngineClass.newInstance();
        }
        catch (Exception e) {
            Provider bcProvider = securityProvider;
            className = implEngineClass.getName();
            throw new IllegalStateException("algorithm " + algorithm + " in provider " + bcProvider.getName() + " but class \"" + className + "\" inaccessible!");
        }
    }

    private static <T> T newInstance(Class<T> klass, Class<?>[] paramTypes, Object ... params2) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(paramTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(params2);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T> T invoke(Object object, Class<?> klass, String methodName, Class<?>[] paramTypes, Object ... params2) {
        try {
            Method method = klass.getDeclaredMethod(methodName, paramTypes);
            method.setAccessible(true);
            return (T)method.invoke(object, params2);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void setField(Object obj, Class<?> fieldOwner, String fieldName, Object value2) {
        try {
            Field field = fieldOwner.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(obj, value2);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("no field '" + fieldName + "' declared in " + fieldOwner + "", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        Provider provider;
        BC_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        BC_PROVIDER_NAME = "BC";
        setBouncyCastleProvider = true;
        registerProvider = null;
        implEngines = new ConcurrentHashMap<String, Class>(16, 0.75f, 1);
        boolean canSetAccessible = true;
        if (OpenSSL.javaVersion9(true) && (provider = SecurityHelper.getSecurityProvider()) != null) {
            try {
                SecurityHelper.getCertificateFactory("X.509", provider);
            }
            catch (CertificateException ex) {
                OpenSSL.debugStackTrace(ex);
                canSetAccessible = false;
            }
            catch (RuntimeException ex) {
                OpenSSL.debugStackTrace(ex);
                canSetAccessible = false;
            }
        }
        SPI_ACCESSIBLE = canSetAccessible;
        tryCipherInternal = Boolean.FALSE;
        STRING_PARAM = new Class[]{String.class};
        providerSSLContext = false;
    }
}

