/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginClassLoader
extends UrlClassLoader {
    private final ClassLoader[] myParents;
    private final PluginId myPluginId;
    private final String myPluginVersion;
    private final List<String> myLibDirectories;
    private static final Set<String> KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES = ContainerUtil.set("kotlin.sequences.Sequence", "kotlin.Unit", "kotlin.Pair", "kotlin.Triple", "kotlin.jvm.internal.DefaultConstructorMarker", "kotlin.reflect.KDeclarationContainer");

    public PluginClassLoader(@NotNull List<URL> urls, @NotNull ClassLoader[] parents2, PluginId pluginId, String version, File pluginRoot) {
        if (urls == null) {
            PluginClassLoader.$$$reportNull$$$0(0);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(1);
        }
        super(PluginClassLoader.build().urls(urls).allowLock().useCache());
        this.myParents = parents2;
        this.myPluginId = pluginId;
        this.myPluginVersion = version;
        this.myLibDirectories = ContainerUtil.newSmartList();
        File libDir = new File(pluginRoot, "lib");
        if (libDir.exists()) {
            this.myLibDirectories.add(libDir.getAbsolutePath());
        }
    }

    public Class loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        Class c;
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(2);
        }
        if ((c = this.tryLoadingClass(name, resolve2, null)) == null) {
            throw new ClassNotFoundException(name + " " + this);
        }
        return c;
    }

    @Nullable
    private Class tryLoadingClass(@NotNull String name, boolean resolve2, @Nullable Set<ClassLoader> visited2) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(3);
        }
        Class c = null;
        if (!PluginClassLoader.mustBeLoadedByPlatform(name)) {
            c = this.loadClassInsideSelf(name);
        }
        if (c == null) {
            c = this.loadClassFromParents(name, visited2);
        }
        if (c != null) {
            if (resolve2) {
                this.resolveClass(c);
            }
            return c;
        }
        return null;
    }

    private static boolean mustBeLoadedByPlatform(String className2) {
        return className2.startsWith("kotlin.") && (className2.startsWith("kotlin.jvm.functions.") || KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.contains(className2));
    }

    @Nullable
    private Class loadClassFromParents(String name, Set<ClassLoader> visited2) {
        for (ClassLoader parent2 : this.myParents) {
            if (visited2 == null) {
                visited2 = ContainerUtilRt.newHashSet(this);
            }
            if (!visited2.add(parent2)) continue;
            if (parent2 instanceof PluginClassLoader) {
                Class c = ((PluginClassLoader)parent2).tryLoadingClass(name, false, visited2);
                if (c == null) continue;
                return c;
            }
            try {
                return parent2.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private synchronized Class loadClassInsideSelf(@NotNull String name) {
        Class c;
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(4);
        }
        if ((c = this.findLoadedClass(name)) != null) {
            return c;
        }
        try {
            c = this._findClass(name);
        }
        catch (IncompatibleClassChangeError | UnsupportedClassVersionError e) {
            throw new PluginException("While loading class " + name + ": " + e.getMessage(), e, this.myPluginId);
        }
        if (c != null) {
            PluginManagerCore.addPluginClass(this.myPluginId);
        }
        return c;
    }

    @Override
    public URL findResource(String name) {
        URL resource = super.findResource(name);
        if (resource != null) {
            return resource;
        }
        for (ClassLoader parent2 : this.myParents) {
            URL parentResource = parent2.getResource(name);
            if (parentResource == null) continue;
            return parentResource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream stream2 = super.getResourceAsStream(name);
        if (stream2 != null) {
            return stream2;
        }
        for (ClassLoader parent2 : this.myParents) {
            InputStream inputStream = parent2.getResourceAsStream(name);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration[] resources = new Enumeration[this.myParents.length + 1];
        resources[0] = super.findResources(name);
        for (int idx = 0; idx < this.myParents.length; ++idx) {
            resources[idx + 1] = this.myParents[idx].getResources(name);
        }
        return new DeepEnumeration(resources);
    }

    @Override
    protected String findLibrary(String libName) {
        if (!this.myLibDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i = this.myLibDirectories.listIterator(this.myLibDirectories.size());
            while (i.hasPrevious()) {
                File libFile = new File(i.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    public String toString() {
        return "PluginClassLoader[" + this.myPluginId + ", " + this.myPluginVersion + "] " + super.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirectories";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/cl/PluginClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryLoadingClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadClassInsideSelf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibDirectories";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DeepEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] myEnumerations;
        private int myIndex;

        DeepEnumeration(Enumeration<URL>[] enumerations) {
            this.myEnumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.myEnumerations.length) {
                Enumeration<URL> e = this.myEnumerations[this.myIndex];
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.myEnumerations[this.myIndex].nextElement();
        }
    }
}

