/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.internal.BufferWrapper;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.GeometryState;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.J3DBuffer;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Vector3f;

public abstract class GeometryArrayState
extends GeometryState {
    protected int vertexFormat;
    protected int vertexCount;
    protected int texCoordSetCount;
    protected int[] texCoordSetMap;
    private static final int FORMAT_NULL = 0;
    private static final int FORMAT_BYTE = 1;
    private static final int FORMAT_FLOAT = 2;
    private static final int FORMAT_DOUBLE = 3;
    private static final int FORMAT_3B = 4;
    private static final int FORMAT_4B = 5;
    private static final int FORMAT_2F = 6;
    private static final int FORMAT_3F = 7;
    private static final int FORMAT_4F = 8;
    private static final int FORMAT_2D = 9;
    private static final int FORMAT_3D = 10;

    public GeometryArrayState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        block107: {
            J3DBuffer j3DBuffer;
            boolean bl;
            boolean bl2;
            block109: {
                block108: {
                    Object object;
                    block106: {
                        super.writeObject(dataOutput);
                        boolean bl3 = bl2 = (this.vertexFormat & 0x800) != 0;
                        if ((this.vertexFormat & 0x100) == 0) break block106;
                        if (!(this.node instanceof IndexedGeometryArray)) {
                            dataOutput.writeInt(((GeometryArray)this.node).getInitialVertexIndex());
                            if (!(this.node instanceof GeometryStripArray)) {
                                dataOutput.writeInt(((GeometryArray)this.node).getValidVertexCount());
                            }
                        }
                        if (bl2) {
                            FloatBuffer floatBuffer = (FloatBuffer)((GeometryArray)this.node).getInterleavedVertexBuffer().getBuffer();
                            float[] fArray = new float[floatBuffer.limit()];
                            floatBuffer.position(0);
                            floatBuffer.get(fArray);
                            this.writeFloatArray(dataOutput, fArray);
                        } else {
                            this.writeFloatArray(dataOutput, ((GeometryArray)this.node).getInterleavedVertices());
                        }
                        break block107;
                    }
                    boolean bl4 = bl = (this.vertexFormat & 0x80) != 0;
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        if (!bl) {
                            dataOutput.writeInt(((GeometryArray)this.node).getInitialVertexIndex());
                        }
                        if (!(this.node instanceof GeometryStripArray)) {
                            dataOutput.writeInt(((GeometryArray)this.node).getValidVertexCount());
                        }
                    }
                    if ((this.vertexFormat & 0xC) == 12) {
                        if (bl) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                dataOutput.writeInt(((GeometryArray)this.node).getInitialColorIndex());
                            }
                            if (bl2) {
                                object = ((GeometryArray)this.node).getColorRefBuffer();
                                switch (BufferWrapper.getBufferType((J3DBuffer)object)) {
                                    case 2: {
                                        dataOutput.writeInt(1);
                                        j3DBuffer = (ByteBuffer)object.getBuffer();
                                        Object[] objectArray = new byte[j3DBuffer.limit()];
                                        j3DBuffer.position(0);
                                        j3DBuffer.get((byte[])objectArray);
                                        dataOutput.writeInt(objectArray.length);
                                        dataOutput.write((byte[])objectArray);
                                        break;
                                    }
                                    case 3: {
                                        dataOutput.writeInt(2);
                                        j3DBuffer = (FloatBuffer)object.getBuffer();
                                        Object[] objectArray = new float[j3DBuffer.limit()];
                                        j3DBuffer.position(0);
                                        j3DBuffer.get((float[])objectArray);
                                        this.writeFloatArray(dataOutput, (float[])objectArray);
                                        break;
                                    }
                                    case 0: {
                                        dataOutput.writeInt(0);
                                    }
                                }
                            } else if (((GeometryArray)this.node).getColorRef4f() != null) {
                                dataOutput.writeInt(8);
                                object = ((GeometryArray)this.node).getColorRef4f();
                                j3DBuffer = (J3DBuffer)new float[((byte[])object).length * 4];
                                for (int i = 0; i < ((byte[])object).length; ++i) {
                                    j3DBuffer[i * 4 + 0] = object[i].x;
                                    j3DBuffer[i * 4 + 1] = object[i].y;
                                    j3DBuffer[i * 4 + 2] = (TexCoord3f)object[i].z;
                                    j3DBuffer[i * 4 + 3] = (TexCoord3f)object[i].w;
                                }
                                this.writeFloatArray(dataOutput, (float[])j3DBuffer);
                            } else if (((GeometryArray)this.node).getColorRefFloat() != null) {
                                dataOutput.writeInt(2);
                                this.writeFloatArray(dataOutput, ((GeometryArray)this.node).getColorRefFloat());
                            } else if (((GeometryArray)this.node).getColorRefByte() != null) {
                                dataOutput.writeInt(1);
                                object = ((GeometryArray)this.node).getColorRefByte();
                                dataOutput.writeInt(((byte[])object).length);
                                dataOutput.write((byte[])object);
                            } else if (((GeometryArray)this.node).getColorRef4b() != null) {
                                dataOutput.writeInt(5);
                                object = ((GeometryArray)this.node).getColorRef4b();
                                dataOutput.writeInt(((byte[])object).length);
                                j3DBuffer = (J3DBuffer)new byte[((byte[])object).length * 4];
                                for (int i = 0; i < ((byte[])object).length; ++i) {
                                    j3DBuffer[i * 4 + 0] = (J3DBuffer)object[i].x;
                                    j3DBuffer[i * 4 + 1] = (TexCoord3f)object[i].y;
                                    j3DBuffer[i * 4 + 2] = (TexCoord3f)object[i].z;
                                    j3DBuffer[i * 4 + 3] = (TexCoord3f)object[i].w;
                                }
                                dataOutput.write((byte[])j3DBuffer);
                            } else {
                                dataOutput.writeInt(0);
                            }
                        } else {
                            object = new byte[this.vertexCount * 4];
                            ((GeometryArray)this.node).getColors(0, object);
                            dataOutput.write((byte[])object);
                        }
                    } else if ((this.vertexFormat & 4) == 4) {
                        if (bl) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                dataOutput.writeInt(((GeometryArray)this.node).getInitialColorIndex());
                            }
                            if (bl2) {
                                object = ((GeometryArray)this.node).getColorRefBuffer();
                                switch (BufferWrapper.getBufferType((J3DBuffer)object)) {
                                    case 2: {
                                        dataOutput.writeInt(1);
                                        j3DBuffer = (ByteBuffer)object.getBuffer();
                                        Object[] objectArray = new byte[j3DBuffer.limit()];
                                        j3DBuffer.position(0);
                                        j3DBuffer.get((byte[])objectArray);
                                        dataOutput.writeInt(objectArray.length);
                                        dataOutput.write((byte[])objectArray);
                                        break;
                                    }
                                    case 3: {
                                        dataOutput.writeInt(2);
                                        j3DBuffer = (FloatBuffer)object.getBuffer();
                                        Object[] objectArray = new float[j3DBuffer.limit()];
                                        j3DBuffer.position(0);
                                        j3DBuffer.get((float[])objectArray);
                                        this.writeFloatArray(dataOutput, (float[])objectArray);
                                        break;
                                    }
                                    case 0: {
                                        dataOutput.writeInt(0);
                                    }
                                }
                            } else if (((GeometryArray)this.node).getColorRef3f() != null) {
                                dataOutput.writeInt(7);
                                object = ((GeometryArray)this.node).getColorRef3f();
                                j3DBuffer = (J3DBuffer)new float[((byte[])object).length * 3];
                                for (int i = 0; i < ((byte[])object).length; ++i) {
                                    j3DBuffer[i * 3 + 0] = object[i].x;
                                    j3DBuffer[i * 3 + 1] = (J3DBuffer)object[i].y;
                                    j3DBuffer[i * 3 + 2] = (TexCoord3f)object[i].z;
                                }
                                this.writeFloatArray(dataOutput, (float[])j3DBuffer);
                            } else if (((GeometryArray)this.node).getColorRefFloat() != null) {
                                dataOutput.writeInt(2);
                                this.writeFloatArray(dataOutput, ((GeometryArray)this.node).getColorRefFloat());
                            } else if (((GeometryArray)this.node).getColorRefByte() != null) {
                                dataOutput.writeInt(1);
                                object = ((GeometryArray)this.node).getColorRefByte();
                                dataOutput.writeInt(((byte[])object).length);
                                dataOutput.write((byte[])object);
                            } else if (((GeometryArray)this.node).getColorRef3b() != null) {
                                dataOutput.writeInt(4);
                                object = ((GeometryArray)this.node).getColorRef3b();
                                dataOutput.writeInt(((byte[])object).length);
                                j3DBuffer = (J3DBuffer)new byte[((byte[])object).length * 3];
                                for (int i = 0; i < ((byte[])object).length; ++i) {
                                    j3DBuffer[i * 3 + 0] = (TexCoord3f)object[i].x;
                                    j3DBuffer[i * 3 + 1] = (TexCoord3f)object[i].y;
                                    j3DBuffer[i * 3 + 2] = (TexCoord3f)object[i].z;
                                }
                                dataOutput.write((byte[])j3DBuffer);
                            } else {
                                dataOutput.writeInt(0);
                            }
                        } else {
                            object = new byte[this.vertexCount * 3];
                            ((GeometryArray)this.node).getColors(0, object);
                            dataOutput.write((byte[])object);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        if (bl) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                dataOutput.writeInt(((GeometryArray)this.node).getInitialCoordIndex());
                            }
                            if (bl2) {
                                object = ((GeometryArray)this.node).getCoordRefBuffer();
                                switch (BufferWrapper.getBufferType((J3DBuffer)object)) {
                                    case 3: {
                                        dataOutput.writeInt(2);
                                        j3DBuffer = (FloatBuffer)object.getBuffer();
                                        float[] fArray = new float[j3DBuffer.limit()];
                                        j3DBuffer.position(0);
                                        j3DBuffer.get(fArray);
                                        this.writeFloatArray(dataOutput, fArray);
                                        break;
                                    }
                                    case 4: {
                                        dataOutput.writeInt(3);
                                        j3DBuffer = (DoubleBuffer)object.getBuffer();
                                        double[] dArray = new double[j3DBuffer.limit()];
                                        j3DBuffer.position(0);
                                        j3DBuffer.get(dArray);
                                        this.writeDoubleArray(dataOutput, dArray);
                                        break;
                                    }
                                    case 0: {
                                        dataOutput.writeInt(0);
                                    }
                                }
                            } else if (((GeometryArray)this.node).getCoordRef3f() != null) {
                                dataOutput.writeInt(7);
                                object = ((GeometryArray)this.node).getCoordRef3f();
                                j3DBuffer = (J3DBuffer)new float[((byte[])object).length * 3];
                                for (int i = 0; i < ((byte[])object).length; ++i) {
                                    j3DBuffer[i * 3 + 0] = object[i].x;
                                    j3DBuffer[i * 3 + 1] = (TexCoord3f)object[i].y;
                                    j3DBuffer[i * 3 + 2] = (TexCoord3f)object[i].z;
                                }
                                this.writeFloatArray(dataOutput, (float[])j3DBuffer);
                            } else if (((GeometryArray)this.node).getCoordRef3d() != null) {
                                dataOutput.writeInt(10);
                                object = ((GeometryArray)this.node).getCoordRef3d();
                                j3DBuffer = (J3DBuffer)new double[((byte[])object).length * 3];
                                for (int i = 0; i < ((byte[])object).length; ++i) {
                                    j3DBuffer[i * 3 + 0] = (J3DBuffer)object[i].x;
                                    j3DBuffer[i * 3 + 1] = (TexCoord3f)object[i].y;
                                    j3DBuffer[i * 3 + 2] = (TexCoord3f)object[i].z;
                                }
                                this.writeDoubleArray(dataOutput, (double[])j3DBuffer);
                            } else if (((GeometryArray)this.node).getCoordRefFloat() != null) {
                                dataOutput.writeInt(2);
                                this.writeFloatArray(dataOutput, ((GeometryArray)this.node).getCoordRefFloat());
                            } else if (((GeometryArray)this.node).getCoordRefDouble() != null) {
                                dataOutput.writeInt(3);
                                this.writeDoubleArray(dataOutput, ((GeometryArray)this.node).getCoordRefDouble());
                            } else {
                                dataOutput.writeInt(0);
                            }
                        } else {
                            object = new float[this.vertexCount * 3];
                            ((GeometryArray)this.node).getCoordinates(0, (float[])object);
                            this.writeFloatArray(dataOutput, (float[])object);
                        }
                    }
                    if ((this.vertexFormat & 2) != 0) {
                        if (bl) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                dataOutput.writeInt(((GeometryArray)this.node).getInitialNormalIndex());
                            }
                            if (bl2) {
                                object = ((GeometryArray)this.node).getNormalRefBuffer();
                                if (BufferWrapper.getBufferType((J3DBuffer)object) == 0) {
                                    dataOutput.writeInt(0);
                                } else {
                                    dataOutput.writeInt(2);
                                    j3DBuffer = (FloatBuffer)object.getBuffer();
                                    float[] fArray = new float[j3DBuffer.limit()];
                                    j3DBuffer.position(0);
                                    j3DBuffer.get(fArray);
                                    this.writeFloatArray(dataOutput, fArray);
                                }
                            } else if (((GeometryArray)this.node).getNormalRef3f() != null) {
                                dataOutput.writeInt(7);
                                object = ((GeometryArray)this.node).getNormalRef3f();
                                j3DBuffer = (J3DBuffer)new float[((byte[])object).length * 3];
                                for (int i = 0; i < ((byte[])object).length; ++i) {
                                    j3DBuffer[i * 3 + 0] = (J3DBuffer)object[i].x;
                                    j3DBuffer[i * 3 + 1] = (TexCoord3f)object[i].y;
                                    j3DBuffer[i * 3 + 2] = (TexCoord3f)object[i].z;
                                }
                                this.writeFloatArray(dataOutput, (float[])j3DBuffer);
                            } else if (((GeometryArray)this.node).getNormalRefFloat() != null) {
                                dataOutput.writeInt(2);
                                this.writeFloatArray(dataOutput, ((GeometryArray)this.node).getNormalRefFloat());
                            } else {
                                dataOutput.writeInt(0);
                            }
                        } else {
                            object = new float[this.vertexCount * 3];
                            ((GeometryArray)this.node).getNormals(0, (float[])object);
                            this.writeFloatArray(dataOutput, (float[])object);
                        }
                    }
                    if ((this.vertexFormat & 0x20) == 0) break block108;
                    for (int i = 0; i < this.texCoordSetCount; ++i) {
                        if (bl) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                dataOutput.writeInt(((GeometryArray)this.node).getInitialTexCoordIndex(i));
                            }
                            if (bl2) {
                                j3DBuffer = ((GeometryArray)this.node).getTexCoordRefBuffer(i);
                                if (BufferWrapper.getBufferType(j3DBuffer) == 0) {
                                    dataOutput.writeInt(0);
                                    continue;
                                }
                                dataOutput.writeInt(2);
                                FloatBuffer floatBuffer = (FloatBuffer)j3DBuffer.getBuffer();
                                float[] fArray = new float[floatBuffer.limit()];
                                floatBuffer.position(0);
                                floatBuffer.get(fArray);
                                this.writeFloatArray(dataOutput, fArray);
                                continue;
                            }
                            if (((GeometryArray)this.node).getTexCoordRef2f(i) != null) {
                                dataOutput.writeInt(6);
                                j3DBuffer = ((GeometryArray)this.node).getTexCoordRef2f(i);
                                float[] fArray = new float[((J3DBuffer)j3DBuffer).length * 2];
                                for (int j = 0; j < ((TexCoord3f[])j3DBuffer).length; ++j) {
                                    fArray[j * 2 + 0] = j3DBuffer[j].x;
                                    fArray[j * 2 + 1] = j3DBuffer[j].y;
                                }
                                this.writeFloatArray(dataOutput, fArray);
                                continue;
                            }
                            if (((GeometryArray)this.node).getTexCoordRefFloat(i) != null) {
                                dataOutput.writeInt(2);
                                this.writeFloatArray(dataOutput, ((GeometryArray)this.node).getTexCoordRefFloat(i));
                                continue;
                            }
                            dataOutput.writeInt(0);
                            continue;
                        }
                        j3DBuffer = (J3DBuffer)new float[this.vertexCount * 2];
                        ((GeometryArray)this.node).getTextureCoordinates(i, 0, (float[])j3DBuffer);
                        this.writeFloatArray(dataOutput, (float[])j3DBuffer);
                    }
                    break block107;
                }
                if ((this.vertexFormat & 0x40) == 0) break block109;
                for (int i = 0; i < this.texCoordSetCount; ++i) {
                    if (bl) {
                        if (!(this.node instanceof IndexedGeometryArray)) {
                            dataOutput.writeInt(((GeometryArray)this.node).getInitialTexCoordIndex(i));
                        }
                        if (bl2) {
                            j3DBuffer = ((GeometryArray)this.node).getTexCoordRefBuffer(i);
                            if (BufferWrapper.getBufferType(j3DBuffer) == 0) {
                                dataOutput.writeInt(0);
                                continue;
                            }
                            dataOutput.writeInt(2);
                            FloatBuffer floatBuffer = (FloatBuffer)j3DBuffer.getBuffer();
                            float[] fArray = new float[floatBuffer.limit()];
                            floatBuffer.position(0);
                            floatBuffer.get(fArray);
                            this.writeFloatArray(dataOutput, fArray);
                            continue;
                        }
                        if (((GeometryArray)this.node).getTexCoordRef3f(i) != null) {
                            dataOutput.writeInt(7);
                            j3DBuffer = ((GeometryArray)this.node).getTexCoordRef3f(i);
                            float[] fArray = new float[((TexCoord3f[])j3DBuffer).length * 3];
                            for (int j = 0; j < ((TexCoord3f[])j3DBuffer).length; ++j) {
                                fArray[j * 3 + 0] = j3DBuffer[j].x;
                                fArray[j * 3 + 1] = j3DBuffer[j].y;
                                fArray[j * 3 + 2] = j3DBuffer[j].z;
                            }
                            this.writeFloatArray(dataOutput, fArray);
                            continue;
                        }
                        if (((GeometryArray)this.node).getTexCoordRefFloat(i) != null) {
                            dataOutput.writeInt(2);
                            this.writeFloatArray(dataOutput, ((GeometryArray)this.node).getTexCoordRefFloat(i));
                            continue;
                        }
                        dataOutput.writeInt(0);
                        continue;
                    }
                    j3DBuffer = (J3DBuffer)new float[this.vertexCount * 3];
                    ((GeometryArray)this.node).getTextureCoordinates(i, 0, (float[])j3DBuffer);
                    this.writeFloatArray(dataOutput, (float[])j3DBuffer);
                }
                break block107;
            }
            if ((this.vertexFormat & 0x400) == 0) break block107;
            for (int i = 0; i < this.texCoordSetCount; ++i) {
                if (bl) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        dataOutput.writeInt(((GeometryArray)this.node).getInitialTexCoordIndex(i));
                    }
                    if (bl2) {
                        j3DBuffer = ((GeometryArray)this.node).getTexCoordRefBuffer(i);
                        if (BufferWrapper.getBufferType(j3DBuffer) == 0) {
                            dataOutput.writeInt(0);
                            continue;
                        }
                        dataOutput.writeInt(2);
                        FloatBuffer floatBuffer = (FloatBuffer)j3DBuffer.getBuffer();
                        float[] fArray = new float[floatBuffer.limit()];
                        floatBuffer.position(0);
                        floatBuffer.get(fArray);
                        this.writeFloatArray(dataOutput, fArray);
                        continue;
                    }
                    if (((GeometryArray)this.node).getTexCoordRefFloat(i) != null) {
                        dataOutput.writeInt(2);
                        this.writeFloatArray(dataOutput, ((GeometryArray)this.node).getTexCoordRefFloat(i));
                        continue;
                    }
                    dataOutput.writeInt(0);
                    continue;
                }
                j3DBuffer = (J3DBuffer)new float[this.vertexCount * 4];
                ((GeometryArray)this.node).getTextureCoordinates(i, 0, (float[])j3DBuffer);
                this.writeFloatArray(dataOutput, (float[])j3DBuffer);
            }
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        block88: {
            Object object;
            Object[] objectArray;
            boolean bl;
            boolean bl2;
            block87: {
                super.readObject(dataInput);
                boolean bl3 = bl2 = (this.vertexFormat & 0x800) != 0;
                if ((this.vertexFormat & 0x100) == 0) break block87;
                if (!(this.node instanceof IndexedGeometryArray)) {
                    ((GeometryArray)this.node).setInitialVertexIndex(dataInput.readInt());
                    if (!(this.node instanceof GeometryStripArray)) {
                        ((GeometryArray)this.node).setValidVertexCount(dataInput.readInt());
                    }
                }
                if (bl2) {
                    float[] fArray = this.readFloatArray(dataInput);
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
                    FloatBuffer floatBuffer = byteBuffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
                    floatBuffer.put(fArray);
                    ((GeometryArray)this.node).setInterleavedVertexBuffer(new J3DBuffer((Buffer)floatBuffer));
                } else {
                    ((GeometryArray)this.node).setInterleavedVertices(this.readFloatArray(dataInput));
                }
                break block88;
            }
            boolean bl4 = bl = (this.vertexFormat & 0x80) != 0;
            if (!(this.node instanceof IndexedGeometryArray)) {
                if (!bl) {
                    ((GeometryArray)this.node).setInitialVertexIndex(dataInput.readInt());
                }
                if (!(this.node instanceof GeometryStripArray)) {
                    ((GeometryArray)this.node).setValidVertexCount(dataInput.readInt());
                }
            }
            if ((this.vertexFormat & 0xC) == 12) {
                if (bl) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialColorIndex(dataInput.readInt());
                    }
                    if (bl2) {
                        switch (dataInput.readInt()) {
                            case 1: {
                                objectArray = new byte[dataInput.readInt()];
                                dataInput.readFully((byte[])objectArray);
                                object = ByteBuffer.allocateDirect(objectArray.length);
                                object.put((byte[])objectArray);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer((Buffer)object));
                                break;
                            }
                            case 2: {
                                objectArray = this.readFloatArray(dataInput);
                                object = ByteBuffer.allocateDirect(objectArray.length * 4);
                                FloatBuffer floatBuffer = object.order(ByteOrder.nativeOrder()).asFloatBuffer();
                                floatBuffer.put((float[])objectArray);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer((Buffer)floatBuffer));
                            }
                        }
                    } else {
                        switch (dataInput.readInt()) {
                            case 8: {
                                int n;
                                objectArray = this.readFloatArray(dataInput);
                                object = new Color4f[objectArray.length / 4];
                                for (n = 0; n < ((Object)object).length; ++n) {
                                    object[n].x = objectArray[n * 4 + 0];
                                    object[n].y = objectArray[n * 4 + 1];
                                    object[n].z = objectArray[n * 4 + 2];
                                    object[n].w = objectArray[n * 4 + 3];
                                }
                                ((GeometryArray)this.node).setColorRef4f(object);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setColorRefFloat(this.readFloatArray(dataInput));
                                break;
                            }
                            case 1: {
                                objectArray = new byte[dataInput.readInt()];
                                dataInput.readFully((byte[])objectArray);
                                ((GeometryArray)this.node).setColorRefByte(objectArray);
                                break;
                            }
                            case 5: {
                                int n;
                                objectArray = new Color4b[dataInput.readInt()];
                                object = new byte[objectArray.length * 4];
                                dataInput.readFully((byte[])object);
                                for (n = 0; n < objectArray.length; ++n) {
                                    objectArray[n].x = (byte)object[n * 4 + 0];
                                    objectArray[n].y = (byte)object[n * 4 + 1];
                                    objectArray[n].z = (byte)object[n * 4 + 2];
                                    objectArray[n].w = (byte)object[n * 4 + 3];
                                }
                                ((GeometryArray)this.node).setColorRef4b((Color4b[])objectArray);
                            }
                        }
                    }
                } else {
                    objectArray = new byte[this.vertexCount * 4];
                    dataInput.readFully((byte[])objectArray);
                    ((GeometryArray)this.node).setColors(0, objectArray);
                }
            } else if ((this.vertexFormat & 4) == 4) {
                if (bl) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialColorIndex(dataInput.readInt());
                    }
                    if (bl2) {
                        switch (dataInput.readInt()) {
                            case 1: {
                                objectArray = new byte[dataInput.readInt()];
                                dataInput.readFully((byte[])objectArray);
                                object = ByteBuffer.allocateDirect(objectArray.length);
                                object.put((byte[])objectArray);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer((Buffer)object));
                                break;
                            }
                            case 2: {
                                objectArray = this.readFloatArray(dataInput);
                                object = ByteBuffer.allocateDirect(objectArray.length * 4);
                                FloatBuffer floatBuffer = object.order(ByteOrder.nativeOrder()).asFloatBuffer();
                                floatBuffer.put((float[])objectArray);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer((Buffer)floatBuffer));
                            }
                        }
                    } else {
                        switch (dataInput.readInt()) {
                            case 7: {
                                int n;
                                objectArray = this.readFloatArray(dataInput);
                                object = new Color3f[objectArray.length / 3];
                                for (n = 0; n < ((Object)object).length; ++n) {
                                    object[n].x = objectArray[n * 3 + 0];
                                    object[n].y = objectArray[n * 3 + 1];
                                    object[n].z = objectArray[n * 3 + 2];
                                }
                                ((GeometryArray)this.node).setColorRef3f((Color3f[])object);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setColorRefFloat(this.readFloatArray(dataInput));
                                break;
                            }
                            case 1: {
                                objectArray = new byte[dataInput.readInt()];
                                dataInput.readFully((byte[])objectArray);
                                ((GeometryArray)this.node).setColorRefByte(objectArray);
                                break;
                            }
                            case 4: {
                                int n;
                                objectArray = new Color3b[dataInput.readInt()];
                                object = new byte[objectArray.length * 3];
                                dataInput.readFully((byte[])object);
                                for (n = 0; n < objectArray.length; ++n) {
                                    objectArray[n].x = (byte)object[n * 3 + 0];
                                    objectArray[n].y = (byte)object[n * 3 + 1];
                                    objectArray[n].z = (byte)object[n * 3 + 2];
                                }
                                ((GeometryArray)this.node).setColorRef3b((Color3b[])objectArray);
                            }
                        }
                    }
                } else {
                    objectArray = new byte[this.vertexCount * 3];
                    dataInput.readFully((byte[])objectArray);
                    ((GeometryArray)this.node).setColors(0, objectArray);
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                if (bl) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialCoordIndex(dataInput.readInt());
                    }
                    if (bl2) {
                        switch (dataInput.readInt()) {
                            case 2: {
                                objectArray = this.readFloatArray(dataInput);
                                object = ByteBuffer.allocateDirect(objectArray.length * 4);
                                FloatBuffer floatBuffer = object.order(ByteOrder.nativeOrder()).asFloatBuffer();
                                floatBuffer.put((float[])objectArray);
                                ((GeometryArray)this.node).setCoordRefBuffer(new J3DBuffer((Buffer)floatBuffer));
                                break;
                            }
                            case 3: {
                                objectArray = this.readDoubleArray(dataInput);
                                object = ByteBuffer.allocateDirect(objectArray.length * 8);
                                DoubleBuffer doubleBuffer = object.order(ByteOrder.nativeOrder()).asDoubleBuffer();
                                doubleBuffer.put((double[])objectArray);
                                ((GeometryArray)this.node).setCoordRefBuffer(new J3DBuffer((Buffer)doubleBuffer));
                            }
                        }
                    } else {
                        switch (dataInput.readInt()) {
                            case 7: {
                                objectArray = this.readFloatArray(dataInput);
                                object = new Point3f[objectArray.length / 3];
                                for (int i = 0; i < ((Color4f[])object).length; ++i) {
                                    object[i].x = objectArray[i * 3 + 0];
                                    object[i].y = objectArray[i * 3 + 1];
                                    object[i].z = objectArray[i * 3 + 2];
                                }
                                ((GeometryArray)this.node).setCoordRef3f((Point3f[])object);
                                break;
                            }
                            case 10: {
                                objectArray = this.readDoubleArray(dataInput);
                                object = new Point3d[objectArray.length / 3];
                                for (int i = 0; i < ((Color4f[])object).length; ++i) {
                                    object[i].x = objectArray[i * 3 + 0];
                                    object[i].y = objectArray[i * 3 + 1];
                                    object[i].z = objectArray[i * 3 + 2];
                                }
                                ((GeometryArray)this.node).setCoordRef3d((Point3d[])object);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setCoordRefFloat(this.readFloatArray(dataInput));
                                break;
                            }
                            case 3: {
                                ((GeometryArray)this.node).setCoordRefDouble(this.readDoubleArray(dataInput));
                            }
                        }
                    }
                } else {
                    objectArray = this.readFloatArray(dataInput);
                    ((GeometryArray)this.node).setCoordinates(0, (float[])objectArray);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                if (bl) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialNormalIndex(dataInput.readInt());
                    }
                    if (bl2) {
                        if (dataInput.readInt() == 2) {
                            objectArray = this.readFloatArray(dataInput);
                            object = ByteBuffer.allocateDirect(objectArray.length * 4);
                            FloatBuffer floatBuffer = object.order(ByteOrder.nativeOrder()).asFloatBuffer();
                            floatBuffer.put((float[])objectArray);
                            ((GeometryArray)this.node).setNormalRefBuffer(new J3DBuffer((Buffer)floatBuffer));
                        }
                    } else {
                        switch (dataInput.readInt()) {
                            case 7: {
                                objectArray = this.readFloatArray(dataInput);
                                object = new Vector3f[objectArray.length / 3];
                                for (int i = 0; i < ((Object)object).length; ++i) {
                                    object[i].x = objectArray[i * 3 + 0];
                                    object[i].y = objectArray[i * 3 + 1];
                                    object[i].z = objectArray[i * 3 + 2];
                                }
                                ((GeometryArray)this.node).setNormalRef3f((Vector3f[])object);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setNormalRefFloat(this.readFloatArray(dataInput));
                            }
                        }
                    }
                } else {
                    objectArray = this.readFloatArray(dataInput);
                    ((GeometryArray)this.node).setNormals(0, (float[])objectArray);
                }
            }
            if ((this.vertexFormat & 0x20) == 0 && (this.vertexFormat & 0x40) == 0 && (this.vertexFormat & 0x400) == 0) break block88;
            if (bl) {
                block46: for (int i = 0; i < this.texCoordSetCount; ++i) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialTexCoordIndex(i, dataInput.readInt());
                    }
                    if (bl2) {
                        if (dataInput.readInt() != 2) continue;
                        object = this.readFloatArray(dataInput);
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(((Color4f[])object).length * 4);
                        FloatBuffer floatBuffer = byteBuffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
                        floatBuffer.put((float[])object);
                        ((GeometryArray)this.node).setTexCoordRefBuffer(i, new J3DBuffer((Buffer)floatBuffer));
                        continue;
                    }
                    switch (dataInput.readInt()) {
                        case 6: {
                            object = this.readFloatArray(dataInput);
                            TexCoord2f[] texCoord2fArray = new TexCoord2f[((Color4f[])object).length / 2];
                            for (int j = 0; j < texCoord2fArray.length; ++j) {
                                texCoord2fArray[j].x = (float)object[j * 2 + 0];
                                texCoord2fArray[j].y = (float)object[j * 2 + 1];
                            }
                            ((GeometryArray)this.node).setTexCoordRef2f(i, texCoord2fArray);
                            continue block46;
                        }
                        case 7: {
                            object = this.readFloatArray(dataInput);
                            TexCoord3f[] texCoord3fArray = new TexCoord3f[((Color4f[])object).length / 3];
                            for (int j = 0; j < texCoord3fArray.length; ++j) {
                                texCoord3fArray[j].x = (float)object[j * 3 + 0];
                                texCoord3fArray[j].y = (float)object[j * 3 + 1];
                                texCoord3fArray[j].z = (float)object[j * 3 + 2];
                            }
                            ((GeometryArray)this.node).setTexCoordRef3f(i, texCoord3fArray);
                            continue block46;
                        }
                        case 2: {
                            object = this.readFloatArray(dataInput);
                            ((GeometryArray)this.node).setTexCoordRefFloat(i, (float[])object);
                        }
                    }
                }
            } else {
                for (int i = 0; i < this.texCoordSetCount; ++i) {
                    object = this.readFloatArray(dataInput);
                    ((GeometryArray)this.node).setTextureCoordinates(i, 0, (float[])object);
                }
            }
        }
    }

    protected void writeConstructorParams(DataOutput dataOutput) throws IOException {
        this.vertexCount = ((GeometryArray)this.node).getVertexCount();
        this.vertexFormat = ((GeometryArray)this.node).getVertexFormat();
        this.texCoordSetCount = ((GeometryArray)this.node).getTexCoordSetCount();
        this.texCoordSetMap = new int[((GeometryArray)this.node).getTexCoordSetMapLength()];
        ((GeometryArray)this.node).getTexCoordSetMap(this.texCoordSetMap);
        dataOutput.writeInt(this.vertexCount);
        dataOutput.writeInt(this.vertexFormat);
        dataOutput.writeInt(this.texCoordSetCount);
        dataOutput.writeInt(this.texCoordSetMap.length);
        for (int i = 0; i < this.texCoordSetMap.length; ++i) {
            dataOutput.writeInt(this.texCoordSetMap[i]);
        }
        super.writeConstructorParams(dataOutput);
    }

    protected void readConstructorParams(DataInput dataInput) throws IOException {
        this.vertexCount = dataInput.readInt();
        this.vertexFormat = dataInput.readInt();
        this.texCoordSetCount = dataInput.readInt();
        this.texCoordSetMap = new int[dataInput.readInt()];
        for (int i = 0; i < this.texCoordSetMap.length; ++i) {
            this.texCoordSetMap[i] = dataInput.readInt();
        }
        super.readConstructorParams(dataInput);
    }

    protected void writeDoubleArray(DataOutput dataOutput, double[] dArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            dataOutputStream.writeDouble(dArray[i]);
        }
        dataOutputStream.close();
        dataOutput.writeInt(byteArrayOutputStream.size());
        dataOutput.write(byteArrayOutputStream.toByteArray());
    }

    protected double[] readDoubleArray(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[dataInput.readInt()];
        dataInput.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        double[] dArray = new double[dataInputStream.readInt()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dataInputStream.readDouble();
        }
        dataInputStream.close();
        return dArray;
    }

    protected void writeFloatArray(DataOutput dataOutput, float[] fArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            dataOutputStream.writeFloat(fArray[i]);
        }
        dataOutputStream.close();
        dataOutput.writeInt(byteArrayOutputStream.size());
        dataOutput.write(byteArrayOutputStream.toByteArray());
    }

    protected float[] readFloatArray(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[dataInput.readInt()];
        dataInput.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        float[] fArray = new float[dataInputStream.readInt()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = dataInputStream.readFloat();
        }
        dataInputStream.close();
        return fArray;
    }
}

