/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectFailedException;
import Ice.ConnectionRefusedException;
import Ice.DNSException;
import Ice.EndpointSelectionType;
import Ice.SocketException;
import IceInternal.BufSizeWarnInfo;
import IceInternal.NetworkProxy;
import IceInternal.ProtocolInstance;
import IceInternal.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class Network {
    public static final int EnableIPv4 = 0;
    public static final int EnableIPv6 = 1;
    public static final int EnableBoth = 2;
    private static Pattern IPV4_PATTERN;
    private static Pattern IPV6_PATTERN;
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))";
    private static IPAddressComparator _preferIPv4Comparator;
    private static IPAddressComparator _preferIPv6Comparator;

    public static boolean isNumericAddress(String ipAddress) {
        Matcher ipv4 = IPV4_PATTERN.matcher(ipAddress);
        if (ipv4.matches()) {
            return true;
        }
        Matcher ipv6 = IPV6_PATTERN.matcher(ipAddress);
        return ipv6.matches();
    }

    public static boolean connectionRefused(ConnectException ex) {
        String msg = ex.getMessage();
        if (msg != null) {
            String[] msgs;
            msg = msg.toLowerCase();
            for (String m : msgs = new String[]{"connection refused", "remote host refused an attempted connect operation"}) {
                if (msg.indexOf(m) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean noMoreFds(Throwable ex) {
        String msg = ex.getMessage();
        if (msg != null) {
            String[] msgs;
            msg = msg.toLowerCase();
            for (String m : msgs = new String[]{"too many open files", "file table overflow", "too many open files in system"}) {
                if (msg.indexOf(m) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isIPv6Supported() {
        try {
            Socket socket = new Socket();
            socket.bind(new InetSocketAddress(InetAddress.getByName("::1"), 0));
            socket.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static SocketChannel createTcpSocket() {
        try {
            SocketChannel fd = SocketChannel.open();
            Socket socket = fd.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            return fd;
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }

    public static ServerSocketChannel createTcpServerSocket() {
        try {
            ServerSocketChannel fd = ServerSocketChannel.open();
            return fd;
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }

    public static DatagramChannel createUdpSocket(InetSocketAddress addr) {
        try {
            Class<?> c = Util.findClass("java.net.StandardProtocolFamily", null);
            if (addr.getAddress().isMulticastAddress() && c != null) {
                String family = "INET";
                if (addr.getAddress() instanceof Inet6Address) {
                    family = "INET6";
                }
                Method valueOf = c.getDeclaredMethod("valueOf", String.class);
                Object[] args = new Object[]{valueOf.invoke(null, family)};
                Method open = DatagramChannel.class.getDeclaredMethod("open", Util.findClass("java.net.ProtocolFamily", null));
                return (DatagramChannel)open.invoke(null, args);
            }
            return DatagramChannel.open();
        }
        catch (IllegalAccessException ex) {
            throw new SocketException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new SocketException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new SocketException(ex);
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }

    public static void closeSocketNoThrow(SelectableChannel fd) {
        try {
            fd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSocket(SelectableChannel fd) {
        try {
            fd.close();
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }

    public static NetworkInterface getInterface(String intf) {
        NetworkInterface iface;
        try {
            iface = NetworkInterface.getByName(intf);
            if (iface != null) {
                return iface;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            iface = NetworkInterface.getByInetAddress(InetAddress.getByName(intf));
            if (iface != null) {
                return iface;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("couldn't find interface `" + intf + "'");
    }

    public static void setMcastInterface(DatagramChannel fd, String intf) {
        try {
            fd.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, Network.getInterface(intf));
        }
        catch (Exception ex) {
            throw new SocketException(ex);
        }
    }

    public static void setMcastGroup(MulticastSocket fd, InetSocketAddress group, String intf) {
        try {
            HashSet<NetworkInterface> interfaces = new HashSet<NetworkInterface>();
            for (String address : Network.getInterfacesForMulticast(intf, Network.getProtocolSupport(group))) {
                NetworkInterface intf2 = Network.getInterface(address);
                if (interfaces.contains(intf2)) continue;
                interfaces.add(intf2);
                fd.joinGroup(group, intf2);
            }
        }
        catch (Exception ex) {
            throw new SocketException(ex);
        }
    }

    public static void setMcastGroup(DatagramChannel fd, InetSocketAddress group, String intf) {
        try {
            HashSet<NetworkInterface> interfaces = new HashSet<NetworkInterface>();
            for (String address : Network.getInterfacesForMulticast(intf, Network.getProtocolSupport(group))) {
                NetworkInterface intf2 = Network.getInterface(address);
                if (interfaces.contains(intf2)) continue;
                interfaces.add(intf2);
                fd.join(group.getAddress(), intf2);
            }
        }
        catch (Exception ex) {
            throw new SocketException(ex);
        }
    }

    public static void setMcastTtl(DatagramChannel fd, int ttl) {
        try {
            fd.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)ttl);
        }
        catch (Exception ex) {
            throw new SocketException(ex);
        }
    }

    public static void setBlock(SelectableChannel fd, boolean block) {
        try {
            fd.configureBlocking(block);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static void setReuseAddress(DatagramChannel fd, boolean reuse) {
        try {
            fd.socket().setReuseAddress(reuse);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static void setReuseAddress(ServerSocketChannel fd, boolean reuse) {
        try {
            fd.socket().setReuseAddress(reuse);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static InetSocketAddress doBind(ServerSocketChannel fd, InetSocketAddress addr, int backlog) {
        try {
            ServerSocket sock = fd.socket();
            sock.bind(addr, backlog);
            return (InetSocketAddress)sock.getLocalSocketAddress();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static InetSocketAddress doBind(DatagramChannel fd, InetSocketAddress addr) {
        try {
            DatagramSocket sock = fd.socket();
            sock.bind(addr);
            return (InetSocketAddress)sock.getLocalSocketAddress();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static SocketChannel doAccept(ServerSocketChannel afd) {
        SocketChannel fd = null;
        while (true) {
            try {
                fd = afd.accept();
            }
            catch (IOException ex) {
                if (Network.interrupted(ex)) continue;
                throw new SocketException(ex);
            }
            break;
        }
        try {
            Socket socket = fd.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
        return fd;
    }

    public static boolean doConnect(SocketChannel fd, InetSocketAddress addr, InetSocketAddress sourceAddr) {
        if (sourceAddr != null) {
            try {
                fd.bind(sourceAddr);
            }
            catch (IOException ex) {
                Network.closeSocketNoThrow(fd);
                throw new SocketException(ex);
            }
        }
        try {
            if (!fd.connect(addr)) {
                return false;
            }
        }
        catch (ConnectException ex) {
            Network.closeSocketNoThrow(fd);
            if (Network.connectionRefused(ex)) {
                throw new ConnectionRefusedException(ex);
            }
            throw new ConnectFailedException(ex);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
        catch (SecurityException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
        if (System.getProperty("os.name").equals("Linux") && addr.equals(fd.socket().getLocalSocketAddress())) {
            Network.closeSocketNoThrow(fd);
            throw new ConnectionRefusedException();
        }
        return true;
    }

    public static void doFinishConnect(SocketChannel fd) {
        try {
            SocketAddress addr;
            if (!fd.finishConnect()) {
                throw new ConnectFailedException();
            }
            if (System.getProperty("os.name").equals("Linux") && (addr = fd.socket().getRemoteSocketAddress()) != null && addr.equals(fd.socket().getLocalSocketAddress())) {
                throw new ConnectionRefusedException();
            }
        }
        catch (ConnectException ex) {
            if (Network.connectionRefused(ex)) {
                throw new ConnectionRefusedException(ex);
            }
            throw new ConnectFailedException(ex);
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
    }

    public static void doConnect(DatagramChannel fd, InetSocketAddress addr, InetSocketAddress sourceAddr) {
        if (sourceAddr != null) {
            Network.doBind(fd, sourceAddr);
        }
        try {
            fd.connect(addr);
        }
        catch (ConnectException ex) {
            Network.closeSocketNoThrow(fd);
            if (Network.connectionRefused(ex)) {
                throw new ConnectionRefusedException(ex);
            }
            throw new ConnectFailedException(ex);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static void setSendBufferSize(SocketChannel fd, int size) {
        try {
            Socket socket = fd.socket();
            socket.setSendBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static int getSendBufferSize(SocketChannel fd) {
        int size;
        try {
            Socket socket = fd.socket();
            size = socket.getSendBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
        return size;
    }

    public static void setRecvBufferSize(SocketChannel fd, int size) {
        try {
            Socket socket = fd.socket();
            socket.setReceiveBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static int getRecvBufferSize(SocketChannel fd) {
        int size;
        try {
            Socket socket = fd.socket();
            size = socket.getReceiveBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
        return size;
    }

    public static void setRecvBufferSize(ServerSocketChannel fd, int size) {
        try {
            ServerSocket socket = fd.socket();
            socket.setReceiveBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static int getRecvBufferSize(ServerSocketChannel fd) {
        int size;
        try {
            ServerSocket socket = fd.socket();
            size = socket.getReceiveBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
        return size;
    }

    public static void setSendBufferSize(DatagramChannel fd, int size) {
        try {
            DatagramSocket socket = fd.socket();
            socket.setSendBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static int getSendBufferSize(DatagramChannel fd) {
        int size;
        try {
            DatagramSocket socket = fd.socket();
            size = socket.getSendBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
        return size;
    }

    public static void setRecvBufferSize(DatagramChannel fd, int size) {
        try {
            DatagramSocket socket = fd.socket();
            socket.setReceiveBufferSize(size);
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
    }

    public static int getRecvBufferSize(DatagramChannel fd) {
        int size;
        try {
            DatagramSocket socket = fd.socket();
            size = socket.getReceiveBufferSize();
        }
        catch (IOException ex) {
            Network.closeSocketNoThrow(fd);
            throw new SocketException(ex);
        }
        return size;
    }

    public static int getProtocolSupport(InetSocketAddress addr) {
        return addr.getAddress().getAddress().length == 4 ? 0 : 1;
    }

    public static InetSocketAddress getAddressForServer(String host, int port, int protocol, boolean preferIPv6) {
        if (host == null || host.length() == 0) {
            try {
                if (protocol != 0) {
                    return new InetSocketAddress(InetAddress.getByName("::0"), port);
                }
                return new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port);
            }
            catch (UnknownHostException ex) {
                assert (false);
                return null;
            }
            catch (SecurityException ex) {
                throw new SocketException(ex);
            }
        }
        return Network.getAddresses(host, port, protocol, EndpointSelectionType.Ordered, preferIPv6, true).get(0);
    }

    public static int compareAddress(InetSocketAddress addr1, InetSocketAddress addr2) {
        byte[] rarr;
        if (addr1 == null) {
            if (addr2 == null) {
                return 0;
            }
            return -1;
        }
        if (addr2 == null) {
            return 1;
        }
        if (addr1.getPort() < addr2.getPort()) {
            return -1;
        }
        if (addr2.getPort() < addr1.getPort()) {
            return 1;
        }
        byte[] larr = addr1.getAddress().getAddress();
        if (larr.length < (rarr = addr2.getAddress().getAddress()).length) {
            return -1;
        }
        if (rarr.length < larr.length) {
            return 1;
        }
        assert (larr.length == rarr.length);
        for (int i = 0; i < larr.length; ++i) {
            if (larr[i] < rarr[i]) {
                return -1;
            }
            if (rarr[i] >= larr[i]) continue;
            return 1;
        }
        return 0;
    }

    public static InetAddress getLocalAddress(int protocol) {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (addr == null || !Network.isValidAddr(addr, protocol)) {
            ArrayList<InetAddress> addrs = Network.getLocalAddresses(protocol);
            Iterator<InetAddress> iter = addrs.iterator();
            while (addr == null && iter.hasNext()) {
                InetAddress a = iter.next();
                if (protocol != 2 && !Network.isValidAddr(a, protocol)) continue;
                addr = a;
            }
            if (addr == null) {
                addr = Network.getLoopbackAddresses(protocol)[0];
            }
        }
        assert (addr != null);
        return addr;
    }

    public static List<InetSocketAddress> getAddresses(String host, int port, int protocol, EndpointSelectionType selType, boolean preferIPv6, boolean blocking) {
        if (!blocking) {
            ArrayList<InetSocketAddress> addrs;
            block13: {
                if (!Network.isNumericAddress(host)) {
                    return null;
                }
                addrs = new ArrayList<InetSocketAddress>();
                try {
                    addrs.add(new InetSocketAddress(InetAddress.getByName(host), port));
                }
                catch (UnknownHostException ex) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
            return addrs;
        }
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        try {
            InetAddress[] addrs = host == null || host.length() == 0 ? Network.getLoopbackAddresses(protocol) : InetAddress.getAllByName(host);
            for (InetAddress addr : addrs) {
                if (protocol != 2 && !Network.isValidAddr(addr, protocol)) continue;
                addresses.add(new InetSocketAddress(addr, port));
            }
            if (selType == EndpointSelectionType.Random) {
                Collections.shuffle(addresses);
            }
            if (protocol == 2) {
                if (preferIPv6) {
                    Collections.sort(addresses, _preferIPv6Comparator);
                } else {
                    Collections.sort(addresses, _preferIPv4Comparator);
                }
            }
        }
        catch (UnknownHostException ex) {
            throw new DNSException(0, host, ex);
        }
        catch (SecurityException ex) {
            throw new SocketException(ex);
        }
        if (addresses.isEmpty()) {
            throw new DNSException(0, host);
        }
        return addresses;
    }

    public static ArrayList<InetAddress> getLocalAddresses(int protocol) {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (addr.isLoopbackAddress() || protocol != 2 && !Network.isValidAddr(addr, protocol)) continue;
                    result.add(addr);
                }
            }
        }
        catch (java.net.SocketException ex) {
            throw new SocketException(ex);
        }
        catch (SecurityException ex) {
            throw new SocketException(ex);
        }
        return result;
    }

    public static SocketPair createPipe() {
        SocketPair fds = new SocketPair();
        try {
            Pipe pipe = Pipe.open();
            fds.sink = pipe.sink();
            fds.source = pipe.source();
        }
        catch (IOException ex) {
            throw new SocketException(ex);
        }
        return fds;
    }

    public static ArrayList<String> getHostsForEndpointExpand(String host, int protocolSupport, boolean includeLoopback) {
        ArrayList<String> hosts = new ArrayList<String>();
        if (Network.isWildcard(host)) {
            ArrayList<InetAddress> addrs = Network.getLocalAddresses(protocolSupport);
            for (InetAddress addr : addrs) {
                if (addr.isLinkLocalAddress()) continue;
                hosts.add(addr.getHostAddress());
            }
            if (includeLoopback || hosts.isEmpty()) {
                if (protocolSupport != 1) {
                    hosts.add("127.0.0.1");
                }
                if (protocolSupport != 0) {
                    hosts.add("0:0:0:0:0:0:0:1");
                }
            }
        }
        return hosts;
    }

    public static List<String> getInterfacesForMulticast(String intf, int protocolSupport) {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (Network.isWildcard(intf)) {
            ArrayList<InetAddress> addrs = Network.getLocalAddresses(protocolSupport);
            for (InetAddress addr : addrs) {
                interfaces.add(addr.getHostAddress());
            }
            if (protocolSupport != 1) {
                interfaces.add("127.0.0.1");
            }
            if (protocolSupport != 0) {
                interfaces.add("0:0:0:0:0:0:0:1");
            }
        }
        if (interfaces.isEmpty()) {
            interfaces.add(intf);
        }
        return interfaces;
    }

    public static void setTcpBufSize(SocketChannel socket, ProtocolInstance instance) {
        int dfltBufSize = 0;
        if (System.getProperty("os.name").startsWith("Windows")) {
            dfltBufSize = 131072;
        }
        int rcvSize = instance.properties().getPropertyAsIntWithDefault("Ice.TCP.RcvSize", dfltBufSize);
        int sndSize = instance.properties().getPropertyAsIntWithDefault("Ice.TCP.SndSize", dfltBufSize);
        Network.setTcpBufSize(socket, rcvSize, sndSize, instance);
    }

    public static void setTcpBufSize(SocketChannel socket, int rcvSize, int sndSize, ProtocolInstance instance) {
        BufSizeWarnInfo winfo;
        int size;
        if (rcvSize > 0) {
            Network.setRecvBufferSize(socket, rcvSize);
            size = Network.getRecvBufferSize(socket);
            if (size < rcvSize) {
                winfo = instance.getBufSizeWarn((short)1);
                if (!winfo.rcvWarn || rcvSize != winfo.rcvSize) {
                    instance.logger().warning("TCP receive buffer size: requested size of " + rcvSize + " adjusted to " + size);
                    instance.setRcvBufSizeWarn((short)1, rcvSize);
                }
            }
        }
        if (sndSize > 0) {
            Network.setSendBufferSize(socket, sndSize);
            size = Network.getSendBufferSize(socket);
            if (size < sndSize) {
                winfo = instance.getBufSizeWarn((short)1);
                if (!winfo.sndWarn || sndSize != winfo.sndSize) {
                    instance.logger().warning("TCP send buffer size: requested size of " + sndSize + " adjusted to " + size);
                    instance.setSndBufSizeWarn((short)1, sndSize);
                }
            }
        }
    }

    public static void setTcpBufSize(ServerSocketChannel socket, ProtocolInstance instance) {
        int sizeRequested;
        int dfltBufSize = 0;
        if (System.getProperty("os.name").startsWith("Windows")) {
            dfltBufSize = 131072;
        }
        if ((sizeRequested = instance.properties().getPropertyAsIntWithDefault("Ice.TCP.RcvSize", dfltBufSize)) > 0) {
            Network.setRecvBufferSize(socket, sizeRequested);
            int size = Network.getRecvBufferSize(socket);
            if (size < sizeRequested) {
                BufSizeWarnInfo winfo = instance.getBufSizeWarn((short)1);
                if (!winfo.rcvWarn || sizeRequested != winfo.rcvSize) {
                    instance.logger().warning("TCP receive buffer size: requested size of " + sizeRequested + " adjusted to " + size);
                    instance.setRcvBufSizeWarn((short)1, sizeRequested);
                }
            }
        }
    }

    public static String fdToString(SelectableChannel fd, NetworkProxy proxy, InetSocketAddress target) {
        if (fd == null) {
            return "<closed>";
        }
        InetAddress localAddr = null;
        InetAddress remoteAddr = null;
        int localPort = -1;
        int remotePort = -1;
        if (fd instanceof SocketChannel) {
            Socket socket = ((SocketChannel)fd).socket();
            localAddr = socket.getLocalAddress();
            localPort = socket.getLocalPort();
            remoteAddr = socket.getInetAddress();
            remotePort = socket.getPort();
        } else if (fd instanceof DatagramChannel) {
            DatagramSocket socket = ((DatagramChannel)fd).socket();
            localAddr = socket.getLocalAddress();
            localPort = socket.getLocalPort();
            remoteAddr = socket.getInetAddress();
            remotePort = socket.getPort();
        } else assert (false);
        return Network.addressesToString(localAddr, localPort, remoteAddr, remotePort, proxy, target);
    }

    public static String fdToString(SelectableChannel fd) {
        if (fd == null) {
            return "<closed>";
        }
        InetAddress localAddr = null;
        InetAddress remoteAddr = null;
        int localPort = -1;
        int remotePort = -1;
        if (fd instanceof SocketChannel) {
            Socket socket = ((SocketChannel)fd).socket();
            localAddr = socket.getLocalAddress();
            localPort = socket.getLocalPort();
            remoteAddr = socket.getInetAddress();
            remotePort = socket.getPort();
        } else if (fd instanceof DatagramChannel) {
            DatagramSocket socket = ((DatagramChannel)fd).socket();
            localAddr = socket.getLocalAddress();
            localPort = socket.getLocalPort();
            remoteAddr = socket.getInetAddress();
            remotePort = socket.getPort();
        } else assert (false);
        return Network.addressesToString(localAddr, localPort, remoteAddr, remotePort);
    }

    public static String addressesToString(InetAddress localAddr, int localPort, InetAddress remoteAddr, int remotePort, NetworkProxy proxy, InetSocketAddress target) {
        StringBuilder s = new StringBuilder(128);
        s.append("local address = ");
        s.append(Network.addrToString(localAddr, localPort));
        if (proxy != null) {
            if (remoteAddr == null) {
                InetSocketAddress addr = proxy.getAddress();
                remoteAddr = addr.getAddress();
                remotePort = addr.getPort();
            }
            s.append("\n");
            s.append(proxy.getName());
            s.append(" proxy address = ");
            s.append(Network.addrToString(remoteAddr, remotePort));
            s.append("\nremote address = ");
            s.append(Network.addrToString(target.getAddress(), target.getPort()));
        } else {
            if (remoteAddr == null && target != null) {
                remoteAddr = target.getAddress();
                remotePort = target.getPort();
            }
            if (remoteAddr == null) {
                s.append("\nremote address = <not connected>");
            } else {
                s.append("\nremote address = ");
                s.append(Network.addrToString(remoteAddr, remotePort));
            }
        }
        return s.toString();
    }

    public static String addressesToString(InetAddress localAddr, int localPort, InetAddress remoteAddr, int remotePort) {
        return Network.addressesToString(localAddr, localPort, remoteAddr, remotePort, null, null);
    }

    public static String addrToString(InetSocketAddress addr) {
        StringBuilder s = new StringBuilder(128);
        s.append(addr.getAddress().getHostAddress());
        s.append(':');
        s.append(addr.getPort());
        return s.toString();
    }

    public static boolean interrupted(IOException ex) {
        return ex instanceof InterruptedIOException;
    }

    private static boolean isValidAddr(InetAddress addr, int protocol) {
        byte[] bytes = null;
        if (addr != null) {
            bytes = addr.getAddress();
        }
        return bytes != null && (bytes.length == 16 && protocol == 1 || bytes.length == 4 && protocol == 0);
    }

    public static String addrToString(InetAddress addr, int port) {
        StringBuffer s = new StringBuffer();
        if (addr == null || addr.isAnyLocalAddress()) {
            s.append("<not available>");
        } else {
            s.append(addr.getHostAddress());
        }
        if (port > 0) {
            s.append(':');
            s.append(port);
        }
        return s.toString();
    }

    private static InetAddress[] getLoopbackAddresses(int protocol) {
        try {
            InetAddress[] addrs = new InetAddress[protocol == 2 ? 2 : 1];
            int i = 0;
            if (protocol != 1) {
                addrs[i++] = InetAddress.getByName("127.0.0.1");
            }
            if (protocol != 0) {
                addrs[i++] = InetAddress.getByName("::1");
            }
            return addrs;
        }
        catch (UnknownHostException ex) {
            assert (false);
            return null;
        }
        catch (SecurityException ex) {
            throw new SocketException(ex);
        }
    }

    public static InetSocketAddress getNumericAddress(String address) {
        InetSocketAddress addr = null;
        if (!address.isEmpty() && Network.isNumericAddress(address)) {
            try {
                addr = new InetSocketAddress(InetAddress.getByName(address), 0);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return addr;
    }

    private static boolean isWildcard(String host) {
        if (host == null || host.length() == 0) {
            return true;
        }
        try {
            return InetAddress.getByName(host).isAnyLocalAddress();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException ex) {
            throw new SocketException(ex);
        }
        return false;
    }

    static {
        block2: {
            IPV4_PATTERN = null;
            IPV6_PATTERN = null;
            try {
                IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
                IPV6_PATTERN = Pattern.compile(ipv6Pattern, 2);
            }
            catch (PatternSyntaxException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        _preferIPv4Comparator = new IPAddressComparator(false);
        _preferIPv6Comparator = new IPAddressComparator(true);
    }

    static class IPAddressComparator
    implements Comparator<InetSocketAddress> {
        private final boolean _ipv6;

        IPAddressComparator(boolean ipv6) {
            this._ipv6 = ipv6;
        }

        @Override
        public int compare(InetSocketAddress lhs, InetSocketAddress rhs) {
            if (lhs.getAddress().getAddress().length < rhs.getAddress().getAddress().length) {
                return this._ipv6 ? 1 : -1;
            }
            if (lhs.getAddress().getAddress().length > rhs.getAddress().getAddress().length) {
                return this._ipv6 ? -1 : 1;
            }
            return 0;
        }
    }

    public static final class SocketPair {
        public AbstractSelectableChannel source;
        public WritableByteChannel sink;
    }
}

