/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.DoubleByte;

public abstract class ByteToCharEUC2
extends ByteToCharConverter {
    private final int G0 = 0;
    private final int G1 = 1;
    private final int SS2 = 142;
    private final int SS3 = 143;
    private int firstByte;
    private int state = 0;
    private DoubleByte.Decoder dec;

    public ByteToCharEUC2(DoubleByte.Decoder dec) {
        this.dec = dec;
    }

    char decodeSingle(int b) {
        return this.dec.decodeSingle(b);
    }

    char decodeDouble(int b1, int b2) {
        return this.dec.decodeDouble(b1, b2);
    }

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.state != 0) {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    public void reset() {
        this.state = 0;
        this.byteOff = 0;
        this.charOff = 0;
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int outputChar = 65533;
        this.byteOff = inOff;
        this.charOff = outOff;
        while (this.byteOff < inEnd) {
            int byte1 = input[this.byteOff] & 0xFF;
            switch (this.state) {
                case 0: {
                    if (byte1 == 142 || byte1 == 143) {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                    if (byte1 <= 159) {
                        outputChar = this.decodeSingle(byte1);
                        break;
                    }
                    if (byte1 < 161 || byte1 > 254) {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                    this.firstByte = byte1;
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.state = 0;
                    if (byte1 < 161 || byte1 > 254) {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                    outputChar = this.decodeDouble(this.firstByte, byte1);
                }
            }
            if (this.state == 0) {
                if (outputChar == 65533) {
                    if (this.subMode) {
                        outputChar = this.subChars[0];
                    } else {
                        this.badInputLength = 1;
                        throw new UnknownCharacterException();
                    }
                }
                if (this.charOff >= outEnd) {
                    throw new ConversionBufferFullException();
                }
                output[this.charOff++] = outputChar;
            }
            ++this.byteOff;
        }
        return this.charOff - outOff;
    }
}

