/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.graphics;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.graphics.Epsfig;
import com.dickimawbooks.texparserlib.latex.graphics.GraphicsPath;
import com.dickimawbooks.texparserlib.latex.graphics.IncludeGraphics;
import com.dickimawbooks.texparserlib.latex.graphics.ReflectBox;
import com.dickimawbooks.texparserlib.latex.graphics.ResizeBox;
import com.dickimawbooks.texparserlib.latex.graphics.RotateBox;
import com.dickimawbooks.texparserlib.latex.graphics.ScaleBox;
import java.io.IOException;

public class GraphicsSty
extends LaTeXSty {
    public GraphicsSty(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener) throws IOException {
        super(keyValList, string, laTeXParserListener);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new IncludeGraphics(this));
        this.registerControlSequence(new RotateBox());
        this.registerControlSequence(new ScaleBox());
        this.registerControlSequence(new ReflectBox());
        this.registerControlSequence(new ResizeBox());
        this.registerControlSequence(new GraphicsPath());
        this.registerControlSequence(new Epsfig("epsfig"));
        this.registerControlSequence(new Epsfig("psfig"));
    }

    @Override
    public void processOption(String string) throws IOException {
    }

    @Override
    protected void preOptions() throws IOException {
    }

    public static double getDouble(TeXObject teXObject, TeXParser teXParser) throws TeXSyntaxException {
        String string = teXObject.toString(teXParser);
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", string);
        }
    }

    public static TeXDimension getDimension(TeXObject teXObject, TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser)) != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        if (teXObject instanceof TeXObjectList) {
            return ((TeXObjectList)teXObject).popDimension(teXParser);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", teXObject.toString(teXParser));
    }
}

