/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.shape.Point;

public class PointBuilder
extends ShapeBuilder<Point, PointBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.POINT;

    public PointBuilder() {
        this.coordinates.add(ZERO_ZERO);
    }

    public PointBuilder(double lon, double lat) {
        this.coordinates.add(new Coordinate(lon, lat));
    }

    public PointBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public PointBuilder coordinate(Coordinate coordinate) {
        this.coordinates.set(0, coordinate);
        return this;
    }

    public double longitude() {
        return ((Coordinate)this.coordinates.get((int)0)).x;
    }

    public double latitude() {
        return ((Coordinate)this.coordinates.get((int)0)).y;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
        PointBuilder.toXContent(builder, (Coordinate)this.coordinates.get(0));
        return builder.endObject();
    }

    @Override
    public Point build() {
        return SPATIAL_CONTEXT.makePoint(((Coordinate)this.coordinates.get((int)0)).x, ((Coordinate)this.coordinates.get((int)0)).y);
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }
}

