/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ServerListTableModel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.ServerInfo;

public final class ServerListPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(ServerListPanel.class.getName());
    private static final int CONNECT = 0;
    private static final int CANCEL = 1;
    private final ConnectController connectController;
    private final JTable table;
    private final ServerListTableModel tableModel;
    private final JButton connect;

    public ServerListPanel(FreeColClient freeColClient, ConnectController connectController) {
        super(freeColClient, new MigLayout("", "", ""));
        this.connectController = connectController;
        JButton cancel = Utility.localizedButton("cancel");
        this.setCancelComponent(cancel);
        this.connect = Utility.localizedButton("connect");
        this.tableModel = new ServerListTableModel(new ArrayList<ServerInfo>());
        this.table = new JTable(this.tableModel);
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable t, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setOpaque(isSelected);
                return super.getTableCellRendererComponent(t, o, isSelected, hasFocus, row, column);
            }
        };
        for (int i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(dtcr);
        }
        this.table.setRowHeight(22);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        JScrollPane tableScroll = new JScrollPane(this.table);
        this.table.addNotify();
        tableScroll.getViewport().setOpaque(false);
        tableScroll.getColumnHeader().setOpaque(false);
        this.connect.setActionCommand(String.valueOf(0));
        this.connect.addActionListener(this);
        cancel.setActionCommand(String.valueOf(1));
        cancel.addActionListener(this);
        this.add((Component)tableScroll, "width 400:, height 350:");
        this.add((Component)this.connect, "newline 20, split 2");
        this.add((Component)cancel, "tag cancel");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.connect.requestFocus();
    }

    public void initialize(List<ServerInfo> servers) {
        Iterator<ServerInfo> it = servers.iterator();
        while (it.hasNext()) {
            ServerInfo si = it.next();
            if (si.getVersion().equals(FreeCol.getVersion())) continue;
            it.remove();
        }
        this.tableModel.setItems(servers);
        this.setEnabled(true);
        if (servers.isEmpty()) {
            this.connect.setEnabled(false);
        } else {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components;
        super.setEnabled(enabled);
        for (Component component : components = this.getComponents()) {
            component.setEnabled(enabled);
        }
        this.table.setEnabled(enabled);
    }

    public void refreshTable() {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        try {
            switch (Integer.parseInt(command)) {
                case 0: {
                    ServerInfo si = this.tableModel.getItem(this.table.getSelectedRow());
                    this.connectController.joinMultiplayerGame(si.getAddress(), si.getPort());
                    break;
                }
                case 1: {
                    this.getGUI().removeFromCanvas(this);
                    this.getGUI().showNewPanel();
                    break;
                }
                default: {
                    super.actionPerformed(ae);
                    break;
                }
            }
        }
        catch (NumberFormatException nfe) {
            logger.warning("Invalid ActionEvent, not a number: " + command);
        }
    }
}

