/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.detection.TestClassVisitor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.internal.FileUtils;
import org.gradle.util.internal.PatchedClassReader;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestFrameworkDetector<T extends TestClassVisitor>
implements TestFrameworkDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestFrameworkDetector.class);
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private List<File> testClassDirectories;
    private final ClassFileExtractionManager classFileExtractionManager;
    private final Map<File, Boolean> superClasses;
    private TestClassProcessor testClassProcessor;
    private Set<File> testClassesDirectories;
    private Set<File> testClasspath;

    protected AbstractTestFrameworkDetector(ClassFileExtractionManager classFileExtractionManager) {
        assert (classFileExtractionManager != null);
        this.classFileExtractionManager = classFileExtractionManager;
        this.superClasses = new HashMap<File, Boolean>();
    }

    protected abstract T createClassVisitor();

    private File getSuperTestClassFile(String superClassName) {
        this.prepareClasspath();
        if (StringUtils.isEmpty((String)superClassName)) {
            throw new IllegalArgumentException("superClassName is empty!");
        }
        File superTestClassFile = null;
        for (File testClassDirectory : this.testClassDirectories) {
            File candidate = new File(testClassDirectory, superClassName + ".class");
            if (!candidate.exists()) continue;
            superTestClassFile = candidate;
        }
        if (superTestClassFile != null) {
            return superTestClassFile;
        }
        if (JAVA_LANG_OBJECT.equals(superClassName)) {
            return null;
        }
        return this.classFileExtractionManager.getLibraryClassFile(superClassName);
    }

    private void prepareClasspath() {
        if (this.testClassDirectories != null) {
            return;
        }
        this.testClassDirectories = new ArrayList<File>();
        if (this.testClassesDirectories != null) {
            this.testClassDirectories.addAll(this.testClassesDirectories);
        }
        if (this.testClasspath != null) {
            for (File file : this.testClasspath) {
                if (file.isDirectory()) {
                    this.testClassDirectories.add(file);
                    continue;
                }
                if (!file.isFile() || !FileUtils.hasExtension((File)file, (String)".jar")) continue;
                this.classFileExtractionManager.addLibraryJar(file);
            }
        }
    }

    @Override
    public void setTestClasses(Set<File> testClassesDirectories) {
        this.testClassesDirectories = testClassesDirectories;
    }

    @Override
    public void setTestClasspath(Set<File> testClasspath) {
        this.testClasspath = testClasspath;
    }

    protected TestClassVisitor classVisitor(File testClassFile) {
        T classVisitor = this.createClassVisitor();
        BufferedInputStream classStream = null;
        try {
            classStream = new BufferedInputStream(new FileInputStream(testClassFile));
            PatchedClassReader classReader = new PatchedClassReader(IOUtils.toByteArray((InputStream)classStream));
            classReader.accept(classVisitor, 7);
        }
        catch (Throwable e) {
            try {
                throw new GradleException("failed to read class file " + testClassFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(classStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)classStream);
        return classVisitor;
    }

    @Override
    public boolean processTestClass(File testClassFile) {
        return this.processTestClass(testClassFile, false);
    }

    private boolean processTestClass(File testClassFile, boolean superClass) {
        TestClassVisitor classVisitor = this.classVisitor(testClassFile);
        boolean isTest = classVisitor.isTest();
        if (!isTest) {
            String superClassName = classVisitor.getSuperClassName();
            if (this.isKnownTestCaseClassName(superClassName)) {
                isTest = true;
            } else {
                File superClassFile = this.getSuperTestClassFile(superClassName);
                if (superClassFile != null) {
                    isTest = this.processSuperClass(superClassFile);
                } else {
                    LOGGER.debug("test-class-scan : failed to scan parent class {}, could not find the class file", (Object)superClassName);
                }
            }
        }
        this.publishTestClass(isTest, classVisitor, superClass);
        return isTest;
    }

    protected abstract boolean isKnownTestCaseClassName(String var1);

    private boolean processSuperClass(File testClassFile) {
        boolean isTest;
        Boolean isSuperTest = this.superClasses.get(testClassFile);
        if (isSuperTest == null) {
            isTest = this.processTestClass(testClassFile, true);
            this.superClasses.put(testClassFile, isTest);
        } else {
            isTest = isSuperTest;
        }
        return isTest;
    }

    private void publishTestClass(boolean isTest, TestClassVisitor classVisitor, boolean superClass) {
        if (isTest && !classVisitor.isAbstract() && !superClass) {
            String className = Type.getObjectType((String)classVisitor.getClassName()).getClassName();
            this.testClassProcessor.processTestClass((TestClassRunInfo)new DefaultTestClassRunInfo(className));
        }
    }

    @Override
    public void startDetection(TestClassProcessor testClassProcessor) {
        this.testClassProcessor = testClassProcessor;
    }
}

