/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.util.Collection;
import java.util.zip.ZipException;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.ClasspathEntrySnapshotBuilder;
import org.gradle.api.internal.changedetection.state.CollectingFileCollectionSnapshotBuilder;
import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.DirectoryFileSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileTree;
import org.gradle.api.internal.changedetection.state.InputPathNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.VisitingFileCollectionSnapshotBuilder;
import org.gradle.api.internal.changedetection.state.ZipTree;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.FileUtils;
import org.gradle.internal.hash.HashCode;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClasspathSnapshotBuilder
implements VisitingFileCollectionSnapshotBuilder {
    protected final CollectingFileCollectionSnapshotBuilder builder;
    private final ResourceHasher classpathResourceHasher;
    private final StringInterner stringInterner;
    private final ResourceSnapshotterCacheService cacheService;
    private final JarHasher jarHasher;
    private final HashCode jarHasherConfigurationHash;

    public AbstractClasspathSnapshotBuilder(ResourceHasher classpathResourceHasher, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        this.builder = new CollectingFileCollectionSnapshotBuilder(TaskFilePropertyCompareStrategy.ORDERED, InputPathNormalizationStrategy.NONE, stringInterner);
        this.cacheService = cacheService;
        this.stringInterner = stringInterner;
        this.classpathResourceHasher = classpathResourceHasher;
        this.jarHasher = new JarHasher();
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        this.jarHasher.appendConfigurationToHasher((BuildCacheHasher)hasher);
        this.jarHasherConfigurationHash = hasher.hash();
    }

    protected abstract void visitNonJar(RegularFileSnapshot var1);

    @Override
    public void visitDirectorySnapshot(DirectoryFileSnapshot directory) {
    }

    @Override
    public void visitMissingFileSnapshot(MissingFileSnapshot missingFile) {
    }

    @Override
    public void visitFileTreeSnapshot(Collection<FileSnapshot> descendants) {
        ClasspathEntrySnapshotBuilder entryResourceCollectionBuilder = this.newClasspathEntrySnapshotBuilder();
        try {
            new FileTree(descendants).visit(entryResourceCollectionBuilder);
        }
        catch (IOException e) {
            throw new GradleException("Error while snapshotting directory in classpath", (Throwable)e);
        }
        entryResourceCollectionBuilder.collectNormalizedSnapshots(this.builder);
    }

    @Override
    public void visitFileSnapshot(RegularFileSnapshot file) {
        if (FileUtils.hasExtensionIgnoresCase((String)file.getName(), (String)".jar")) {
            this.visitJar(file);
        } else {
            this.visitNonJar(file);
        }
    }

    private void visitJar(RegularFileSnapshot jarFile) {
        HashCode hash = this.cacheService.hashFile(jarFile, this.jarHasher, this.jarHasherConfigurationHash);
        if (hash != null) {
            this.builder.collectFileSnapshot(jarFile.withContentHash(hash));
        }
    }

    private ClasspathEntrySnapshotBuilder newClasspathEntrySnapshotBuilder() {
        return new ClasspathEntrySnapshotBuilder(this.classpathResourceHasher, this.stringInterner);
    }

    @Override
    public FileCollectionSnapshot build() {
        return this.builder.build();
    }

    private class JarHasher
    implements RegularFileHasher,
    ConfigurableNormalizer {
        private JarHasher() {
        }

        @Nullable
        public HashCode hash(RegularFileSnapshot fileSnapshot) {
            return this.hashJarContents(fileSnapshot);
        }

        public void appendConfigurationToHasher(BuildCacheHasher hasher) {
            hasher.putString((CharSequence)this.getClass().getName());
            AbstractClasspathSnapshotBuilder.this.classpathResourceHasher.appendConfigurationToHasher(hasher);
        }

        private HashCode hashJarContents(RegularFileSnapshot jarFile) {
            try {
                ClasspathEntrySnapshotBuilder classpathEntrySnapshotBuilder = AbstractClasspathSnapshotBuilder.this.newClasspathEntrySnapshotBuilder();
                new ZipTree(jarFile).visit(classpathEntrySnapshotBuilder);
                return classpathEntrySnapshotBuilder.getHash();
            }
            catch (ZipException e) {
                return this.hashMalformedZip(jarFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error snapshotting jar [" + jarFile.getName() + "]", (Throwable)e);
            }
            catch (Exception e) {
                return this.hashMalformedZip(jarFile);
            }
        }

        private HashCode hashMalformedZip(FileSnapshot fileSnapshot) {
            DeprecationLogger.nagUserWith((String)("Malformed jar [" + fileSnapshot.getName() + "] found on classpath. Gradle 5.0 will no longer allow malformed jars on a classpath."));
            return fileSnapshot.getContent().getContentMd5();
        }
    }
}

