/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.taskfactory.DefaultTaskClassInfoStore;
import org.gradle.api.internal.tasks.properties.AbstractNestedPropertyContext;
import org.gradle.api.internal.tasks.properties.AbstractPropertyNode;
import org.gradle.api.internal.tasks.properties.DefaultPropertyMetadataStore;
import org.gradle.api.internal.tasks.properties.NestedPropertyContext;
import org.gradle.api.internal.tasks.properties.PropertyMetadata;
import org.gradle.api.internal.tasks.properties.PropertyMetadataStore;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.annotations.ClasspathPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.CompileClasspathPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class PropertyValidationAccess {
    private static final Map<Class<? extends Annotation>, PropertyValidator> PROPERTY_VALIDATORS = ImmutableMap.of(Input.class, (Object)new InputOnFileTypeValidator(), InputFiles.class, (Object)new MissingPathSensitivityValidator(), InputFile.class, (Object)new MissingPathSensitivityValidator(), InputDirectory.class, (Object)new MissingPathSensitivityValidator());

    public static void collectTaskValidationProblems(Class<?> topLevelBean, Map<String, Boolean> problems) {
        DefaultTaskClassInfoStore taskClassInfoStore = new DefaultTaskClassInfoStore();
        DefaultPropertyMetadataStore metadataStore = new DefaultPropertyMetadataStore((Iterable<? extends PropertyAnnotationHandler>)ImmutableList.of((Object)new ClasspathPropertyAnnotationHandler(), (Object)new CompileClasspathPropertyAnnotationHandler()));
        ArrayDeque<BeanTypeNode> queue = new ArrayDeque<BeanTypeNode>();
        queue.add(new BeanTypeNode(null, TypeToken.of(topLevelBean)));
        boolean cacheable = taskClassInfoStore.getTaskClassInfo((Class)Cast.uncheckedCast(topLevelBean)).isCacheable();
        while (!queue.isEmpty()) {
            BeanTypeNode node = (BeanTypeNode)queue.remove();
            PropertyValidationAccess.validateTaskClass(topLevelBean, cacheable, problems, node, new NestedTypeContext(metadataStore, queue), metadataStore.getTypeMetadata(node.getBeanClass()));
        }
    }

    private static void validateTaskClass(Class<?> beanClass, boolean cacheable, Map<String, Boolean> problems, BeanTypeNode node, NestedPropertyContext<BeanTypeNode> context, TypeMetadata typeMetadata) {
        for (PropertyMetadata metadata : typeMetadata.getPropertiesMetadata()) {
            PropertyValidator validator;
            String validationMessage;
            String qualifiedPropertyName = node.getQualifiedPropertyName(metadata.getFieldName());
            for (String validationMessage2 : metadata.getValidationMessages()) {
                problems.put(PropertyValidationAccess.propertyValidationMessage(beanClass, qualifiedPropertyName, validationMessage2), Boolean.FALSE);
            }
            Class<? extends Annotation> propertyType = metadata.getPropertyType();
            if (propertyType == null) {
                if (Modifier.isPrivate(metadata.getMethod().getModifiers())) continue;
                problems.put(PropertyValidationAccess.propertyValidationMessage(beanClass, qualifiedPropertyName, "is not annotated with an input or output annotation"), Boolean.FALSE);
                continue;
            }
            if (PROPERTY_VALIDATORS.containsKey(propertyType) && (validationMessage = (validator = PROPERTY_VALIDATORS.get(propertyType)).validate(cacheable, metadata)) != null) {
                problems.put(PropertyValidationAccess.propertyValidationMessage(beanClass, qualifiedPropertyName, validationMessage), Boolean.FALSE);
            }
            if (!metadata.isAnnotationPresent(Nested.class)) continue;
            AbstractNestedPropertyContext.collectNestedProperties(new BeanTypeNode(qualifiedPropertyName, TypeToken.of((Type)metadata.getMethod().getGenericReturnType())), context);
        }
    }

    private static String propertyValidationMessage(Class<?> task, String qualifiedPropertyName, String validationMessage) {
        return String.format("Task type '%s': property '%s' %s.", task.getName(), qualifiedPropertyName, validationMessage);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NestedTypeContext
    extends AbstractNestedPropertyContext<BeanTypeNode> {
        private final Queue<BeanTypeNode> queue;

        public NestedTypeContext(PropertyMetadataStore metadataStore, Queue<BeanTypeNode> queue) {
            super(metadataStore);
            this.queue = queue;
        }

        @Override
        public void addNested(BeanTypeNode node) {
            this.queue.add(node);
        }
    }

    private static class MissingPathSensitivityValidator
    implements PropertyValidator {
        private MissingPathSensitivityValidator() {
        }

        @Nullable
        public String validate(boolean cacheable, PropertyMetadata metadata) {
            PathSensitive pathSensitive = metadata.getAnnotation(PathSensitive.class);
            if (cacheable && pathSensitive == null) {
                return "is missing a @PathSensitive annotation, defaulting to PathSensitivity.ABSOLUTE";
            }
            return null;
        }
    }

    private static class InputOnFileTypeValidator
    implements PropertyValidator {
        private InputOnFileTypeValidator() {
        }

        @Nullable
        public String validate(boolean cacheable, PropertyMetadata metadata) {
            Class<?> valueType = metadata.getDeclaredType();
            if (File.class.isAssignableFrom(valueType) || Path.class.isAssignableFrom(valueType) || FileCollection.class.isAssignableFrom(valueType)) {
                return "has @Input annotation used on property of type " + valueType.getName();
            }
            return null;
        }
    }

    private static interface PropertyValidator {
        @Nullable
        public String validate(boolean var1, PropertyMetadata var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanTypeNode
    extends AbstractPropertyNode<BeanTypeNode> {
        private final TypeToken<?> beanType;

        public BeanTypeNode(@Nullable String parentPropertyName, TypeToken<?> beanType) {
            super(parentPropertyName, beanType.getRawType());
            this.beanType = beanType;
        }

        @Override
        public Iterator<BeanTypeNode> getIterator() {
            TypeToken typeToken = (TypeToken)Cast.uncheckedCast(this.beanType);
            ParameterizedType type = (ParameterizedType)typeToken.getSupertype(Iterable.class).getType();
            TypeToken nestedType = TypeToken.of((Type)type.getActualTypeArguments()[0]);
            return Iterators.singletonIterator((Object)new BeanTypeNode(this.getPropertyName() + "*", nestedType));
        }
    }
}

