/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.internal.tasks.compile.processing.IncrementalAnnotationProcessorType;
import org.gradle.api.internal.tasks.compile.processing.MultipleOriginProcessor;
import org.gradle.api.internal.tasks.compile.processing.SingleOriginProcessor;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;

class IncrementalAnnotationProcessingCompileTask
implements JavaCompiler.CompilationTask {
    private final JavaCompiler.CompilationTask delegate;
    private final Set<AnnotationProcessorDeclaration> processorDeclarations;
    private final List<File> annotationProcessorPath;
    private URLClassLoader processorClassloader;
    private boolean called;

    IncrementalAnnotationProcessingCompileTask(JavaCompiler.CompilationTask delegate, Set<AnnotationProcessorDeclaration> processorDeclarations, List<File> annotationProcessorPath) {
        this.delegate = delegate;
        this.processorDeclarations = processorDeclarations;
        this.annotationProcessorPath = annotationProcessorPath;
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        throw new UnsupportedOperationException("This decorator already handles annotation processing");
    }

    @Override
    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        if (this.called) {
            throw new IllegalStateException("Cannot reuse a compilation task");
        }
        this.called = true;
        try {
            this.setupProcessors();
            Boolean bl = this.delegate.call();
            return bl;
        }
        finally {
            this.cleanupProcessors();
        }
    }

    private void setupProcessors() {
        this.processorClassloader = new URLClassLoader(DefaultClassPath.of(this.annotationProcessorPath).getAsURLArray());
        ArrayList<Processor> processors = new ArrayList<Processor>(this.processorDeclarations.size());
        for (AnnotationProcessorDeclaration declaredProcessor : this.processorDeclarations) {
            try {
                Class<?> processorClass = this.processorClassloader.loadClass(declaredProcessor.getClassName());
                Processor processor = (Processor)processorClass.newInstance();
                processor = this.decorateIfIncremental(processor, declaredProcessor.getType());
                processors.add(processor);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.delegate.setProcessors(processors);
    }

    private Processor decorateIfIncremental(Processor processor, IncrementalAnnotationProcessorType type) {
        switch (type) {
            case SINGLE_ORIGIN: {
                return new SingleOriginProcessor(processor);
            }
            case MULTIPLE_ORIGIN: {
                return new MultipleOriginProcessor(processor);
            }
        }
        return processor;
    }

    private void cleanupProcessors() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.processorClassloader}).stop();
    }
}

