/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.tasks.internal.RelativeFileNameTransformer;
import org.gradle.ide.visualstudio.tasks.internal.VisualStudioProjectFile;
import org.gradle.plugins.ide.api.XmlGeneratorTask;
import org.gradle.plugins.ide.internal.IdePlugin;

@Incubating
public class GenerateProjectFileTask
extends XmlGeneratorTask<VisualStudioProjectFile> {
    private DefaultVisualStudioProject visualStudioProject;
    private String gradleExe;
    private String gradleArgs;

    public void initGradleCommand() {
        final File gradlew = new File(IdePlugin.toGradleCommand((Project)this.getProject()));
        this.getConventionMapping().map("gradleExe", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                String rootDir = (String)GenerateProjectFileTask.this.getTransformer().transform((Object)GenerateProjectFileTask.this.getProject().getRootDir());
                String args = "";
                if (!rootDir.equals(".")) {
                    args = " -p \"" + rootDir + "\"";
                }
                if (gradlew.isFile()) {
                    return "\"" + (String)GenerateProjectFileTask.this.getTransformer().transform((Object)gradlew) + "\"" + args;
                }
                return "\"gradle\"" + args;
            }
        });
    }

    @Internal
    public Transformer<String, File> getTransformer() {
        return RelativeFileNameTransformer.forFile(this.getProject().getRootDir(), this.visualStudioProject.getProjectFile().getLocation());
    }

    public void setVisualStudioProject(VisualStudioProject vsProject) {
        this.visualStudioProject = (DefaultVisualStudioProject)vsProject;
    }

    @Internal
    public VisualStudioProject getVisualStudioProject() {
        return this.visualStudioProject;
    }

    public File getInputFile() {
        return null;
    }

    public File getOutputFile() {
        return this.visualStudioProject.getProjectFile().getLocation();
    }

    protected VisualStudioProjectFile create() {
        return new VisualStudioProjectFile(this.getXmlTransformer(), this.getTransformer());
    }

    protected void configure(VisualStudioProjectFile projectFile) {
        DefaultVisualStudioProject vsProject = this.visualStudioProject;
        projectFile.setGradleCommand(this.buildGradleCommand());
        projectFile.setProjectUuid(DefaultVisualStudioProject.getUUID(this.getOutputFile()));
        for (File file : vsProject.getSourceFiles()) {
            projectFile.addSourceFile(file);
        }
        for (File file : vsProject.getResourceFiles()) {
            projectFile.addResource(file);
        }
        for (File file : vsProject.getHeaderFiles()) {
            projectFile.addHeaderFile(file);
        }
        for (VisualStudioProjectConfiguration visualStudioProjectConfiguration : vsProject.getConfigurations()) {
            projectFile.addConfiguration(visualStudioProjectConfiguration);
        }
        for (Action action : vsProject.getProjectFile().getXmlActions()) {
            this.getXmlTransformer().addAction(action);
        }
    }

    private String buildGradleCommand() {
        String exe = this.getGradleExe();
        String args = this.getGradleArgs();
        if (args == null || args.trim().length() == 0) {
            return exe;
        }
        return exe + " " + args.trim();
    }

    @Input
    public String getGradleExe() {
        return this.gradleExe;
    }

    public void setGradleExe(String gradleExe) {
        this.gradleExe = gradleExe;
    }

    @Input
    @Optional
    public String getGradleArgs() {
        return this.gradleArgs;
    }

    public void setGradleArgs(String gradleArgs) {
        this.gradleArgs = gradleArgs;
    }
}

