#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: chell
version: 0.4.0.2
id: chell-0.4.0.2-IBQv0u4QHDwGOZdD3GqAGa
key: chell-0.4.0.2-IBQv0u4QHDwGOZdD3GqAGa
license: MIT
maintainer: John Millikin <john@john-millikin.com>
homepage: https://john-millikin.com/software/chell/
synopsis: A simple and intuitive library for automated testing.
description:
    Chell is a simple and intuitive library for automated testing. It natively
    supports assertion-based testing, and can use companion libraries
    such as @chell-quickcheck@ to support more complex testing strategies.
    .
    An example test suite, which verifies the behavior of artithmetic operators.
    .
    @
    &#x7b;-\# LANGUAGE TemplateHaskell \#-&#x7d;
    .
    import Test.Chell
    .
    tests_Math :: Suite
    tests_Math = suite \"math\"
    &#x20;   [ test_Addition
    &#x20;   , test_Subtraction
    &#x20;   ]
    .
    test_Addition :: Test
    test_Addition = assertions \"addition\" $ do
    &#x20;   $expect (equal (2 + 1) 3)
    &#x20;   $expect (equal (1 + 2) 3)
    .
    test_Subtraction :: Test
    test_Subtraction = assertions \"subtraction\" $ do
    &#x20;   $expect (equal (2 - 1) 1)
    &#x20;   $expect (equal (1 - 2) (-1))
    .
    main :: IO ()
    main = defaultMain [tests_Math]
    @
    .
    @
    $ ghc --make chell-example.hs
    $ ./chell-example
    PASS: 2 tests run, 2 tests passed
    @
category: Testing
author: John Millikin <john@john-millikin.com>
exposed: True
indefinite: False
exposed-modules:
    Test.Chell
hidden-modules: Test.Chell.Main Test.Chell.Output Test.Chell.Types
abi: 1d15f515791a84462b457fef958611e5
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/chell-0.4.0.2
library-dirs: /usr/lib/ghc-8.2.2/site-local/chell-0.4.0.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/chell-0.4.0.2
hs-libraries: HSchell-0.4.0.2-IBQv0u4QHDwGOZdD3GqAGa
depends:
    ansi-terminal-0.7.1.1-G9WTxmkEIHS8T5XM1ZnzRT base-4.10.1.0
    bytestring-0.10.8.2 options-1.2.1.1-38ZYPRuihX1Fh9IdUi6nBd
    patience-0.1.1-26vcEH4XVheD55wNjzC8dW
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We template-haskell-2.12.0.0
    text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz transformers-0.5.2.0
abi-depends: ansi-terminal-0.7.1.1-G9WTxmkEIHS8T5XM1ZnzRT=0aa3d84ed37feddcfc4971478d436776
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             options-1.2.1.1-38ZYPRuihX1Fh9IdUi6nBd=e59f884bdcf8a4cef829fbff81db8a71
             patience-0.1.1-26vcEH4XVheD55wNjzC8dW=90b8b81cac2d3ec772b2f8e3a9f78b76
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz=29872508833c96394f0471371217bab0
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
haddock-interfaces: /usr/share/doc/haskell-chell/html/chell.haddock
haddock-html: /usr/share/doc/haskell-chell/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

