#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: easytest
version: 0.2
id: easytest-0.2-1y4Su2uBzg821OJ6A7TvFz
key: easytest-0.2-1y4Su2uBzg821OJ6A7TvFz
license: MIT
copyright: Copyright (C) 2017-2018 Joel Burget, Copyright (C) 2016 Paul Chiusano and contributors
maintainer: Joel Burget <joelburget@gmail.com>
stability: provisional
homepage: https://github.com/joelburget/easytest
synopsis: Simple, expressive testing library
description:
    EasyTest is a simple testing toolkit, meant to replace most uses of QuickCheck, SmallCheck, HUnit, and frameworks like Tasty, etc. Here'\''s an example usage:
    .
    > module Main where
    >
    > import EasyTest
    > import Control.Applicative
    > import Control.Monad
    >
    > suite :: Test ()
    > suite = tests
    >   [ scope "addition.ex1" $ expect (1 + 1 == 2)
    >   , scope "addition.ex2" $ expect (2 + 3 == 5)
    >   , scope "list.reversal" . fork $ do
    >       -- generate lists from size 0 to 10, of Ints in (0,43)
    >       -- shorthand: listsOf [0..10] (int'\'' 0 43)
    >       ns <- [0..10] `forM` \n -> replicateM n (int'\'' 0 43)
    >       ns `forM_` \ns -> expect (reverse (reverse ns) == ns)
    >   -- equivalent to `scope "addition.ex3"`
    >   , scope "addition" . scope "ex3" $ expect (3 + 3 == 6)
    >   , scope "always passes" $ do
    >       note "I'\''m running this test, even though it always passes!"
    >       ok -- like `pure ()`, but records a success result
    >   , scope "failing test" $ crash "oh noes!!" ]
    >
    > -- NB: `run suite` would run all tests, but we only run
    > -- tests whose scopes are prefixed by "addition"
    > main = runOnly "addition" suite
    .
    This generates the output:
    .
    > Randomness seed for this run is 5104092164859451056
    > Raw test output to follow ...
    > ------------------------------------------------------------
    > OK addition.ex1
    > OK addition.ex2
    > OK addition.ex3
    > ------------------------------------------------------------
    > ✅  3 tests passed, no failures! 👍 🎉
    The idea here is to write tests with ordinary Haskell code, with control flow explicit and under programmer control.
category: Testing
author: Joel Burget, Paul Chiusano
exposed: True
indefinite: False
exposed-modules:
    EasyTest EasyTest.Internal
hidden-modules: EasyTest.Generators EasyTest.Porcelain
abi: 64f3ec35a52d83d62fa69601c7f14695
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/easytest-0.2
library-dirs: /usr/lib/ghc-8.2.2/site-local/easytest-0.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/easytest-0.2
hs-libraries: HSeasytest-0.2-1y4Su2uBzg821OJ6A7TvFz
depends:
    async-2.1.1.1-8ROwjo1yVqvF3cWHtq6DEd base-4.10.1.0
    mtl-2.2.2-8XubxMJDT8QLsstvlNotkc containers-0.5.10.2
    stm-2.4.5.0-7j9Z9j03i0pHiTKIV2qS3x
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz transformers-0.5.2.0
    call-stack-0.1.0-BVjoAlBRe9FCSr5eFfllei
abi-depends: async-2.1.1.1-8ROwjo1yVqvF3cWHtq6DEd=987aeec331bd3d9d85b408736a8805c6
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             mtl-2.2.2-8XubxMJDT8QLsstvlNotkc=9d788b97813db77c2d48570ade6e04a9
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             stm-2.4.5.0-7j9Z9j03i0pHiTKIV2qS3x=ad6bbd8e6ded9502ff897b95774cdf26
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz=29872508833c96394f0471371217bab0
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             call-stack-0.1.0-BVjoAlBRe9FCSr5eFfllei=80879ea65722c5998aff02ea5d901642
haddock-interfaces: /usr/share/doc/haskell-easytest/html/easytest.haddock
haddock-html: /usr/share/doc/haskell-easytest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

