#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tasty-rerun
version: 1.1.10
id: tasty-rerun-1.1.10-LcECP1vSPf4KmVCtFiuWRp
key: tasty-rerun-1.1.10-LcECP1vSPf4KmVCtFiuWRp
license: BSD3
copyright: Oliver Charles (c) 2014
maintainer: ollie@ocharles.org.uk
homepage: http://github.com/ocharles/tasty-rerun
synopsis: Run tests by filtering the test tree depending on the result of previous test
          runs
description:
    This ingredient adds the ability to run tests by first filtering the test tree
    based on the result of a previous test run. For example, you can use this to
    run only those tests that failed in the last run, or to run only tests that
    have been added since tests were last ran.
    .
    This ingredient is specifically an ingredient *transformer* - given a list of
    '\''Tasty.Ingredient'\''s, '\''rerunningTests'\'' adds the ability for all of these
    ingredients to run against a filtered test tree. This transformer can be
    applied as follows:
    .
    > import Test.Tasty
    > import Test.Tasty.Runners
    >
    > main :: IO ()
    > main =
    >   defaultMainWithIngredients
    >     [ rerunningTests [ listingTests, consoleTestReporter ] ]
    >     tests
    >
    > tests :: TestTree
    > tests = undefined
    .
    This ingredient adds three command line parameters:
    .
    [@--rerun-update@] If specified the results of this test run will be saved to
    the log file at @--rerun-log-file@. If the ingredient does not execute tests
    (for example, @--list-tests@ is used) then the log file will not be
    updated. This option is not enabled by default.  This option does not require
    a value.
    .
    [@--rerun-log-file@] The path to the log file to read previous test
    information from, and where to write new information to (if @--rerun-update@
    is specified). This option defaults to @.tasty-rerun-log@.
    .
    [@--rerun-filter@] Which filters to apply to the '\''Tasty.TestTree'\'' based on
    previous test runs. The value of this option is a comma separated list of the
    following options:
    .
    * @failures@: Only run tests that failed on the previous run.
    .
    * @exceptions@: Only run tests that threw an exception on the previous run.
    .
    * @new@: Only run tests that are new since the previous test run.
    .
    * @successful@: Only run tests that were successful in the previous run.
    .
    Multiple options can be combined and will be taken under disjunction - so
    @--rerun-filter=failures,exceptions@ will run only tests that failed *or*
    threw an exception on the last run.
    .
    Defaults to all filters, which means all tests will be ran.
category: Testing
author: Oliver Charles
exposed: True
indefinite: False
exposed-modules:
    Test.Tasty.Ingredients.Rerun
abi: 7fe4ae47b7257ae74fbfd088baa786e8
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/tasty-rerun-1.1.10
library-dirs: /usr/lib/ghc-8.2.2/site-local/tasty-rerun-1.1.10
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/tasty-rerun-1.1.10
hs-libraries: HStasty-rerun-1.1.10-LcECP1vSPf4KmVCtFiuWRp
depends:
    base-4.10.1.0 containers-0.5.10.2 mtl-2.2.2-8XubxMJDT8QLsstvlNotkc
    optparse-applicative-0.14.2.0-4EjMcggDo0Z7yLeV5c5OSC
    reducers-3.12.2-4b5Pmlno3NV62wT0krGSKn
    split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7
    stm-2.4.5.0-7j9Z9j03i0pHiTKIV2qS3x
    tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2
    tasty-1.0.1.1-G4ET5FMzEAdFZ1yh3S4uTt transformers-0.5.2.0
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             mtl-2.2.2-8XubxMJDT8QLsstvlNotkc=9d788b97813db77c2d48570ade6e04a9
             optparse-applicative-0.14.2.0-4EjMcggDo0Z7yLeV5c5OSC=1b28ef73138451f4af2701ae722f9a7c
             reducers-3.12.2-4b5Pmlno3NV62wT0krGSKn=262498bfdcc4e93346de01478d1bcb52
             split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7=b6b8499789ca23888d2f286cbdde6707
             stm-2.4.5.0-7j9Z9j03i0pHiTKIV2qS3x=ad6bbd8e6ded9502ff897b95774cdf26
             tagged-0.8.5-BP06XmR1GLaIsvsOKwGst2=b5d07becd47ba21e20b584b61ad0f06d
             tasty-1.0.1.1-G4ET5FMzEAdFZ1yh3S4uTt=fb5a791b2b60259c4b58e72c51858b5d
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
haddock-interfaces: /usr/share/doc/haskell-tasty-rerun/html/tasty-rerun.haddock
haddock-html: /usr/share/doc/haskell-tasty-rerun/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

