/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.elasticsearch.Version;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltTokenizers {
    STANDARD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new StandardTokenizer();
        }
    }
    ,
    CLASSIC(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new ClassicTokenizer();
        }
    }
    ,
    UAX_URL_EMAIL(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new UAX29URLEmailTokenizer();
        }
    }
    ,
    PATH_HIERARCHY(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new PathHierarchyTokenizer();
        }
    }
    ,
    LETTER(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new LetterTokenizer();
        }
    }
    ,
    WHITESPACE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new WhitespaceTokenizer();
        }
    }
    ,
    NGRAM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new NGramTokenizer();
        }
    }
    ,
    EDGE_NGRAM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new EdgeNGramTokenizer(1, 1);
        }
    }
    ,
    PATTERN(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new PatternTokenizer(Regex.compile("\\W+", null), -1);
        }
    }
    ,
    THAI(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new ThaiTokenizer();
        }
    };

    private final PreBuiltCacheFactory.CachingStrategy cachingStrategy;

    protected abstract Tokenizer create(Version var1);

    protected TokenFilterFactory getMultiTermComponent(Version version) {
        return null;
    }

    private PreBuiltTokenizers(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
    }

    public PreBuiltCacheFactory.CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }
}

