/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.Track;
import tim.prune.function.Export3dFunction;
import tim.prune.gui.DialogCloser;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.SvgFragment;
import tim.prune.threedee.ThreeDModel;

public class SvgExporter
extends Export3dFunction {
    private Track _track = null;
    private JDialog _dialog = null;
    private JFileChooser _fileChooser = null;
    private double _phi = 0.0;
    private double _theta = 0.0;
    private JTextField _phiField = null;
    private JTextField _thetaField = null;
    private JTextField _altitudeFactorField = null;
    private JCheckBox _gradientsCheckbox = null;
    private static final double _scaleFactor = 200.0;

    public SvgExporter(App app) {
        super(app);
        this._track = app.getTrackInfo().getTrack();
        this._phi = 30.0;
        this._theta = 55.0;
    }

    public String getNameKey() {
        return "function.exportsvg";
    }

    public void setCameraCoordinates(double d, double d2, double d3) {
        this._phi = Math.toDegrees(Math.atan2(d, d3));
        this._theta = Math.toDegrees(Math.atan2(d2, Math.sqrt(d * d + d3 * d3)));
    }

    public void begin() {
        int n;
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
        }
        if ((n = Config.getConfigInt("prune.heightexaggeration")) > 0) {
            this._altFactor = (double)n / 100.0;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        this._phiField.setText(numberFormat.format(this._phi));
        this._thetaField.setText(numberFormat.format(this._theta));
        this._altitudeFactorField.setText("" + this._altFactor);
        this._dialog.pack();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.exportsvg.text"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 6, 4));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SvgExporter.this.doExport();
                SvgExporter.this._dialog.dispose();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SvgExporter.this._dialog.dispose();
            }
        });
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 10, 4));
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.exportsvg.phi"));
        jLabel2.setHorizontalAlignment(11);
        jPanel3.add(jLabel2);
        this._phiField = new JTextField("" + this._phi);
        this._phiField.addKeyListener(new DialogCloser(this._dialog));
        jPanel3.add(this._phiField);
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.exportsvg.theta"));
        jLabel3.setHorizontalAlignment(11);
        jPanel3.add(jLabel3);
        this._thetaField = new JTextField("" + this._theta);
        jPanel3.add(this._thetaField);
        JLabel jLabel4 = new JLabel(I18nManager.getText("dialog.3d.altitudefactor"));
        jLabel4.setHorizontalAlignment(11);
        jPanel3.add(jLabel4);
        this._altitudeFactorField = new JTextField("" + this._altFactor);
        jPanel3.add(this._altitudeFactorField);
        JLabel jLabel5 = new JLabel(I18nManager.getText("dialog.exportsvg.gradients"));
        jLabel5.setHorizontalAlignment(11);
        jPanel3.add(jLabel5);
        this._gradientsCheckbox = new JCheckBox();
        this._gradientsCheckbox.setSelected(true);
        jPanel3.add(this._gradientsCheckbox);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(5, 5));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(jPanel3);
        jPanel4.add((Component)jPanel5, "Center");
        jPanel.add((Component)jPanel4, "Center");
        return jPanel;
    }

    private void doExport() {
        this._phi = SvgExporter.checkAngle(this._phiField.getText());
        this._theta = SvgExporter.checkAngle(this._thetaField.getText());
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetype.svg", new String[]{"svg"}));
            this._fileChooser.setAcceptAllFileFilterUsed(false);
            String string = Config.getConfigString("prune.trackdirectory");
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        boolean bl = false;
        do {
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".svg")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".svg");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                if (this.exportFile(file)) {
                    Config.setConfigString("prune.trackdirectory", file.getParentFile().getAbsolutePath());
                    Config.setConfigInt("prune.heightexaggeration", (int)(this._altFactor * 100.0));
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        } while (bl);
    }

    /*
     * Loose catch block
     */
    private boolean exportFile(File file) {
        OutputStreamWriter outputStreamWriter = null;
        String string = System.getProperty("line.separator");
        ThreeDModel threeDModel = new ThreeDModel(this._track);
        try {
            this._altFactor = Double.parseDouble(this._altitudeFactorField.getText());
            threeDModel.setAltitudeFactor(this._altFactor);
        }
        catch (NumberFormatException numberFormatException) {}
        threeDModel.scale();
        boolean bl = this._gradientsCheckbox.isSelected();
        outputStreamWriter = new FileWriter(file);
        SvgExporter.writeStartOfFile((FileWriter)outputStreamWriter, bl, string);
        this.writeBasePlane((FileWriter)outputStreamWriter, string);
        this.writeCardinals((FileWriter)outputStreamWriter, string);
        this.writeDataPoints((FileWriter)outputStreamWriter, threeDModel, bl, string);
        SvgExporter.writeEndOfFile((FileWriter)outputStreamWriter, string);
        UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + this._track.getNumPoints() + " " + I18nManager.getText("confirm.save.ok2") + " " + file.getAbsolutePath());
        try {
            outputStreamWriter.close();
        }
        catch (Exception exception) {}
        return true;
        catch (IOException iOException) {
            try {
                JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            }
            catch (Throwable throwable) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static void writeStartOfFile(FileWriter fileWriter, boolean bl, String string) throws IOException {
        fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        fileWriter.write(string);
        fileWriter.write("<!-- Svg file produced by GpsPrune - see http://activityworkshop.net/ -->");
        fileWriter.write(string);
        fileWriter.write("<svg width=\"800\" height=\"700\">");
        fileWriter.write(string);
        if (bl) {
            String string2 = "<defs><radialGradient id=\"wayfill\" cx=\"0.5\" cy=\"0.5\" r=\"0.5\" fx=\"0.5\" fy=\"0.5\"><stop offset=\"0%\" stop-color=\"#2323aa\"/><stop offset=\"100%\" stop-color=\"#000080\"/></radialGradient>" + string + "<radialGradient id=\"trackfill\" cx=\"0.5\" cy=\"0.5\" r=\"0.5\" fx=\"0.5\" fy=\"0.5\">" + "<stop offset=\"0%\" stop-color=\"#23aa23\"/>" + "<stop offset=\"100%\" stop-color=\"#008000\"/>" + "</radialGradient>" + "</defs>";
            fileWriter.write(string2);
            fileWriter.write(string);
        }
        fileWriter.write("<g inkscape:label=\"Layer 1\" inkscape:groupmode=\"layer\" id=\"layer1\">");
        fileWriter.write(string);
    }

    private void writeBasePlane(FileWriter fileWriter, String string) throws IOException {
        int[] nArray = this.convertCoordinates(-1.0, -1.0, 0.0);
        int[] nArray2 = this.convertCoordinates(1.0, -1.0, 0.0);
        int[] nArray3 = this.convertCoordinates(1.0, 1.0, 0.0);
        int[] nArray4 = this.convertCoordinates(-1.0, 1.0, 0.0);
        String string2 = "M " + nArray[0] + "," + nArray[1] + " L " + nArray2[0] + "," + nArray2[1] + " L " + nArray3[0] + "," + nArray3[1] + " L " + nArray4[0] + "," + nArray4[1] + " z";
        fileWriter.write("<path style=\"fill:#446666;stroke:#000000;\" d=\"" + string2 + "\" id=\"rect1\" />");
        fileWriter.write(string);
    }

    private void writeCardinals(FileWriter fileWriter, String string) throws IOException {
        int[] nArray = this.convertCoordinates(0.0, 1.0, 0.0);
        SvgExporter.writeCardinal(fileWriter, nArray[0], nArray[1], "cardinal.n", string);
        int[] nArray2 = this.convertCoordinates(1.0, 0.0, 0.0);
        SvgExporter.writeCardinal(fileWriter, nArray2[0], nArray2[1], "cardinal.e", string);
        int[] nArray3 = this.convertCoordinates(0.0, -1.0, 0.0);
        SvgExporter.writeCardinal(fileWriter, nArray3[0], nArray3[1], "cardinal.s", string);
        int[] nArray4 = this.convertCoordinates(-1.0, 0.0, 0.0);
        SvgExporter.writeCardinal(fileWriter, nArray4[0], nArray4[1], "cardinal.w", string);
    }

    private static void writeCardinal(FileWriter fileWriter, int n, int n2, String string, String string2) throws IOException {
        fileWriter.write("<text x=\"" + n + "\" y=\"" + n2 + "\" font-size=\"26\" fill=\"black\" " + "stroke=\"white\" stroke-width=\"0.5\">");
        fileWriter.write(I18nManager.getText(string));
        fileWriter.write("</text>");
        fileWriter.write(string2);
    }

    private int[] convertCoordinates(double d, double d2, double d3) {
        double d4 = Math.cos(Math.toRadians(this._phi));
        double d5 = Math.sin(Math.toRadians(this._phi));
        double d6 = d * d4 + d2 * d5;
        double d7 = d2 * d4 - d * d5;
        double d8 = d3;
        double d9 = Math.cos(Math.toRadians(this._theta));
        double d10 = Math.sin(Math.toRadians(this._theta));
        double d11 = d6;
        double d12 = d7 * d10 + d8 * d9;
        d11 = d11 * 200.0 + 400.0;
        d12 = -d12 * 200.0 + 350.0;
        return new int[]{(int)d11, (int)d12};
    }

    private static void writeEndOfFile(FileWriter fileWriter, String string) throws IOException {
        fileWriter.write(string);
        fileWriter.write("</g></svg>");
        fileWriter.write(string);
    }

    private void writeDataPoints(FileWriter fileWriter, ThreeDModel threeDModel, boolean bl, String string) throws IOException {
        int n = threeDModel.getNumPoints();
        TreeSet<SvgFragment> treeSet = new TreeSet<SvgFragment>();
        int n2 = 0;
        while (n2 < n) {
            StringBuilder stringBuilder = new StringBuilder();
            int[] nArray = this.convertCoordinates(threeDModel.getScaledHorizValue(n2), threeDModel.getScaledVertValue(n2), threeDModel.getScaledAltValue(n2));
            if (threeDModel.getScaledAltValue(n2) > 0.0) {
                int[] nArray2 = this.convertCoordinates(threeDModel.getScaledHorizValue(n2), threeDModel.getScaledVertValue(n2), 0.0);
                stringBuilder.append("<line x1=\"").append(nArray2[0]).append("\" y1=\"").append(nArray2[1]).append("\" x2=\"").append(nArray[0]).append("\" y2=\"").append(nArray[1]).append("\" stroke=\"gray\" stroke-width=\"3\" />");
                stringBuilder.append(string);
            }
            if (threeDModel.getPointType(n2) == 1) {
                stringBuilder.append("<circle cx=\"").append(nArray[0]).append("\" cy=\"").append(nArray[1]).append("\" r=\"11\" ").append(bl ? "fill=\"url(#wayfill)\"" : "fill=\"blue\"").append(" stroke=\"green\" stroke-width=\"0.2\" />");
            } else {
                stringBuilder.append("<circle cx=\"").append(nArray[0]).append("\" cy=\"").append(nArray[1]).append("\" r=\"7\" ").append(bl ? "fill=\"url(#trackfill)\"" : "fill=\"green\"").append(" stroke=\"blue\" stroke-width=\"0.2\" />");
            }
            stringBuilder.append(string);
            treeSet.add(new SvgFragment(stringBuilder.toString(), nArray[1]));
            ++n2;
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            fileWriter.write(((SvgFragment)iterator.next()).getFragment());
        }
    }

    private static double checkAngle(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {}
        return d;
    }
}

