/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import java.io.File;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublisher;
import org.gradle.internal.component.external.ivypublish.DefaultIvyModulePublishMetadata;
import org.gradle.internal.component.external.ivypublish.IvyModulePublishMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

public class DependencyResolverIvyPublisher
implements IvyPublisher {
    @Override
    public void publish(IvyNormalizedPublication publication, PublicationAwareRepository repository) {
        ModuleVersionPublisher publisher = repository.createPublisher();
        IvyPublicationIdentity projectIdentity = publication.getProjectIdentity();
        ModuleComponentIdentifier moduleVersionIdentifier = DefaultModuleComponentIdentifier.newId((String)projectIdentity.getOrganisation(), (String)projectIdentity.getModule(), (String)projectIdentity.getRevision());
        DefaultIvyModulePublishMetadata publishMetaData = new DefaultIvyModulePublishMetadata(moduleVersionIdentifier, "");
        for (IvyArtifact publishArtifact : publication.getArtifacts()) {
            publishMetaData.addArtifact(this.createIvyArtifact(publishArtifact), publishArtifact.getFile());
        }
        DefaultIvyArtifactName ivyDescriptor = new DefaultIvyArtifactName("ivy", "ivy", "xml");
        publishMetaData.addArtifact((IvyArtifactName)ivyDescriptor, publication.getIvyDescriptorFile());
        File gradleModuleDescriptorFile = publication.getGradleModuleDescriptorFile();
        if (gradleModuleDescriptorFile != null && gradleModuleDescriptorFile.exists()) {
            DefaultIvyArtifactName gradleDescriptor = new DefaultIvyArtifactName(projectIdentity.getModule(), "json", "module");
            publishMetaData.addArtifact((IvyArtifactName)gradleDescriptor, gradleModuleDescriptorFile);
        }
        publisher.publish((IvyModulePublishMetadata)publishMetaData);
    }

    private IvyArtifactName createIvyArtifact(IvyArtifact ivyArtifact) {
        return new DefaultIvyArtifactName(ivyArtifact.getName(), ivyArtifact.getType(), ivyArtifact.getExtension(), ivyArtifact.getClassifier());
    }
}

