/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformSpec;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public class JUnitPlatformTestFramework
implements TestFramework {
    private final JUnitPlatformOptions options;
    private final DefaultTestFilter filter;

    public JUnitPlatformTestFramework(DefaultTestFilter filter) {
        this.filter = filter;
        this.options = new JUnitPlatformOptions();
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        if (!JavaVersion.current().isJava8Compatible()) {
            throw new UnsupportedJavaRuntimeException("Running JUnit platform requires Java 8+, please configure your test java executable with Java 8 or higher.");
        }
        return new JUnitPlatformTestClassProcessorFactory(new JUnitPlatformSpec(this.options, this.filter.getIncludePatterns(), this.filter.getCommandLineIncludePatterns()));
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return new Action<WorkerProcessBuilder>(){

            public void execute(WorkerProcessBuilder workerProcessBuilder) {
                workerProcessBuilder.sharedPackages(new String[]{"org.junit.platform.engine"});
                workerProcessBuilder.sharedPackages(new String[]{"org.junit.platform.commons"});
                workerProcessBuilder.sharedPackages(new String[]{"org.junit.platform.launcher.core"});
                workerProcessBuilder.sharedPackages(new String[]{"org.junit.platform.launcher"});
            }
        };
    }

    @Override
    public JUnitPlatformOptions getOptions() {
        return this.options;
    }

    @Override
    public TestFrameworkDetector getDetector() {
        return null;
    }

    public static class JUnitPlatformTestClassProcessorFactory
    implements WorkerTestClassProcessorFactory,
    Serializable {
        private final JUnitPlatformSpec spec;

        public JUnitPlatformTestClassProcessorFactory(JUnitPlatformSpec spec) {
            this.spec = spec;
        }

        public TestClassProcessor create(ServiceRegistry serviceRegistry) {
            try {
                IdGenerator idGenerator = (IdGenerator)serviceRegistry.get(IdGenerator.class);
                Clock clock = (Clock)serviceRegistry.get(Clock.class);
                ActorFactory actorFactory = (ActorFactory)serviceRegistry.get(ActorFactory.class);
                Class<?> clazz = this.getClass().getClassLoader().loadClass("org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestClassProcessor");
                Constructor<?> constructor = clazz.getConstructor(JUnitPlatformSpec.class, IdGenerator.class, ActorFactory.class, Clock.class);
                return (TestClassProcessor)constructor.newInstance(this.spec, idGenerator, actorFactory, clock);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }
}

