/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DefaultExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.changedetection.state.CoercingStringValueSnapshot;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;

public class ModuleMetadataParser {
    public static final String FORMAT_VERSION = "0.3";
    private final ImmutableAttributesFactory attributesFactory;
    private final NamedObjectInstantiator instantiator;
    private final ExcludeRuleConverter excludeRuleConverter;

    public ModuleMetadataParser(ImmutableAttributesFactory attributesFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, NamedObjectInstantiator instantiator) {
        this.attributesFactory = attributesFactory;
        this.instantiator = instantiator;
        this.excludeRuleConverter = new DefaultExcludeRuleConverter(moduleIdentifierFactory);
    }

    public void parse(final LocallyAvailableExternalResource resource, final MutableModuleComponentResolveMetadata metadata) {
        resource.withContent((Transformer)new Transformer<Void, InputStream>(){

            public Void transform(InputStream inputStream) {
                try {
                    JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "utf-8"));
                    reader.beginObject();
                    if (reader.peek() != JsonToken.NAME) {
                        throw new RuntimeException("Module metadata should contain a 'formatVersion' value.");
                    }
                    String name = reader.nextName();
                    if (!name.equals("formatVersion")) {
                        throw new RuntimeException(String.format("The 'formatVersion' value should be the first value in a module metadata. Found '%s' instead.", name));
                    }
                    if (reader.peek() != JsonToken.STRING) {
                        throw new RuntimeException("The 'formatVersion' value should have a string value.");
                    }
                    String version = reader.nextString();
                    if (!version.equals(ModuleMetadataParser.FORMAT_VERSION)) {
                        throw new RuntimeException(String.format("Unsupported format version '%s' specified in module metadata. This version of Gradle supports format version %s only.", version, ModuleMetadataParser.FORMAT_VERSION));
                    }
                    ModuleMetadataParser.this.consumeTopLevelElements(reader, metadata);
                    return null;
                }
                catch (Exception e) {
                    throw new MetaDataParseException("module metadata", (ExternalResource)resource, e);
                }
            }
        });
    }

    private void consumeTopLevelElements(JsonReader reader, MutableModuleComponentResolveMetadata metadata) throws IOException {
        while (reader.peek() != JsonToken.END_OBJECT) {
            String name = reader.nextName();
            if ("variants".equals(name)) {
                this.consumeVariants(reader, metadata);
                continue;
            }
            if ("component".equals(name)) {
                this.consumeComponent(reader, metadata);
                continue;
            }
            this.consumeAny(reader);
        }
    }

    private void consumeComponent(JsonReader reader, MutableModuleComponentResolveMetadata metadata) throws IOException {
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String name = reader.nextName();
            if ("attributes".equals(name)) {
                metadata.setAttributes((AttributeContainer)this.consumeAttributes(reader));
                continue;
            }
            this.consumeAny(reader);
        }
        reader.endObject();
    }

    private void consumeVariants(JsonReader reader, MutableModuleComponentResolveMetadata metadata) throws IOException {
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            this.consumeVariant(reader, metadata);
        }
        reader.endArray();
    }

    private void consumeVariant(JsonReader reader, MutableModuleComponentResolveMetadata metadata) throws IOException {
        reader.beginObject();
        String variantName = null;
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        List<Object> files = Collections.emptyList();
        List<Object> dependencies = Collections.emptyList();
        List<Object> dependencyConstraints = Collections.emptyList();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String name = reader.nextName();
            if (name.equals("name")) {
                variantName = reader.nextString();
                continue;
            }
            if (name.equals("attributes")) {
                attributes = this.consumeAttributes(reader);
                continue;
            }
            if (name.equals("files")) {
                files = this.consumeFiles(reader);
                continue;
            }
            if (name.equals("dependencies")) {
                dependencies = this.consumeDependencies(reader);
                continue;
            }
            if (name.equals("dependencyConstraints")) {
                dependencyConstraints = this.consumeDependencyConstraints(reader);
                continue;
            }
            if (name.equals("available-at")) {
                dependencies = this.consumeVariantLocation(reader);
                continue;
            }
            this.consumeAny(reader);
        }
        reader.endObject();
        MutableComponentVariant variant = metadata.addVariant(variantName, attributes);
        for (ModuleFile file : files) {
            variant.addFile(file.name, file.uri);
        }
        for (ModuleDependency dependency : dependencies) {
            variant.addDependency(dependency.group, dependency.module, dependency.versionConstraint, (List<ExcludeMetadata>)dependency.excludes, dependency.reason);
        }
        for (ModuleDependencyConstraint dependencyConstraint : dependencyConstraints) {
            variant.addDependencyConstraint(dependencyConstraint.group, dependencyConstraint.module, dependencyConstraint.versionConstraint, dependencyConstraint.reason);
        }
    }

    private List<ModuleDependency> consumeVariantLocation(JsonReader reader) throws IOException {
        String group = null;
        String module = null;
        String version = null;
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String name = reader.nextName();
            if (name.equals("group")) {
                group = reader.nextString();
                continue;
            }
            if (name.equals("module")) {
                module = reader.nextString();
                continue;
            }
            if (name.equals("version")) {
                version = reader.nextString();
                continue;
            }
            this.consumeAny(reader);
        }
        reader.endObject();
        return ImmutableList.of((Object)new ModuleDependency(group, module, new DefaultImmutableVersionConstraint(version), (ImmutableList<ExcludeMetadata>)ImmutableList.of(), null));
    }

    private List<ModuleDependency> consumeDependencies(JsonReader reader) throws IOException {
        ArrayList<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            String group = null;
            String module = null;
            String reason = null;
            ImmutableVersionConstraint version = DefaultImmutableVersionConstraint.of();
            ImmutableList<ExcludeMetadata> excludes = ImmutableList.of();
            while (reader.peek() != JsonToken.END_OBJECT) {
                String name = reader.nextName();
                if (name.equals("group")) {
                    group = reader.nextString();
                    continue;
                }
                if (name.equals("module")) {
                    module = reader.nextString();
                    continue;
                }
                if (name.equals("version")) {
                    version = this.consumeVersion(reader);
                    continue;
                }
                if (name.equals("excludes")) {
                    excludes = this.consumeExcludes(reader);
                    continue;
                }
                if (name.equals("reason")) {
                    reason = reader.nextString();
                    continue;
                }
                this.consumeAny(reader);
            }
            dependencies.add(new ModuleDependency(group, module, version, excludes, reason));
            reader.endObject();
        }
        reader.endArray();
        return dependencies;
    }

    private List<ModuleDependencyConstraint> consumeDependencyConstraints(JsonReader reader) throws IOException {
        ArrayList<ModuleDependencyConstraint> dependencies = new ArrayList<ModuleDependencyConstraint>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            String group = null;
            String module = null;
            String reason = null;
            ImmutableVersionConstraint version = null;
            while (reader.peek() != JsonToken.END_OBJECT) {
                String name = reader.nextName();
                if (name.equals("group")) {
                    group = reader.nextString();
                    continue;
                }
                if (name.equals("module")) {
                    module = reader.nextString();
                    continue;
                }
                if (name.equals("version")) {
                    version = this.consumeVersion(reader);
                    continue;
                }
                if (name.equals("reason")) {
                    reason = reader.nextString();
                    continue;
                }
                this.consumeAny(reader);
            }
            dependencies.add(new ModuleDependencyConstraint(group, module, version, reason));
            reader.endObject();
        }
        reader.endArray();
        return dependencies;
    }

    private ImmutableVersionConstraint consumeVersion(JsonReader reader) throws IOException {
        reader.beginObject();
        String preferred = "";
        ArrayList rejects = Lists.newArrayList();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String cst = reader.nextName();
            if ("prefers".equals(cst)) {
                preferred = reader.nextString();
                continue;
            }
            if (!"rejects".equals(cst)) continue;
            reader.beginArray();
            while (reader.peek() != JsonToken.END_ARRAY) {
                rejects.add(reader.nextString());
            }
            reader.endArray();
        }
        reader.endObject();
        return DefaultImmutableVersionConstraint.of(preferred, rejects);
    }

    private ImmutableList<ExcludeMetadata> consumeExcludes(JsonReader reader) throws IOException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            String group = null;
            String module = null;
            while (reader.peek() != JsonToken.END_OBJECT) {
                String name = reader.nextName();
                if (name.equals("group")) {
                    group = reader.nextString();
                    continue;
                }
                if (name.equals("module")) {
                    module = reader.nextString();
                    continue;
                }
                this.consumeAny(reader);
            }
            reader.endObject();
            ExcludeMetadata exclude = this.excludeRuleConverter.createExcludeRule(group, module);
            builder.add((Object)exclude);
        }
        reader.endArray();
        return builder.build();
    }

    private List<ModuleFile> consumeFiles(JsonReader reader) throws IOException {
        ArrayList<ModuleFile> files = new ArrayList<ModuleFile>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            String fileName = null;
            String fileUri = null;
            while (reader.peek() != JsonToken.END_OBJECT) {
                String name = reader.nextName();
                if (name.equals("name")) {
                    fileName = reader.nextString();
                    continue;
                }
                if (name.equals("url")) {
                    fileUri = reader.nextString();
                    continue;
                }
                this.consumeAny(reader);
            }
            reader.endObject();
            files.add(new ModuleFile(fileName, fileUri));
        }
        reader.endArray();
        return files;
    }

    private ImmutableAttributes consumeAttributes(JsonReader reader) throws IOException {
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String attrName = reader.nextName();
            if (reader.peek() == JsonToken.BOOLEAN) {
                boolean attrValue = reader.nextBoolean();
                attributes = this.attributesFactory.concat(attributes, Attribute.of((String)attrName, Boolean.class), (Object)attrValue);
                continue;
            }
            String attrValue = reader.nextString();
            attributes = this.attributesFactory.concat(attributes, Attribute.of((String)attrName, String.class), (Isolatable)new CoercingStringValueSnapshot(attrValue, this.instantiator));
        }
        reader.endObject();
        return attributes;
    }

    private void consumeAny(JsonReader reader) throws IOException {
        reader.skipValue();
    }

    private static class ModuleDependencyConstraint {
        final String group;
        final String module;
        final VersionConstraint versionConstraint;
        private final String reason;

        ModuleDependencyConstraint(String group, String module, VersionConstraint versionConstraint, String reason) {
            this.group = group;
            this.module = module;
            this.versionConstraint = versionConstraint;
            this.reason = reason;
        }
    }

    private static class ModuleDependency {
        final String group;
        final String module;
        final VersionConstraint versionConstraint;
        final ImmutableList<ExcludeMetadata> excludes;
        private final String reason;

        ModuleDependency(String group, String module, VersionConstraint versionConstraint, ImmutableList<ExcludeMetadata> excludes, String reason) {
            this.group = group;
            this.module = module;
            this.versionConstraint = versionConstraint;
            this.excludes = excludes;
            this.reason = reason;
        }
    }

    private static class ModuleFile {
        final String name;
        final String uri;

        ModuleFile(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }
    }
}

