/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.DefaultNativeComponent;
import org.gradle.language.nativeplatform.internal.Names;

public abstract class DefaultCppComponent
extends DefaultNativeComponent
implements CppComponent,
ComponentWithNames {
    private final FileCollection cppSource;
    private final String name;
    private final FileOperations fileOperations;
    private final ConfigurableFileCollection privateHeaders;
    private final FileCollection privateHeadersWithConvention;
    private final Property<String> baseName;
    private final Names names;
    private final DefaultBinaryCollection<CppBinary> binaries;

    @Inject
    public DefaultCppComponent(String name, FileOperations fileOperations, ObjectFactory objectFactory) {
        super(fileOperations);
        this.name = name;
        this.fileOperations = fileOperations;
        this.cppSource = this.createSourceView("src/" + name + "/cpp", Arrays.asList("cpp", "c++", "cc"));
        this.privateHeaders = fileOperations.files(new Object[0]);
        this.privateHeadersWithConvention = this.createDirView(this.privateHeaders, "src/" + name + "/headers");
        this.baseName = objectFactory.property(String.class);
        this.names = Names.of(name);
        this.binaries = (DefaultBinaryCollection)Cast.uncheckedCast((Object)objectFactory.newInstance(DefaultBinaryCollection.class, new Object[]{CppBinary.class}));
    }

    @Override
    public Names getNames() {
        return this.names;
    }

    public String getName() {
        return this.name;
    }

    protected FileCollection createDirView(final ConfigurableFileCollection dirs, final String conventionLocation) {
        return this.fileOperations.files(new Object[]{new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (dirs.getFrom().isEmpty()) {
                    return DefaultCppComponent.this.fileOperations.files(new Object[]{conventionLocation});
                }
                return dirs;
            }
        }});
    }

    @Override
    public Property<String> getBaseName() {
        return this.baseName;
    }

    @Override
    public FileCollection getCppSource() {
        return this.cppSource;
    }

    @Override
    public ConfigurableFileCollection getPrivateHeaders() {
        return this.privateHeaders;
    }

    @Override
    public void privateHeaders(Action<? super ConfigurableFileCollection> action) {
        action.execute((Object)this.privateHeaders);
    }

    @Override
    public FileCollection getPrivateHeaderDirs() {
        return this.privateHeadersWithConvention;
    }

    @Override
    public FileTree getHeaderFiles() {
        return this.getAllHeaderDirs().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.h"}));
    }

    public FileCollection getAllHeaderDirs() {
        return this.privateHeadersWithConvention;
    }

    public DefaultBinaryCollection<CppBinary> getBinaries() {
        return this.binaries;
    }
}

