/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.WrappedElementAnchor;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.Identikit;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;

public abstract class PsiAnchor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiAnchor");

    @Nullable
    public abstract PsiElement retrieve();

    public abstract PsiFile getFile();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    @NotNull
    public static PsiAnchor create(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "create"));
        }
        PsiUtilCore.ensureValid(element);
        PsiAnchor anchor2 = PsiAnchor.doCreateAnchor(element);
        if (ApplicationManager.getApplication().isUnitTestMode() && !element.equals(anchor2.retrieve())) {
            LOG.error("Cannot restore element " + element + " of " + element.getClass() + " from anchor " + anchor2);
        }
        PsiAnchor psiAnchor = anchor2;
        if (psiAnchor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "create"));
        }
        return psiAnchor;
    }

    @NotNull
    private static PsiAnchor doCreateAnchor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
        }
        if (element instanceof PsiFile) {
            VirtualFile virtualFile2 = ((PsiFile)element).getVirtualFile();
            if (virtualFile2 != null) {
                PsiFileReference psiFileReference = new PsiFileReference(virtualFile2, (PsiFile)element);
                if (psiFileReference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
                }
                return psiFileReference;
            }
            HardReference hardReference = new HardReference(element);
            if (hardReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
            }
            return hardReference;
        }
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile3 = ((PsiDirectory)element).getVirtualFile();
            PsiDirectoryReference psiDirectoryReference = new PsiDirectoryReference(virtualFile3, element.getProject());
            if (psiDirectoryReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
            }
            return psiDirectoryReference;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            HardReference hardReference = new HardReference(element);
            if (hardReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
            }
            return hardReference;
        }
        VirtualFile virtualFile4 = file2.getVirtualFile();
        if (virtualFile4 == null) {
            HardReference hardReference = new HardReference(element);
            if (hardReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
            }
            return hardReference;
        }
        StubIndexReference stubRef = PsiAnchor.createStubReference(element, file2);
        if (stubRef != null) {
            StubIndexReference stubIndexReference = stubRef;
            if (stubIndexReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
            }
            return stubIndexReference;
        }
        if (!element.isPhysical()) {
            PsiAnchor psiAnchor = PsiAnchor.wrapperOrHardReference(element);
            if (psiAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
            }
            return psiAnchor;
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            PsiAnchor psiAnchor = PsiAnchor.wrapperOrHardReference(element);
            if (psiAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
            }
            return psiAnchor;
        }
        Language lang = null;
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language l : viewProvider.getLanguages()) {
            if (viewProvider.getPsi(l) != file2) continue;
            lang = l;
            break;
        }
        if (lang == null) {
            PsiAnchor psiAnchor = PsiAnchor.wrapperOrHardReference(element);
            if (psiAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
            }
            return psiAnchor;
        }
        TreeRangeReference treeRangeReference = new TreeRangeReference(file2, textRange.getStartOffset(), textRange.getEndOffset(), Identikit.fromPsi(element, lang), virtualFile4);
        if (treeRangeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "doCreateAnchor"));
        }
        return treeRangeReference;
    }

    @NotNull
    private static PsiAnchor wrapperOrHardReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "wrapperOrHardReference"));
        }
        for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
            PsiAnchor wrappedAnchor;
            PsiElement anchorElement = provider.getAnchor(element);
            if (anchorElement == null || anchorElement == element || (wrappedAnchor = PsiAnchor.create(anchorElement)) instanceof HardReference) continue;
            WrappedElementAnchor wrappedElementAnchor = new WrappedElementAnchor(provider, wrappedAnchor);
            if (wrappedElementAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "wrapperOrHardReference"));
            }
            return wrappedElementAnchor;
        }
        HardReference hardReference = new HardReference(element);
        if (hardReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "wrapperOrHardReference"));
        }
        return hardReference;
    }

    @Nullable
    public static StubIndexReference createStubReference(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "createStubReference"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "createStubReference"));
        }
        if (element instanceof StubBasedPsiElement && element.isPhysical() && (element instanceof PsiCompiledElement || PsiAnchor.canHaveStub(containingFile))) {
            int index2;
            StubBasedPsiElement elt = (StubBasedPsiElement)element;
            IStubElementType elementType = elt.getElementType();
            if ((elt.getStub() != null || elementType.shouldCreateStub(element.getNode())) && (index2 = PsiAnchor.calcStubIndex((StubBasedPsiElement)element)) != -1) {
                return new StubIndexReference(containingFile, index2, containingFile.getLanguage(), elementType);
            }
        }
        return null;
    }

    private static boolean canHaveStub(PsiFile file2) {
        if (!(file2 instanceof PsiFileImpl)) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        IStubFileElementType elementType = ((PsiFileImpl)file2).getElementTypeForStubBuilder();
        return elementType != null && vFile != null && elementType.shouldBuildStubFor(vFile);
    }

    public static int calcStubIndex(@NotNull StubBasedPsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "calcStubIndex"));
        }
        if (psi instanceof PsiFile) {
            return 0;
        }
        Object liveStub = psi.getStub();
        if (liveStub != null) {
            return ((StubBase)liveStub).id;
        }
        PsiFileImpl file2 = (PsiFileImpl)psi.getContainingFile();
        StubTree stubTree = file2.calcStubTree();
        for (StubElement stb : stubTree.getPlainList()) {
            if (stb.getPsi() != psi) continue;
            return ((StubBase)stb).id;
        }
        return -1;
    }

    @Nullable
    public static PsiElement restoreFromStubIndex(PsiFileWithStubSupport fileImpl, int index2, @NotNull IStubElementType elementType, boolean throwIfNull) {
        List list2;
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor", "restoreFromStubIndex"));
        }
        if (fileImpl == null) {
            if (throwIfNull) {
                throw new AssertionError((Object)"Null file");
            }
            return null;
        }
        StubTree tree = fileImpl.getStubTree();
        if (tree == null) {
            if (fileImpl instanceof PsiFileImpl) {
                tree = ((PsiFileImpl)fileImpl).calcStubTree();
            } else {
                if (throwIfNull) {
                    throw new AssertionError((Object)("Not PsiFileImpl: " + fileImpl.getClass()));
                }
                return null;
            }
        }
        if (index2 >= (list2 = tree.getPlainList()).size()) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Too large index: " + index2 + ">=" + list2.size()));
            }
            return null;
        }
        StubElement stub = (StubElement)list2.get(index2);
        if (stub.getStubType() != elementType) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Element type mismatch: " + stub.getStubType() + "!=" + elementType));
            }
            return null;
        }
        return stub.getPsi();
    }

    public static class StubIndexReference
    extends PsiAnchor {
        private final VirtualFile myVirtualFile;
        private final Project myProject;
        private final int myIndex;
        private final Language myLanguage;
        private final IStubElementType myElementType;

        private StubIndexReference(@NotNull PsiFile file2, int index2, @NotNull Language language, @NotNull IStubElementType elementType) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$StubIndexReference", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$StubIndexReference", "<init>"));
            }
            if (elementType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$StubIndexReference", "<init>"));
            }
            this.myLanguage = language;
            this.myElementType = elementType;
            this.myVirtualFile = file2.getVirtualFile();
            this.myProject = file2.getProject();
            this.myIndex = index2;
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            if (this.myProject.isDisposed() || !this.myVirtualFile.isValid()) {
                return null;
            }
            FileViewProvider viewProvider = PsiManager.getInstance(this.myProject).findViewProvider(this.myVirtualFile);
            PsiFile file2 = viewProvider == null ? null : viewProvider.getPsi(this.myLanguage);
            return file2 instanceof PsiFileWithStubSupport ? file2 : null;
        }

        @Override
        public PsiElement retrieve() {
            return (PsiElement)ApplicationManager.getApplication().runReadAction(() -> StubIndexReference.restoreFromStubIndex((PsiFileWithStubSupport)this.getFile(), this.myIndex, this.myElementType, false));
        }

        public String diagnoseNull() {
            PsiFile file2 = ReadAction.compute(() -> this.getFile());
            try {
                PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction(() -> StubIndexReference.restoreFromStubIndex((PsiFileWithStubSupport)file2, this.myIndex, this.myElementType, true));
                return "No diagnostics, element=" + element + "@" + (element == null ? 0 : System.identityHashCode(element));
            }
            catch (AssertionError e) {
                String msg = ((Throwable)((Object)e)).getMessage();
                msg = msg + (file2 == null ? "\n no PSI file" : "\n current file stamp=" + (short)file2.getModificationStamp());
                Document document = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
                if (document != null) {
                    msg = msg + "\n committed=" + PsiDocumentManager.getInstance(this.myProject).isCommitted(document);
                    msg = msg + "\n saved=" + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
                }
                return msg;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StubIndexReference)) {
                return false;
            }
            StubIndexReference that = (StubIndexReference)o;
            return this.myIndex == that.myIndex && this.myVirtualFile.equals(that.myVirtualFile) && Comparing.equal(this.myElementType, that.myElementType) && this.myLanguage == that.myLanguage;
        }

        public int hashCode() {
            return ((31 * this.myVirtualFile.hashCode() + this.myIndex) * 31 + (this.myElementType == null ? 0 : this.myElementType.hashCode())) * 31 + this.myLanguage.hashCode();
        }

        @NonNls
        public String toString() {
            return "StubIndexReference{myVirtualFile=" + this.myVirtualFile + ", myProject=" + this.myProject + ", myIndex=" + this.myIndex + ", myLanguage=" + this.myLanguage + ", myElementType=" + this.myElementType + '}';
        }

        @Override
        public int getStartOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null, "Element type: " + this.myElementType + "; " + this.myVirtualFile);
            }
            return resolved.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null, "Element type: " + this.myElementType + "; " + this.myVirtualFile);
            }
            return resolved.getTextRange().getEndOffset();
        }

        public VirtualFile getVirtualFile() {
            return this.myVirtualFile;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$StubIndexReference", "getProject"));
            }
            return project;
        }
    }

    private static class PsiDirectoryReference
    extends PsiAnchor {
        private final VirtualFile myFile;
        private final Project myProject;

        private PsiDirectoryReference(@NotNull VirtualFile file2, @NotNull Project project) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$PsiDirectoryReference", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$PsiDirectoryReference", "<init>"));
            }
            this.myFile = file2;
            this.myProject = project;
            assert (file2.isDirectory()) : file2;
        }

        @Override
        public PsiElement retrieve() {
            return SelfElementInfo.restoreDirectoryFromVirtual(this.myFile, this.myProject);
        }

        @Override
        public PsiFile getFile() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiDirectoryReference)) {
                return false;
            }
            PsiDirectoryReference reference = (PsiDirectoryReference)o;
            if (!this.myFile.equals(reference.myFile)) {
                return false;
            }
            return this.myProject.equals(reference.myProject);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }
    }

    private static class PsiFileReference
    extends PsiAnchor {
        private final VirtualFile myFile;
        private final Project myProject;
        @NotNull
        private final Language myLanguage;

        private PsiFileReference(@NotNull VirtualFile file2, @NotNull PsiFile psiFile) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$PsiFileReference", "<init>"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$PsiFileReference", "<init>"));
            }
            this.myFile = file2;
            this.myProject = psiFile.getProject();
            this.myLanguage = PsiFileReference.findLanguage(psiFile);
        }

        private static Language findLanguage(PsiFile file2) {
            FileViewProvider vp = file2.getViewProvider();
            Set<Language> languages = vp.getLanguages();
            for (Language language : languages) {
                if (!file2.equals(vp.getPsi(language))) continue;
                return language;
            }
            throw new AssertionError((Object)("Non-retrievable file: " + file2.getClass() + "; " + file2.getLanguage() + "; " + languages));
        }

        @Override
        public PsiElement retrieve() {
            return this.getFile();
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return SelfElementInfo.restoreFileFromVirtual(this.myFile, this.myProject, this.myLanguage);
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return (int)this.myFile.getLength();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiFileReference)) {
                return false;
            }
            PsiFileReference reference = (PsiFileReference)o;
            if (!this.myFile.equals(reference.myFile)) {
                return false;
            }
            if (!this.myLanguage.equals(reference.myLanguage)) {
                return false;
            }
            return this.myProject.equals(reference.myProject);
        }

        public int hashCode() {
            return 31 * this.myFile.hashCode() + this.myLanguage.hashCode();
        }
    }

    public static class HardReference
    extends PsiAnchor {
        private final PsiElement myElement;

        public HardReference(PsiElement element) {
            this.myElement = element;
        }

        @Override
        public PsiElement retrieve() {
            return this.myElement;
        }

        @Override
        public PsiFile getFile() {
            return this.myElement.getContainingFile();
        }

        @Override
        public int getStartOffset() {
            return this.myElement.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myElement.getTextRange().getEndOffset();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HardReference)) {
                return false;
            }
            HardReference that = (HardReference)o;
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }
    }

    private static class TreeRangeReference
    extends PsiAnchor {
        private final VirtualFile myVirtualFile;
        private final Project myProject;
        private final Identikit myInfo;
        private final int myStartOffset;
        private final int myEndOffset;

        private TreeRangeReference(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Identikit info, @NotNull VirtualFile virtualFile2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$TreeRangeReference", "<init>"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$TreeRangeReference", "<init>"));
            }
            if (virtualFile2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/PsiAnchor$TreeRangeReference", "<init>"));
            }
            this.myVirtualFile = virtualFile2;
            this.myProject = file2.getProject();
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myInfo = info;
        }

        @Override
        @Nullable
        public PsiElement retrieve() {
            PsiFile psiFile = this.getFile();
            if (psiFile == null || !psiFile.isValid()) {
                return null;
            }
            return this.myInfo.findPsiElement(psiFile, this.myStartOffset, this.myEndOffset);
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myInfo.getFileLanguage());
        }

        @Override
        public int getStartOffset() {
            return this.myStartOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TreeRangeReference)) {
                return false;
            }
            TreeRangeReference that = (TreeRangeReference)o;
            return this.myEndOffset == that.myEndOffset && this.myStartOffset == that.myStartOffset && this.myInfo.equals(that.myInfo) && this.myVirtualFile.equals(that.myVirtualFile);
        }

        public int hashCode() {
            int result2 = this.myInfo.hashCode();
            result2 = 31 * result2 + this.myStartOffset;
            result2 = 31 * result2 + this.myEndOffset;
            result2 = 31 * result2 + this.myVirtualFile.hashCode();
            return result2;
        }
    }
}

