/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.awt.Rectangle;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.xmlb.AccessorBindingWrapper;
import org.jetbrains.kotlin.com.intellij.util.xmlb.AttributeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.CompactCollectionBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.FieldAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMElementBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MultiNodeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.NotNullDeserializeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.OptionTagBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.PropertyAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Serializer;
import org.jetbrains.kotlin.com.intellij.util.xmlb.TagBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.TextBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.AbstractCollection;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.CollectionBean;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.MapAnnotation;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.OptionTag;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Property;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Text;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.kotlin.org.jdom.Comment;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;

public class BeanBinding
extends NotNullDeserializeBinding {
    private static final Map<Class, List<MutableAccessor>> ourAccessorCache = ContainerUtil.createConcurrentSoftValueMap();
    private final String myTagName;
    private Binding[] myBindings;
    protected final Class<?> myBeanClass;
    ThreeState compareByFields;

    public BeanBinding(@NotNull Class<?> beanClass, @Nullable MutableAccessor accessor) {
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "<init>"));
        }
        super(accessor);
        this.compareByFields = ThreeState.UNSURE;
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "init"));
        }
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "init"));
        }
        assert (this.myBindings == null);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.myBindings = new Binding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = BeanBinding.createBinding(accessors.get(i), serializer);
            binding.init(originalType, serializer);
            this.myBindings[i] = binding;
        }
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "deserialize"));
        }
        Object instance = ReflectionUtil.newInstance(this.myBeanClass);
        this.deserializeInto(instance, element);
        Object obj = instance;
        if (obj == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "deserialize"));
        }
        return obj;
    }

    public void deserializeInto(@NotNull Object result2, @NotNull Element element) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "deserializeInto"));
        }
        this.deserializeInto(result2, element, null);
    }

    public void deserializeInto(@NotNull Object result2, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "deserializeInto"));
        }
        block0: for (org.jetbrains.kotlin.org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtil.isEmpty(attribute.getNamespaceURI())) continue;
            for (Binding binding : this.myBindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).myName.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result2, attribute.getValue());
                continue block0;
            }
        }
        MultiMap<Binding, Element> data = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (Binding binding : this.myBindings) {
                if (content instanceof org.jetbrains.kotlin.org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result2, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = MultiMap.createLinked();
                    }
                    data.putValue(binding, child);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserializeUnsafe(result2, child);
                continue block2;
            }
        }
        for (Binding binding : this.myBindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat()) continue;
            ((AccessorBindingWrapper)binding).deserialize(result2, element);
        }
        if (data != null) {
            for (Binding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result2, (List)data.get(binding));
            }
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "isBoundTo"));
        }
        return element.getName().equals(this.myTagName);
    }

    @NotNull
    private static String getTagName(@NotNull Class<?> aClass2) {
        int lastIndexOf;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "getTagName"));
        }
        for (Class<?> c = aClass2; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "getTagName"));
            }
            return string;
        }
        String name = aClass2.getSimpleName();
        if (name.isEmpty()) {
            name = aClass2.getSuperclass().getSimpleName();
        }
        if ((lastIndexOf = name.lastIndexOf(36)) > 0 && name.length() > lastIndexOf + 1) {
            String string = name.substring(lastIndexOf + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "getTagName"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "getTagName"));
        }
        return string;
    }

    private static String getTagNameFromAnnotation(Class<?> aClass2) {
        Tag tag = aClass2.getAnnotation(Tag.class);
        return tag != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "getAccessors"));
        }
        List<MutableAccessor> accessors = ourAccessorCache.get(aClass2);
        if (accessors != null) {
            List<MutableAccessor> list2 = accessors;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "getAccessors"));
            }
            return list2;
        }
        accessors = ContainerUtil.newArrayList();
        Map<Object, Object> nameToAccessors = aClass2 != Rectangle.class ? BeanBinding.collectPropertyAccessors(aClass2, accessors) : Collections.emptyMap();
        int propertyAccessorCount = accessors.size();
        BeanBinding.collectFieldAccessors(aClass2, accessors);
        block0: for (int j = propertyAccessorCount; j < accessors.size(); ++j) {
            String name = accessors.get(j).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i = 0; i < propertyAccessorCount; ++i) {
                if (!accessors.get(i).getName().equals(name)) continue;
                accessors.remove(i);
                --propertyAccessorCount;
                --j;
                continue block0;
            }
        }
        ourAccessorCache.put(aClass2, accessors);
        List<MutableAccessor> list3 = accessors;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "getAccessors"));
        }
        return list3;
    }

    @NotNull
    private static Map<String, Couple<Method>> collectPropertyAccessors(@NotNull Class<?> aClass2, @NotNull List<MutableAccessor> accessors) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "collectPropertyAccessors"));
        }
        if (accessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessors", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "collectPropertyAccessors"));
        }
        TreeMap<String, Couple<Method>> candidates2 = ContainerUtilRt.newTreeMap();
        for (Method method : aClass2.getMethods()) {
            Pair<String, Boolean> propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = BeanBinding.getPropertyData(method.getName())) == null || ((String)propertyData.first).equals("class") || method.getParameterTypes().length != ((Boolean)propertyData.second != false ? 1 : 0)) continue;
            Couple<Object> candidate2 = (Couple)candidates2.get(propertyData.first);
            if (candidate2 == null) {
                candidate2 = Couple.getEmpty();
            }
            if (((Boolean)propertyData.second != false ? (Method)candidate2.second : (Method)candidate2.first) != null) continue;
            candidate2 = Couple.of((Boolean)propertyData.second != false ? (Method)candidate2.first : method, (Boolean)propertyData.second != false ? method : (Method)candidate2.second);
            candidates2.put((String)propertyData.first, (Couple<Method>)candidate2);
        }
        Iterator iterator2 = candidates2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry candidate3 = iterator2.next();
            Couple methods2 = (Couple)candidate3.getValue();
            if (methods2.first != null && methods2.second != null && ((Method)methods2.first).getReturnType().equals(((Method)methods2.second).getParameterTypes()[0]) && ((Method)methods2.first).getAnnotation(Transient.class) == null && ((Method)methods2.second).getAnnotation(Transient.class) == null) {
                accessors.add(new PropertyAccessor((String)candidate3.getKey(), ((Method)methods2.first).getReturnType(), (Method)methods2.first, (Method)methods2.second));
                continue;
            }
            iterator2.remove();
        }
        TreeMap<String, Couple<Method>> treeMap = candidates2;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "collectPropertyAccessors"));
        }
        return treeMap;
    }

    private static void collectFieldAccessors(@NotNull Class<?> aClass2, @NotNull List<MutableAccessor> accessors) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "collectFieldAccessors"));
        }
        if (accessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessors", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "collectFieldAccessors"));
        }
        Class<?> currentClass = aClass2;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                int modifiers2 = field.getModifiers();
                if (Modifier.isStatic(modifiers2) || field.getAnnotation(OptionTag.class) == null && field.getAnnotation(Tag.class) == null && field.getAnnotation(Attribute.class) == null && field.getAnnotation(Property.class) == null && field.getAnnotation(Text.class) == null && field.getAnnotation(CollectionBean.class) == null && field.getAnnotation(MapAnnotation.class) == null && field.getAnnotation(AbstractCollection.class) == null && (!Modifier.isPublic(modifiers2) || Modifier.isFinal(modifiers2) && !Collection.class.isAssignableFrom(field.getType()) || Modifier.isTransient(modifiers2) || field.getAnnotation(Transient.class) != null)) continue;
                accessors.add(new FieldAccessor(field));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass.getAnnotation(Transient.class) == null);
    }

    @Nullable
    private static Pair<String, Boolean> getPropertyData(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "getPropertyData"));
        }
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3, methodName.length());
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2, methodName.length());
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3, methodName.length());
            isSetter = true;
        }
        if (part.isEmpty()) {
            return null;
        }
        int suffixIndex = part.indexOf(36);
        if (suffixIndex > 0) {
            part = part.substring(0, suffixIndex);
        }
        return Pair.create(Introspector.decapitalize(part), isSetter);
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static Binding createBinding(@NotNull MutableAccessor accessor, @NotNull Serializer serializer) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "createBinding"));
        }
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "createBinding"));
        }
        Binding binding = serializer.getBinding(accessor);
        if (binding instanceof JDOMElementBinding) {
            Binding binding2 = binding;
            if (binding2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return binding2;
        }
        Attribute attribute = accessor.getAnnotation(Attribute.class);
        if (attribute != null) {
            AttributeBinding attributeBinding = new AttributeBinding(accessor, attribute);
            if (attributeBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return attributeBinding;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            TagBinding tagBinding = new TagBinding(accessor, tag);
            if (tagBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return tagBinding;
        }
        Text text2 = accessor.getAnnotation(Text.class);
        if (text2 != null) {
            TextBinding textBinding = new TextBinding(accessor);
            if (textBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return textBinding;
        }
        if (binding instanceof CompactCollectionBinding) {
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding, false);
            if (accessorBindingWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return accessorBindingWrapper;
        }
        boolean surroundWithTag = true;
        boolean inline = false;
        Property property = accessor.getAnnotation(Property.class);
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
            inline = property.flat();
        }
        if (!surroundWithTag || inline) {
            if (inline && !(binding instanceof BeanBinding)) {
                throw new XmlSerializationException("inline supported only for BeanBinding: " + accessor);
            }
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding, inline);
            if (accessorBindingWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "createBinding"));
            }
            return accessorBindingWrapper;
        }
        OptionTagBinding optionTagBinding = new OptionTagBinding(accessor, accessor.getAnnotation(OptionTag.class));
        if (optionTagBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding", "createBinding"));
        }
        return optionTagBinding;
    }
}

