/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;

public final class DynamicContext {
    @NotNull
    private final JsScope currentScope;
    @NotNull
    private final JsBlock currentBlock;
    @Nullable
    private JsVars vars;

    @NotNull
    public static DynamicContext rootContext(@NotNull JsScope rootScope2, @NotNull JsBlock globalBlock) {
        return new DynamicContext(rootScope2, globalBlock);
    }

    @NotNull
    public static DynamicContext newContext(@NotNull JsScope scope, @NotNull JsBlock block) {
        return new DynamicContext(scope, block);
    }

    private DynamicContext(@NotNull JsScope scope, @NotNull JsBlock block) {
        this.currentScope = scope;
        this.currentBlock = block;
    }

    @NotNull
    public DynamicContext innerBlock(@NotNull JsBlock block) {
        return new DynamicContext(this.currentScope, block);
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression, @Nullable Object sourceInfo) {
        if (this.vars == null) {
            this.vars = new JsVars();
            MetadataProperties.setSynthetic(this.vars, true);
            this.currentBlock.getStatements().add(this.vars);
            this.vars.setSource(sourceInfo);
        }
        JsName temporaryName = JsScope.declareTemporary();
        JsVars.JsVar var = new JsVars.JsVar(temporaryName, null);
        var.setSource(sourceInfo);
        MetadataProperties.setSynthetic(var, true);
        this.vars.add(var);
        if (initExpression != null) {
            var.source(initExpression.getSource());
        }
        return TemporaryVariable.create(temporaryName, initExpression);
    }

    void moveVarsFrom(@NotNull DynamicContext dynamicContext) {
        if (dynamicContext.vars != null) {
            if (this.vars == null) {
                this.vars = dynamicContext.vars;
                this.currentBlock.getStatements().add(this.vars);
            } else {
                this.vars.addAll(dynamicContext.vars);
            }
            dynamicContext.currentBlock.getStatements().remove(dynamicContext.vars);
            dynamicContext.vars = null;
        }
    }

    @NotNull
    public JsScope getScope() {
        return this.currentScope;
    }

    @NotNull
    public JsBlock jsBlock() {
        return this.currentBlock;
    }
}

