/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import org.jmol.i18n.GT;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.MinimizationThread;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.minimize.forcefield.ForceFieldMMFF;
import org.jmol.minimize.forcefield.ForceFieldUFF;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.thread.JmolThread;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolAsyncException;
import org.jmol.viewer.Viewer;

public class Minimizer {
    public Viewer vwr;
    public Atom[] atoms;
    public Bond[] bonds;
    public int rawBondCount;
    public MinAtom[] minAtoms;
    public MinBond[] minBonds;
    public MinAngle[] minAngles;
    public MinTorsion[] minTorsions;
    public MinPosition[] minPositions;
    public BS bsMinFixed;
    private int ac;
    private int bondCount;
    private int[] atomMap;
    public double[] partialCharges;
    private int steps = 50;
    private double crit = 0.001;
    public String units = "kJ/mol";
    private ForceField pFF;
    private String ff = "UFF";
    private BS bsTaint;
    private BS bsSelected;
    public BS bsAtoms;
    private BS bsFixedDefault;
    private BS bsFixed;
    public Lst<Object[]> constraints;
    private boolean isSilent;
    private Map<String, Object[]> constraintMap;
    private int elemnoMax;
    private boolean minimizationOn;
    private MinimizationThread minimizationThread;
    double[][] coordSaved;

    public Minimizer setProperty(String propertyName, Object value) {
        switch ("ff        cancel    clear     constraintfixed     stop      vwr    ".indexOf(propertyName)) {
            case 0: {
                if (this.ff.equals(value)) break;
                this.setProperty("clear", null);
                this.ff = (String)value;
                break;
            }
            case 10: {
                this.stopMinimization(false);
                break;
            }
            case 20: {
                if (this.minAtoms == null) break;
                this.stopMinimization(false);
                this.clear();
                break;
            }
            case 30: {
                this.addConstraint((Object[])value);
                break;
            }
            case 40: {
                this.bsFixedDefault = (BS)value;
                break;
            }
            case 50: {
                this.stopMinimization(true);
                break;
            }
            case 60: {
                this.vwr = (Viewer)value;
            }
        }
        return this;
    }

    public Object getProperty(String propertyName, int param) {
        if (propertyName.equals("log")) {
            return this.pFF == null ? "" : this.pFF.getLogData();
        }
        return null;
    }

    private void addConstraint(Object[] c) {
        String id;
        Object[] c1;
        if (c == null) {
            return;
        }
        int[] atoms = (int[])c[0];
        int nAtoms = atoms[0];
        if (nAtoms == 0) {
            this.constraints = null;
            return;
        }
        if (this.constraints == null) {
            this.constraints = new Lst();
            this.constraintMap = new Hashtable<String, Object[]>();
        }
        if (atoms[1] > atoms[nAtoms]) {
            AU.swapInt((int[])atoms, (int)1, (int)nAtoms);
            if (nAtoms == 4) {
                AU.swapInt((int[])atoms, (int)2, (int)3);
            }
        }
        if ((c1 = this.constraintMap.get(id = Escape.eAI((int[])atoms))) != null) {
            c1[2] = c[2];
            return;
        }
        this.constraintMap.put(id, c);
        this.constraints.addLast((Object)c);
    }

    private void clear() {
        this.setMinimizationOn(false);
        this.ac = 0;
        this.bondCount = 0;
        this.atoms = null;
        this.bonds = null;
        this.rawBondCount = 0;
        this.minAtoms = null;
        this.minBonds = null;
        this.minAngles = null;
        this.minTorsions = null;
        this.partialCharges = null;
        this.coordSaved = null;
        this.atomMap = null;
        this.bsTaint = null;
        this.bsAtoms = null;
        this.bsFixed = null;
        this.bsFixedDefault = null;
        this.bsMinFixed = null;
        this.bsSelected = null;
        this.constraints = null;
        this.constraintMap = null;
        this.pFF = null;
    }

    public boolean minimize(int steps, double crit, BS bsSelected, BS bsFixed, boolean haveFixed, boolean forceSilent, String ff) throws JmolAsyncException {
        Object val;
        this.isSilent = forceSilent || this.vwr.getBooleanProperty("minimizationSilent");
        this.setEnergyUnits();
        if (steps == Integer.MAX_VALUE && (val = this.vwr.getP("minimizationSteps")) != null && val instanceof Integer) {
            steps = (Integer)val;
        }
        this.steps = steps;
        if (!haveFixed && this.bsFixedDefault != null) {
            bsFixed.and(this.bsFixedDefault);
        }
        if (crit <= 0.0 && (val = this.vwr.getP("minimizationCriterion")) != null && val instanceof Float) {
            crit = ((Float)val).floatValue();
        }
        this.crit = Math.max(crit, 1.0E-4);
        if (this.minimizationOn) {
            return false;
        }
        ForceField pFF0 = this.pFF;
        this.getForceField(ff);
        if (this.pFF == null) {
            Logger.error((String)GT.o((String)GT._((String)"Could not get class for force field {0}"), (Object)ff));
            return false;
        }
        Logger.info((String)("minimize: initializing " + this.pFF.name + " (steps = " + steps + " criterion = " + crit + ") ..."));
        if (bsSelected.nextSetBit(0) < 0) {
            Logger.error((String)GT._((String)"No atoms selected -- nothing to do!"));
            return false;
        }
        this.atoms = this.vwr.ms.at;
        this.bsAtoms = BSUtil.copy((BS)bsSelected);
        int i = this.bsAtoms.nextSetBit(0);
        while (i >= 0) {
            if (this.atoms[i].getElementNumber() == 0) {
                this.bsAtoms.clear(i);
            }
            i = this.bsAtoms.nextSetBit(i + 1);
        }
        if (bsFixed != null) {
            this.bsAtoms.or(bsFixed);
        }
        this.ac = this.bsAtoms.cardinality();
        boolean sameAtoms = BSUtil.areEqual((BS)bsSelected, (BS)this.bsSelected);
        this.bsSelected = bsSelected;
        if (pFF0 != null && this.pFF != pFF0) {
            sameAtoms = false;
        }
        if (!sameAtoms) {
            this.pFF.clear();
        }
        if (!(sameAtoms && BSUtil.areEqual((BS)bsFixed, (BS)this.bsFixed) || this.setupMinimization())) {
            this.clear();
            return false;
        }
        if (steps > 0) {
            this.bsTaint = BSUtil.copy((BS)this.bsAtoms);
            BSUtil.andNot((BS)this.bsTaint, (BS)bsFixed);
            this.vwr.ms.setTaintedAtoms(this.bsTaint, 2);
        }
        if (bsFixed != null) {
            this.bsFixed = bsFixed;
        }
        this.setAtomPositions();
        if (this.constraints != null) {
            int i2 = this.constraints.size();
            block1: while (--i2 >= 0) {
                Object[] constraint = (Object[])this.constraints.get(i2);
                int[] aList = (int[])constraint[0];
                int[] minList = (int[])constraint[1];
                int nAtoms = aList[0] = Math.abs(aList[0]);
                for (int j = 1; j <= nAtoms; ++j) {
                    if (steps <= 0 || !this.bsAtoms.get(aList[j])) {
                        aList[0] = -nAtoms;
                        continue block1;
                    }
                    minList[j - 1] = this.atomMap[aList[j]];
                }
            }
        }
        this.pFF.setConstraints(this);
        if (steps <= 0) {
            this.getEnergyOnly();
        } else if (this.isSilent || !this.vwr.useMinimizationThread()) {
            this.minimizeWithoutThread();
        } else {
            this.setMinimizationOn(true);
        }
        return true;
    }

    private void setEnergyUnits() {
        String s = this.vwr.g.energyUnits;
        this.units = s.equalsIgnoreCase("kcal") ? "kcal" : "kJ";
    }

    private boolean setupMinimization() throws JmolAsyncException {
        this.coordSaved = null;
        this.atomMap = new int[this.atoms.length];
        this.minAtoms = new MinAtom[this.ac];
        this.elemnoMax = 0;
        BS bsElements = new BS();
        int i = this.bsAtoms.nextSetBit(0);
        int pt = 0;
        while (i >= 0) {
            Atom atom = this.atoms[i];
            this.atomMap[i] = pt;
            int atomicNo = this.atoms[i].getElementNumber();
            this.elemnoMax = Math.max(this.elemnoMax, atomicNo);
            bsElements.set(atomicNo);
            this.minAtoms[pt] = new MinAtom(pt, atom, new double[]{atom.x, atom.y, atom.z}, this.ac);
            this.minAtoms[pt].sType = atom.getAtomName();
            i = this.bsAtoms.nextSetBit(i + 1);
            ++pt;
        }
        Logger.info((String)GT.i((String)GT._((String)"{0} atoms will be minimized."), (int)this.ac));
        Logger.info((String)"minimize: getting bonds...");
        this.bonds = this.vwr.ms.bo;
        this.rawBondCount = this.vwr.ms.bondCount;
        this.getBonds();
        Logger.info((String)"minimize: getting angles...");
        this.getAngles();
        Logger.info((String)"minimize: getting torsions...");
        this.getTorsions();
        return this.setModel(bsElements);
    }

    private boolean setModel(BS bsElements) throws JmolAsyncException {
        if (!this.pFF.setModel(bsElements, this.elemnoMax)) {
            Logger.error((String)GT.o((String)GT._((String)"could not setup force field {0}"), (Object)this.ff));
            if (this.ff.equals("MMFF")) {
                this.getForceField("UFF");
                return this.setModel(bsElements);
            }
            return false;
        }
        return true;
    }

    private void setAtomPositions() {
        int i;
        for (i = 0; i < this.ac; ++i) {
            this.minAtoms[i].set();
        }
        this.bsMinFixed = null;
        if (this.bsFixed != null) {
            this.bsMinFixed = new BS();
            i = this.bsAtoms.nextSetBit(0);
            int pt = 0;
            while (i >= 0) {
                if (this.bsFixed.get(i)) {
                    this.bsMinFixed.set(pt);
                }
                i = this.bsAtoms.nextSetBit(i + 1);
                ++pt;
            }
        }
    }

    private void getBonds() {
        Object bond;
        int i;
        Lst bondInfo = new Lst();
        this.bondCount = 0;
        block5: for (i = 0; i < this.rawBondCount; ++i) {
            int i2;
            bond = this.bonds[i];
            int i1 = bond.atom1.i;
            if (!this.bsAtoms.get(i1) || !this.bsAtoms.get(i2 = bond.atom2.i)) continue;
            if (i2 < i1) {
                int ii = i1;
                i1 = i2;
                i2 = ii;
            }
            int bondOrder = bond.getCovalentOrder();
            switch (bondOrder) {
                case 0: {
                    continue block5;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 515: {
                    bondOrder = 5;
                    break;
                }
                default: {
                    bondOrder = 1;
                }
            }
            bondInfo.addLast((Object)new MinBond(i, this.bondCount++, this.atomMap[i1], this.atomMap[i2], bondOrder, 0, null));
        }
        this.minBonds = new MinBond[this.bondCount];
        for (i = 0; i < this.bondCount; ++i) {
            this.minBonds[i] = (MinBond)bondInfo.get(i);
            bond = this.minBonds[i];
            int atom1 = bond.data[0];
            int atom2 = bond.data[1];
            this.minAtoms[atom1].addBond((MinBond)bond, atom2);
            this.minAtoms[atom2].addBond((MinBond)bond, atom1);
        }
        for (i = 0; i < this.ac; ++i) {
            this.minAtoms[i].getBondedAtomIndexes();
        }
    }

    public void getAngles() {
        Lst vAngles = new Lst();
        for (int i = 0; i < this.bondCount; ++i) {
            int ic;
            int j;
            int[] atomList;
            MinBond bond = this.minBonds[i];
            int ia = bond.data[0];
            int ib = bond.data[1];
            if (this.minAtoms[ib].nBonds > 1) {
                atomList = this.minAtoms[ib].getBondedAtomIndexes();
                j = atomList.length;
                while (--j >= 0) {
                    ic = atomList[j];
                    if (ic <= ia) continue;
                    vAngles.addLast((Object)new MinAngle(new int[]{ia, ib, ic, i, this.minAtoms[ib].getBondIndex(j)}));
                    this.minAtoms[ia].bsVdw.clear(ic);
                }
            }
            if (this.minAtoms[ia].nBonds <= 1) continue;
            atomList = this.minAtoms[ia].getBondedAtomIndexes();
            j = atomList.length;
            while (--j >= 0) {
                ic = atomList[j];
                if (ic >= ib || ic <= ia) continue;
                vAngles.addLast((Object)new MinAngle(new int[]{ic, ia, ib, this.minAtoms[ia].getBondIndex(j), i}));
                this.minAtoms[ic].bsVdw.clear(ib);
            }
        }
        this.minAngles = (MinAngle[])vAngles.toArray((Object[])new MinAngle[vAngles.size()]);
        Logger.info((String)(this.minAngles.length + " angles"));
    }

    public void getTorsions() {
        Lst vTorsions = new Lst();
        int i = this.minAngles.length;
        while (--i >= 0) {
            int id;
            int j;
            int[] atomList;
            int[] angle = this.minAngles[i].data;
            int ia = angle[0];
            int ic = angle[2];
            int ib = angle[1];
            if (ic > ib && this.minAtoms[ic].nBonds > 1) {
                atomList = this.minAtoms[ic].getBondedAtomIndexes();
                for (j = 0; j < atomList.length; ++j) {
                    id = atomList[j];
                    if (id == ia || id == ib) continue;
                    vTorsions.addLast((Object)new MinTorsion(new int[]{ia, ib, ic, id, angle[3], angle[4], this.minAtoms[ic].getBondIndex(j)}));
                    this.minAtoms[Math.min((int)ia, (int)id)].bs14.set(Math.max(ia, id));
                }
            }
            if (ia <= ib || this.minAtoms[ia].nBonds == 1) continue;
            atomList = this.minAtoms[ia].getBondedAtomIndexes();
            for (j = 0; j < atomList.length; ++j) {
                id = atomList[j];
                if (id == ic || id == ib) continue;
                vTorsions.addLast((Object)new MinTorsion(new int[]{ic, ib, ia, id, angle[4], angle[3], this.minAtoms[ia].getBondIndex(j)}));
                this.minAtoms[Math.min((int)ic, (int)id)].bs14.set(Math.max(ic, id));
            }
        }
        this.minTorsions = (MinTorsion[])vTorsions.toArray((Object[])new MinTorsion[vTorsions.size()]);
        Logger.info((String)(this.minTorsions.length + " torsions"));
    }

    public ForceField getForceField(String ff) throws JmolAsyncException {
        if (ff.startsWith("MMFF")) {
            ff = "MMFF";
        }
        if (this.pFF == null || !ff.equals(this.ff)) {
            if (ff.equals("UFF")) {
                this.pFF = new ForceFieldUFF(this);
            } else if (ff.equals("MMFF")) {
                this.pFF = new ForceFieldMMFF(this);
            } else {
                this.pFF = new ForceFieldUFF(this);
                ff = "UFF";
            }
            this.ff = ff;
            this.vwr.setStringProperty("_minimizationForceField", ff);
        }
        return this.pFF;
    }

    public boolean minimizationOn() {
        return this.minimizationOn;
    }

    public JmolThread getThread() {
        return this.minimizationThread;
    }

    private void setMinimizationOn(boolean minimizationOn) {
        this.minimizationOn = minimizationOn;
        if (!minimizationOn) {
            if (this.minimizationThread != null) {
                this.minimizationThread = null;
            }
            return;
        }
        if (this.minimizationThread == null) {
            this.minimizationThread = new MinimizationThread();
            this.minimizationThread.setManager(this, this.vwr, null);
            this.minimizationThread.start();
        }
    }

    private void getEnergyOnly() {
        if (this.pFF == null || this.vwr == null) {
            return;
        }
        this.pFF.steepestDescentInitialize(this.steps, this.crit);
        this.vwr.setFloatProperty("_minimizationEnergyDiff", 0.0f);
        this.reportEnergy();
        this.vwr.setStringProperty("_minimizationStatus", "calculate");
        this.vwr.notifyMinimizationStatus();
    }

    private void reportEnergy() {
        this.vwr.setFloatProperty("_minimizationEnergy", this.pFF.toUserUnits(this.pFF.getEnergy()));
    }

    public boolean startMinimization() {
        try {
            Logger.info((String)"minimizer: startMinimization");
            this.vwr.setIntProperty("_minimizationStep", 0);
            this.vwr.setStringProperty("_minimizationStatus", "starting");
            this.vwr.setFloatProperty("_minimizationEnergy", 0.0f);
            this.vwr.setFloatProperty("_minimizationEnergyDiff", 0.0f);
            this.vwr.notifyMinimizationStatus();
            this.vwr.stm.saveCoordinates("minimize", this.bsTaint);
            this.pFF.steepestDescentInitialize(this.steps, this.crit);
            this.reportEnergy();
            this.saveCoordinates();
        }
        catch (Exception e) {
            Logger.error((String)("minimization error vwr=" + this.vwr + " pFF = " + this.pFF));
            return false;
        }
        this.minimizationOn = true;
        return true;
    }

    public boolean stepMinimization() {
        if (!this.minimizationOn) {
            return false;
        }
        boolean doRefresh = !this.isSilent && this.vwr.getBooleanProperty("minimizationRefresh");
        this.vwr.setStringProperty("_minimizationStatus", "running");
        boolean going = this.pFF.steepestDescentTakeNSteps(1);
        int currentStep = this.pFF.getCurrentStep();
        this.vwr.setIntProperty("_minimizationStep", currentStep);
        this.reportEnergy();
        this.vwr.setFloatProperty("_minimizationEnergyDiff", this.pFF.toUserUnits(this.pFF.getEnergyDiff()));
        this.vwr.notifyMinimizationStatus();
        if (doRefresh) {
            this.updateAtomXYZ();
            this.vwr.refresh(3, "minimization step " + currentStep);
        }
        return going;
    }

    public void endMinimization() {
        this.updateAtomXYZ();
        this.setMinimizationOn(false);
        if (this.pFF == null) {
            System.out.println("pFF was null");
        } else {
            boolean failed = this.pFF.detectExplosion();
            if (failed) {
                this.restoreCoordinates();
            }
            this.vwr.setIntProperty("_minimizationStep", this.pFF.getCurrentStep());
            this.reportEnergy();
            this.vwr.setStringProperty("_minimizationStatus", failed ? "failed" : "done");
            this.vwr.notifyMinimizationStatus();
            this.vwr.refresh(3, "Minimizer:done" + (failed ? " EXPLODED" : "OK"));
        }
        Logger.info((String)"minimizer: endMinimization");
    }

    private void saveCoordinates() {
        if (this.coordSaved == null) {
            this.coordSaved = new double[this.ac][3];
        }
        for (int i = 0; i < this.ac; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.coordSaved[i][j] = this.minAtoms[i].coord[j];
            }
        }
    }

    private void restoreCoordinates() {
        if (this.coordSaved == null) {
            return;
        }
        for (int i = 0; i < this.ac; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.minAtoms[i].coord[j] = this.coordSaved[i][j];
            }
        }
        this.updateAtomXYZ();
    }

    public void stopMinimization(boolean coordAreOK) {
        if (!this.minimizationOn) {
            return;
        }
        this.setMinimizationOn(false);
        if (coordAreOK) {
            this.endMinimization();
        } else {
            this.restoreCoordinates();
        }
    }

    void updateAtomXYZ() {
        if (this.steps <= 0) {
            return;
        }
        for (int i = 0; i < this.ac; ++i) {
            MinAtom minAtom = this.minAtoms[i];
            Atom atom = minAtom.atom;
            atom.x = (float)minAtom.coord[0];
            atom.y = (float)minAtom.coord[1];
            atom.z = (float)minAtom.coord[2];
        }
        this.vwr.refreshMeasures(false);
    }

    private void minimizeWithoutThread() {
        if (!this.startMinimization()) {
            return;
        }
        while (this.stepMinimization()) {
        }
        this.endMinimization();
    }

    public void report(String msg, boolean isEcho) {
        if (this.isSilent) {
            Logger.info((String)msg);
        } else if (isEcho) {
            this.vwr.showString(msg, false);
        } else {
            this.vwr.scriptEcho(msg);
        }
    }

    public void calculatePartialCharges(ModelSet ms, BS bsAtoms, BS bsReport) throws JmolAsyncException {
        ForceFieldMMFF ff = new ForceFieldMMFF(this);
        ff.setArrays(ms.at, bsAtoms, ms.bo, ms.bondCount, true, true);
        this.vwr.setAtomProperty(bsAtoms, 1086326785, 0, 0.0f, null, null, ff.getAtomTypeDescriptions());
        this.vwr.setAtomProperty(bsReport == null ? bsAtoms : bsReport, 1111492619, 0, 0.0f, null, ff.getPartialCharges(), null);
    }
}

