/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.api.GenericLineReader;
import javajs.api.GenericZipTools;
import javajs.util.AU;
import javajs.util.Base64;
import javajs.util.Encoding;
import javajs.util.OC;
import javajs.util.SB;

public class Rdr
implements GenericLineReader {
    BufferedReader reader;

    public Rdr(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
    }

    @Override
    public String readNextLine() throws Exception {
        return this.reader.readLine();
    }

    public static Map<String, Object> readCifData(GenericCifDataParser genericCifDataParser, BufferedReader bufferedReader) {
        return genericCifDataParser.set(null, bufferedReader, false).getAllCifData();
    }

    public static String fixUTF(byte[] byArray) {
        Encoding encoding = Rdr.getUTFEncoding(byArray);
        if (encoding != Encoding.NONE) {
            try {
                String string = new String(byArray, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        string = string.substring(1);
                        break;
                    }
                }
                return string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println(unsupportedEncodingException);
            }
        }
        return new String(byArray);
    }

    private static Encoding getUTFEncoding(byte[] byArray) {
        if (byArray.length >= 3 && (byArray[0] & 0xFF) == 239 && (byArray[1] & 0xFF) == 187 && (byArray[2] & 0xFF) == 191) {
            return Encoding.UTF8;
        }
        if (byArray.length >= 4 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 0 && (byArray[2] & 0xFF) == 254 && (byArray[3] & 0xFF) == 255) {
            return Encoding.UTF_32BE;
        }
        if (byArray.length >= 4 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254 && (byArray[2] & 0xFF) == 0 && (byArray[3] & 0xFF) == 0) {
            return Encoding.UTF_32LE;
        }
        if (byArray.length >= 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
            return Encoding.UTF_16LE;
        }
        if (byArray.length >= 2 && (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    private static Encoding getUTFEncodingForStream(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[4];
        byArray[3] = 1;
        try {
            bufferedInputStream.mark(5);
        }
        catch (Exception exception) {
            return Encoding.NONE;
        }
        bufferedInputStream.read(byArray, 0, 4);
        bufferedInputStream.reset();
        return Rdr.getUTFEncoding(byArray);
    }

    public static boolean isBase64(SB sB) {
        return sB.indexOf(";base64,") == 0;
    }

    public static boolean isCompoundDocumentS(InputStream inputStream) {
        return Rdr.isCompoundDocumentB(Rdr.getMagic(inputStream, 8));
    }

    public static boolean isCompoundDocumentB(byte[] byArray) {
        return byArray.length >= 8 && (byArray[0] & 0xFF) == 208 && (byArray[1] & 0xFF) == 207 && (byArray[2] & 0xFF) == 17 && (byArray[3] & 0xFF) == 224 && (byArray[4] & 0xFF) == 161 && (byArray[5] & 0xFF) == 177 && (byArray[6] & 0xFF) == 26 && (byArray[7] & 0xFF) == 225;
    }

    public static boolean isBZip2S(InputStream inputStream) {
        return Rdr.isBZip2B(Rdr.getMagic(inputStream, 3));
    }

    public static boolean isGzipS(InputStream inputStream) {
        return Rdr.isGzipB(Rdr.getMagic(inputStream, 2));
    }

    public static boolean isBZip2B(byte[] byArray) {
        return byArray != null && byArray.length >= 3 && (byArray[0] & 0xFF) == 66 && (byArray[1] & 0xFF) == 90 && (byArray[2] & 0xFF) == 104;
    }

    public static boolean isGzipB(byte[] byArray) {
        return byArray != null && byArray.length >= 2 && (byArray[0] & 0xFF) == 31 && (byArray[1] & 0xFF) == 139;
    }

    public static boolean isPickleS(InputStream inputStream) {
        return Rdr.isPickleB(Rdr.getMagic(inputStream, 2));
    }

    public static boolean isPickleB(byte[] byArray) {
        return byArray != null && byArray.length >= 2 && (byArray[0] & 0xFF) == 125 && (byArray[1] & 0xFF) == 113;
    }

    public static boolean isMessagePackS(InputStream inputStream) {
        return Rdr.isMessagePackB(Rdr.getMagic(inputStream, 2));
    }

    public static boolean isMessagePackB(byte[] byArray) {
        int n;
        return byArray != null && byArray.length >= 1 && ((n = byArray[0] & 0xFF) == 222 || (n & 0xE0) == 128 && byArray[1] != 80);
    }

    public static boolean isPngZipStream(InputStream inputStream) {
        return Rdr.isPngZipB(Rdr.getMagic(inputStream, 55));
    }

    public static boolean isPngZipB(byte[] byArray) {
        return byArray[50] == 0 && byArray[51] == 80 && byArray[52] == 78 && byArray[53] == 71 && byArray[54] == 74;
    }

    public static boolean isZipS(InputStream inputStream) {
        return Rdr.isZipB(Rdr.getMagic(inputStream, 4));
    }

    public static boolean isZipB(byte[] byArray) {
        return byArray.length >= 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
    }

    public static byte[] getMagic(InputStream inputStream, int n) {
        byte[] byArray = new byte[n];
        try {
            inputStream.mark(n + 1);
            inputStream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public static String guessMimeTypeForBytes(byte[] byArray) {
        switch (byArray.length < 2 ? -1 : byArray[1]) {
            case 0: {
                return "image/jpg";
            }
            case 73: {
                return "image/gif";
            }
            case 77: {
                return "image/BMP";
            }
            case 80: {
                return "image/png";
            }
        }
        return "image/unknown";
    }

    public static BufferedInputStream getBIS(byte[] byArray) {
        return new BufferedInputStream(new ByteArrayInputStream(byArray));
    }

    public static BufferedReader getBR(String string) {
        return new BufferedReader(new StringReader(string));
    }

    public static BufferedInputStream getUnzippedInputStream(GenericZipTools genericZipTools, BufferedInputStream bufferedInputStream) throws IOException {
        while (Rdr.isGzipS(bufferedInputStream)) {
            bufferedInputStream = new BufferedInputStream(genericZipTools.newGZIPInputStream(bufferedInputStream));
        }
        return bufferedInputStream;
    }

    public static BufferedInputStream getUnzippedInputStreamBZip2(GenericZipTools genericZipTools, BufferedInputStream bufferedInputStream) throws IOException {
        while (Rdr.isBZip2S(bufferedInputStream)) {
            bufferedInputStream = new BufferedInputStream(genericZipTools.newBZip2InputStream(bufferedInputStream));
        }
        return bufferedInputStream;
    }

    public static byte[] getBytesFromSB(SB sB) {
        return Rdr.isBase64(sB) ? Base64.decodeBase64(sB.substring(8)) : sB.toBytes(0, -1);
    }

    public static Object getStreamAsBytes(BufferedInputStream bufferedInputStream, OC oC) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = oC == null ? new byte[4096] : null;
        int n = 0;
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
            n2 += n;
            if (oC == null) {
                if (n2 >= byArray2.length) {
                    byArray2 = AU.ensureLengthByte(byArray2, n2 * 2);
                }
                System.arraycopy(byArray, 0, byArray2, n2 - n, n);
                continue;
            }
            oC.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        if (oC == null) {
            return AU.arrayCopyByte(byArray2, n2);
        }
        return n2 + " bytes";
    }

    public static BufferedReader getBufferedReader(BufferedInputStream bufferedInputStream, String string) throws IOException {
        if (Rdr.getUTFEncodingForStream(bufferedInputStream) == Encoding.NONE) {
            return new StreamReader(bufferedInputStream, string);
        }
        byte[] byArray = Rdr.getLimitedStreamBytes(bufferedInputStream, -1L);
        bufferedInputStream.close();
        return Rdr.getBR(string == null ? Rdr.fixUTF(byArray) : new String(byArray, string));
    }

    public static byte[] getLimitedStreamBytes(InputStream inputStream, long l) throws IOException {
        int n = l > 0L && l < 1024L ? (int)l : 1024;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[l < 0L ? 4096 : (int)l];
        int n2 = 0;
        int n3 = 0;
        if (l < 0L) {
            l = Integer.MAX_VALUE;
        }
        while ((long)n3 < l && (n2 = inputStream.read(byArray, 0, n)) > 0) {
            if ((n3 += n2) > byArray2.length) {
                byArray2 = AU.ensureLengthByte(byArray2, n3 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n3 - n2, n2);
            if (l == Integer.MAX_VALUE || n3 + n <= byArray2.length) continue;
            n = byArray2.length - n3;
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        byArray = new byte[n3];
        System.arraycopy(byArray2, 0, byArray, 0, n3);
        return byArray;
    }

    public static String streamToUTF8String(BufferedInputStream bufferedInputStream) {
        String[] stringArray = new String[1];
        try {
            Rdr.readAllAsString(Rdr.getBufferedReader(bufferedInputStream, "UTF-8"), -1, true, stringArray, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringArray[0];
    }

    public static boolean readAllAsString(BufferedReader bufferedReader, int n, boolean bl, String[] stringArray, int n2) {
        try {
            SB sB = SB.newN(8192);
            if (n < 0) {
                String string = bufferedReader.readLine();
                if (bl || string != null && string.indexOf(0) < 0 && (string.length() != 4 || string.charAt(0) != '\ufffd' || string.indexOf("PNG") != 1)) {
                    sB.append(string).appendC('\n');
                    while ((string = bufferedReader.readLine()) != null) {
                        sB.append(string).appendC('\n');
                    }
                }
            } else {
                String string;
                int n3;
                for (int i = 0; i < n && (string = bufferedReader.readLine()) != null; i += n3 + 1) {
                    n3 = string.length();
                    if (n - i < n3 + 1) {
                        string = string.substring(0, n - i - 1);
                    }
                    sB.append(string).appendC('\n');
                }
            }
            bufferedReader.close();
            stringArray[n2] = sB.toString();
            return true;
        }
        catch (Exception exception) {
            stringArray[n2] = exception.toString();
            return false;
        }
    }

    static void getPngZipPointAndCount(BufferedInputStream bufferedInputStream, int[] nArray) {
        bufferedInputStream.mark(75);
        try {
            byte[] byArray = Rdr.getLimitedStreamBytes(bufferedInputStream, 74L);
            bufferedInputStream.reset();
            int n = 0;
            int n2 = 64;
            int n3 = 1;
            while (--n2 > 54) {
                n += (byArray[n2] - 48) * n3;
                n3 *= 10;
            }
            n2 = 0;
            n3 = 74;
            int n4 = 1;
            while (--n3 > 64) {
                n2 += (byArray[n3] - 48) * n4;
                n4 *= 10;
            }
            nArray[0] = n;
            nArray[1] = n2;
        }
        catch (Throwable throwable) {
            nArray[1] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedInputStream getPngZipStream(BufferedInputStream bufferedInputStream, boolean bl) {
        if (!Rdr.isPngZipStream(bufferedInputStream)) {
            return bufferedInputStream;
        }
        byte[] byArray = new byte[]{};
        bufferedInputStream.mark(75);
        try {
            int[] nArray = new int[2];
            Rdr.getPngZipPointAndCount(bufferedInputStream, nArray);
            if (nArray[1] != 0) {
                int n = nArray[0];
                while (n > 0) {
                    n = (int)((long)n - bufferedInputStream.skip(n));
                }
                if (!bl) {
                    BufferedInputStream bufferedInputStream2 = bufferedInputStream;
                    return bufferedInputStream2;
                }
                byArray = Rdr.getLimitedStreamBytes(bufferedInputStream, nArray[1]);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (bl) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return Rdr.getBIS(byArray);
    }

    public static String getZipRoot(String string) {
        int n = string.indexOf("|");
        return n < 0 ? string : string.substring(0, n);
    }

    public static class StreamReader
    extends BufferedReader {
        private BufferedInputStream stream;

        public StreamReader(BufferedInputStream bufferedInputStream, String string) throws UnsupportedEncodingException {
            super(new InputStreamReader((InputStream)bufferedInputStream, string == null ? "UTF-8" : string));
            this.stream = bufferedInputStream;
        }

        public BufferedInputStream getStream() {
            try {
                this.stream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.stream;
        }
    }
}

