/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public class OsmConnection {
    private static final String BASIC_AUTH = "Basic ";
    protected boolean cancel;
    protected HttpClient activeConnection;
    protected OAuthParameters oauthParameters;
    static volatile OAuthAccessTokenFetcher fetcher = u -> {
        throw new JosmRuntimeException("OsmConnection.setOAuthAccessTokenFetcher() has not been called");
    };

    public static void setOAuthAccessTokenFetcher(OAuthAccessTokenFetcher tokenFetcher) {
        fetcher = Objects.requireNonNull(tokenFetcher, "tokenFetcher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancel = true;
        OsmConnection osmConnection = this;
        synchronized (osmConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.disconnect();
            }
        }
    }

    protected String retrieveBasicAuthorizationLogin(HttpClient con) throws OsmTransferException {
        String auth = con.getRequestHeader("Authorization");
        if (auth != null && auth.startsWith(BASIC_AUTH)) {
            try {
                String[] token = new String(Base64.getDecoder().decode(auth.substring(BASIC_AUTH.length())), StandardCharsets.UTF_8).split(":");
                if (token.length == 2) {
                    return token[0];
                }
            }
            catch (IllegalArgumentException e) {
                Logging.error(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBasicAuthorizationHeader(HttpClient con) throws OsmTransferException {
        CredentialsAgentResponse response;
        try {
            CredentialsManager credentialsManager = CredentialsManager.getInstance();
            synchronized (credentialsManager) {
                response = CredentialsManager.getInstance().getCredentials(Authenticator.RequestorType.SERVER, con.getURL().getHost(), false);
            }
        }
        catch (CredentialsAgentException e) {
            throw new OsmTransferException(e);
        }
        if (response != null) {
            if (response.isCanceled()) {
                this.cancel = true;
                return;
            }
            String username = response.getUsername() == null ? "" : response.getUsername();
            String password = response.getPassword() == null ? "" : String.valueOf(response.getPassword());
            String token = username + ':' + password;
            con.setHeader("Authorization", BASIC_AUTH + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8)));
        }
    }

    protected void addOAuthAuthorizationHeader(HttpClient connection) throws OsmTransferException {
        if (this.oauthParameters == null) {
            this.oauthParameters = OAuthParameters.createFromApiUrl(OsmApi.getOsmApi().getServerUrl());
        }
        OAuthConsumer consumer = this.oauthParameters.buildConsumer();
        OAuthAccessTokenHolder holder = OAuthAccessTokenHolder.getInstance();
        if (!holder.containsAccessToken()) {
            this.obtainAccessToken(connection);
        }
        if (!holder.containsAccessToken()) {
            throw new MissingOAuthAccessTokenException();
        }
        consumer.setTokenWithSecret(holder.getAccessTokenKey(), holder.getAccessTokenSecret());
        try {
            consumer.sign(connection);
        }
        catch (OAuthException e) {
            throw new OsmTransferException(I18n.tr("Failed to sign a HTTP connection with an OAuth Authentication header", new Object[0]), e);
        }
    }

    protected void obtainAccessToken(HttpClient connection) throws MissingOAuthAccessTokenException {
        try {
            URL apiUrl = new URL(OsmApi.getOsmApi().getServerUrl());
            if (!Objects.equals(apiUrl.getHost(), connection.getURL().getHost())) {
                throw new MissingOAuthAccessTokenException();
            }
            fetcher.obtainAccessToken(apiUrl);
            OAuthAccessTokenHolder.getInstance().setSaveToPreferences(true);
            OAuthAccessTokenHolder.getInstance().save(CredentialsManager.getInstance());
        }
        catch (InterruptedException | InvocationTargetException | MalformedURLException e) {
            throw new MissingOAuthAccessTokenException(e);
        }
    }

    protected void addAuth(HttpClient connection) throws OsmTransferException {
        String authMethod = OsmApi.getAuthMethod();
        if ("basic".equals(authMethod)) {
            this.addBasicAuthorizationHeader(connection);
        } else if ("oauth".equals(authMethod)) {
            this.addOAuthAuthorizationHeader(connection);
        } else {
            String msg = I18n.tr("Unexpected value for preference ''{0}''. Got ''{1}''.", "osm-server.auth-method", authMethod);
            Logging.warn(msg);
            throw new OsmTransferException(msg);
        }
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    public static interface OAuthAccessTokenFetcher {
        public void obtainAccessToken(URL var1) throws InvocationTargetException, InterruptedException;
    }
}

