/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import sbt.internal.inc.InvalidScalaInstance;
import sbt.internal.inc.InvalidScalaProvider;
import sbt.internal.inc.ScalaInstance;
import sbt.io.IO$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import xsbti.Launcher;
import xsbti.ScalaProvider;

public final class ScalaInstance$ {
    public static ScalaInstance$ MODULE$;
    private final String ScalaOrg;
    private final String VersionPrefix;
    private final Set<String> blacklist;

    static {
        new ScalaInstance$();
    }

    public String ScalaOrg() {
        return this.ScalaOrg;
    }

    public String VersionPrefix() {
        return this.VersionPrefix;
    }

    public boolean isDotty(String version) {
        return version.startsWith("0.");
    }

    public ScalaInstance apply(String org, String version, Launcher launcher) {
        ScalaInstance scalaInstance;
        String string = org;
        String string2 = this.ScalaOrg();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            scalaInstance = this.apply(version, launcher);
        } else {
            try {
                scalaInstance = this.apply(version, launcher.getScala(version, "", org));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                String message = new StringOps(Predef$.MODULE$.augmentString("Incompatible version of the `xsbti.Launcher` interface.\n              |Use an sbt 0.12+ launcher instead.\n            ")).stripMargin();
                throw package$.MODULE$.error(message);
            }
        }
        return scalaInstance;
    }

    public ScalaInstance apply(String version, Launcher launcher) {
        return this.apply(version, launcher.getScala(version));
    }

    public ScalaInstance apply(String version, ScalaProvider provider) {
        File[] jars = provider.jars();
        ClassLoader loader = provider.loader();
        File libraryJar = ScalaInstance$.findOrCrash$1(jars, "scala-library.jar");
        File compilerJar = ScalaInstance$.findOrCrash$1(jars, "scala-compiler.jar");
        return new ScalaInstance(version, loader, libraryJar, compilerJar, jars, (Option<String>)None$.MODULE$);
    }

    public ScalaInstance apply(File scalaHome, Launcher launcher) {
        return this.apply(scalaHome, this.scalaLoader(launcher));
    }

    public ScalaInstance apply(File scalaHome, Function1<List<File>, ClassLoader> classLoader) {
        Seq<File> all = this.allJars(scalaHome);
        ClassLoader loader = (ClassLoader)classLoader.apply((Object)all.toList());
        File library = this.libraryJar(scalaHome);
        String version = this.sbt$internal$inc$ScalaInstance$$actualVersion(loader, " (library jar  " + library.getAbsolutePath() + ")");
        File compiler = this.compilerJar(scalaHome);
        return new ScalaInstance(version, loader, library, compiler, (File[])all.toArray(ClassTag$.MODULE$.apply(File.class)), (Option<String>)None$.MODULE$);
    }

    public ScalaInstance apply(String version, File scalaHome, Launcher launcher) {
        Seq<File> all = this.allJars(scalaHome);
        ClassLoader loader = (ClassLoader)this.scalaLoader(launcher).apply((Object)all.toList());
        File library = this.libraryJar(scalaHome);
        File compiler = this.compilerJar(scalaHome);
        return new ScalaInstance(version, loader, library, compiler, (File[])all.toArray(ClassTag$.MODULE$.apply(File.class)), (Option<String>)None$.MODULE$);
    }

    public Seq<File> allJars(File scalaHome) {
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.listFiles(this.scalaLib(scalaHome)))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ScalaInstance$.$anonfun$allJars$1(f))));
    }

    private File scalaLib(File scalaHome) {
        return new File(scalaHome, "lib");
    }

    public File scalaJar(File scalaHome, String name) {
        return new File(this.scalaLib(scalaHome), name);
    }

    private File compilerJar(File scalaHome) {
        return this.scalaJar(scalaHome, "scala-compiler.jar");
    }

    private File libraryJar(File scalaHome) {
        return this.scalaJar(scalaHome, "scala-library.jar");
    }

    public String sbt$internal$inc$ScalaInstance$$actualVersion(ClassLoader scalaLoader, String label) {
        String string;
        try {
            string = this.fastActualVersion(scalaLoader);
        }
        catch (Exception exception) {
            string = this.slowActualVersion(scalaLoader, label);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String slowActualVersion(ClassLoader scalaLoader, String label) {
        void var3_5;
        String string;
        try {
            string = Class.forName("scala.tools.nsc.Properties", true, scalaLoader).getMethod("versionString", new Class[0]).invoke(null, new Object[0]).toString();
        }
        catch (Exception cause) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scala instance doesn't exist or is invalid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label}));
            throw new InvalidScalaInstance(msg, cause);
        }
        String scalaVersion = string;
        return scalaVersion.startsWith(this.VersionPrefix()) ? scalaVersion.substring(this.VersionPrefix().length()) : var3_5;
    }

    private String fastActualVersion(ClassLoader scalaLoader) {
        String string;
        try (InputStream stream = scalaLoader.getResourceAsStream("compiler.properties");){
            Properties props = new Properties();
            props.load(stream);
            string = props.getProperty("version.number");
        }
        return string;
    }

    private Function1<Seq<File>, ClassLoader> scalaLoader(Launcher launcher) {
        return (Function1 & Serializable & scala.Serializable)jars -> new URLClassLoader((URL[])((TraversableOnce)jars.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toURI().toURL(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URL.class)), launcher.topLoader());
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(String jarName$1, File x$1) {
        String string = x$1.getName();
        String string2 = jarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final File findOrCrash$1(File[] jars, String jarName) {
        return (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaInstance$.$anonfun$apply$1(jarName, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new InvalidScalaProvider(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jarName})));
        });
    }

    public static final /* synthetic */ boolean $anonfun$allJars$1(File f) {
        return !ScalaInstance$.MODULE$.blacklist.apply((Object)f.getName());
    }

    private ScalaInstance$() {
        MODULE$ = this;
        this.ScalaOrg = "org.scala-lang";
        this.VersionPrefix = "version ";
        this.blacklist = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala-actors.jar", "scalacheck.jar", "scala-partest.jar", "scala-partest-javaagent.jar", "scalap.jar", "scala-swing.jar"}));
    }
}

