/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.renderer;

import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.parosproxy.paros.Constant;

public class TimeDurationStringValue
implements StringValue {
    private static final long serialVersionUID = -2071582450216282057L;
    private static final MessageFormat TIME_DURATION_WITH_UNIT_FORMAT = new MessageFormat(Constant.messages.getString("generic.value.time.duration.value.unit"));
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final String UNIT_MILLISECONDS;
    private static final String UNIT_SECONDS;
    private static final String UNIT_MINUTES;
    private static final String UNIT_HOURS;
    private static final int ONE_SECOND_IN_MS = 1000;
    private static final int ONE_MINUTE_IN_MS = 60000;
    private static final int ONE_HOUR_IN_MS = 3600000;

    public String getString(Object value) {
        if (value instanceof Number) {
            String unit;
            double duration = ((Number)value).doubleValue();
            if (duration < 1000.0) {
                unit = UNIT_MILLISECONDS;
            } else if (duration < 60000.0) {
                duration /= 1000.0;
                unit = UNIT_SECONDS;
            } else if (duration < 3600000.0) {
                duration /= 60000.0;
                unit = UNIT_MINUTES;
            } else {
                duration /= 3600000.0;
                unit = UNIT_HOURS;
            }
            return TIME_DURATION_WITH_UNIT_FORMAT.format(new Object[]{NUMBER_FORMAT.format(duration), unit});
        }
        return StringValues.TO_STRING.getString(value);
    }

    public static boolean isTargetClass(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz);
    }

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(2);
        UNIT_MILLISECONDS = Constant.messages.getString("generic.value.time.duration.unit.milliseconds");
        UNIT_SECONDS = Constant.messages.getString("generic.value.time.duration.unit.seconds");
        UNIT_MINUTES = Constant.messages.getString("generic.value.time.duration.unit.minutes");
        UNIT_HOURS = Constant.messages.getString("generic.value.time.duration.unit.hours");
    }
}

