/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.LogMessage;
import com.zeroc.Ice.LogMessageSeqHelper;
import com.zeroc.Ice.LogMessageType;
import com.zeroc.Ice.LogMessageTypeSeqHelper;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.RemoteLoggerAlreadyAttachedException;
import com.zeroc.Ice.RemoteLoggerPrx;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface LoggerAdmin
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public void attachRemoteLogger(RemoteLoggerPrx var1, LogMessageType[] var2, String[] var3, int var4, Current var5) throws RemoteLoggerAlreadyAttachedException;

    public boolean detachRemoteLogger(RemoteLoggerPrx var1, Current var2);

    public GetLogResult getLog(LogMessageType[] var1, String[] var2, int var3, Current var4);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return LoggerAdmin.ice_staticId();
    }

    public static String ice_staticId() {
        return "::Ice::LoggerAdmin";
    }

    public static CompletionStage<OutputStream> _iceD_attachRemoteLogger(LoggerAdmin obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        RemoteLoggerPrx iceP_prx = RemoteLoggerPrx.uncheckedCast(istr.readProxy());
        LogMessageType[] iceP_messageTypes = LogMessageTypeSeqHelper.read(istr);
        String[] iceP_traceCategories = istr.readStringSeq();
        int iceP_messageMax = istr.readInt();
        inS.endReadParams();
        obj.attachRemoteLogger(iceP_prx, iceP_messageTypes, iceP_traceCategories, iceP_messageMax, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_detachRemoteLogger(LoggerAdmin obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        RemoteLoggerPrx iceP_prx = RemoteLoggerPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        boolean ret = obj.detachRemoteLogger(iceP_prx, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeBool(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getLog(LoggerAdmin obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        LogMessageType[] iceP_messageTypes = LogMessageTypeSeqHelper.read(istr);
        String[] iceP_traceCategories = istr.readStringSeq();
        int iceP_messageMax = istr.readInt();
        inS.endReadParams();
        GetLogResult ret = obj.getLog(iceP_messageTypes, iceP_traceCategories, iceP_messageMax, current);
        OutputStream ostr = inS.startWriteParams();
        ret.write(ostr);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return LoggerAdmin._iceD_attachRemoteLogger(this, in, current);
            }
            case 1: {
                return LoggerAdmin._iceD_detachRemoteLogger(this, in, current);
            }
            case 2: {
                return LoggerAdmin._iceD_getLog(this, in, current);
            }
            case 3: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 5: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 6: {
                return Object._iceD_ice_ping(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::LoggerAdmin", "::Ice::Object"};
        _iceOps = new String[]{"attachRemoteLogger", "detachRemoteLogger", "getLog", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    }

    public static class GetLogResult {
        public LogMessage[] returnValue;
        public String prefix;

        public GetLogResult() {
        }

        public GetLogResult(LogMessage[] returnValue, String prefix) {
            this.returnValue = returnValue;
            this.prefix = prefix;
        }

        public void write(OutputStream ostr) {
            ostr.writeString(this.prefix);
            LogMessageSeqHelper.write(ostr, this.returnValue);
        }

        public void read(InputStream istr) {
            this.prefix = istr.readString();
            this.returnValue = LogMessageSeqHelper.read(istr);
        }
    }
}

