/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.encoder.ByteArrayUtil;
import ch.qos.logback.core.encoder.NonClosableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventObjectInputStream<E>
extends InputStream {
    NonClosableInputStream ncis;
    List<E> buffer = new ArrayList();
    int index = 0;

    EventObjectInputStream(InputStream is2) throws IOException {
        this.ncis = new NonClosableInputStream(is2);
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("Only the readEvent method is supported.");
    }

    @Override
    public int available() throws IOException {
        return this.ncis.available();
    }

    public E readEvent() throws IOException {
        E event = this.getFromBuffer();
        if (event != null) {
            return event;
        }
        this.internalReset();
        int count2 = this.readHeader();
        if (count2 == -1) {
            return null;
        }
        this.readPayload(count2);
        this.readFooter(count2);
        return this.getFromBuffer();
    }

    private void internalReset() {
        this.index = 0;
        this.buffer.clear();
    }

    E getFromBuffer() {
        if (this.index >= this.buffer.size()) {
            return null;
        }
        return this.buffer.get(this.index++);
    }

    int readHeader() throws IOException {
        byte[] headerBA = new byte[16];
        int bytesRead = this.ncis.read(headerBA);
        if (bytesRead == -1) {
            return -1;
        }
        int offset = 0;
        int startPebble = ByteArrayUtil.readInt(headerBA, offset);
        if (startPebble != 1853421169) {
            throw new IllegalStateException("Does not look like data created by ObjectStreamEncoder");
        }
        int count2 = ByteArrayUtil.readInt(headerBA, offset += 4);
        int endPointer = ByteArrayUtil.readInt(headerBA, offset += 4);
        int checksum = ByteArrayUtil.readInt(headerBA, offset += 4);
        if (checksum != (0x6E78F671 ^ count2)) {
            throw new IllegalStateException("Invalid checksum");
        }
        return count2;
    }

    E readEvents(ObjectInputStream ois) throws IOException {
        Object e2 = null;
        try {
            e2 = ois.readObject();
            this.buffer.add(e2);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        return (E)e2;
    }

    void readFooter(int count2) throws IOException {
        byte[] headerBA = new byte[8];
        this.ncis.read(headerBA);
        int offset = 0;
        int stopPebble = ByteArrayUtil.readInt(headerBA, offset);
        if (stopPebble != 640373619) {
            throw new IllegalStateException("Looks like a corrupt stream");
        }
        int checksum = ByteArrayUtil.readInt(headerBA, offset += 4);
        if (checksum != (0x262B5373 ^ count2)) {
            throw new IllegalStateException("Invalid checksum");
        }
    }

    void readPayload(int count2) throws IOException {
        ArrayList<E> eventList = new ArrayList<E>(count2);
        ObjectInputStream ois = new ObjectInputStream(this.ncis);
        for (int i = 0; i < count2; ++i) {
            E e2 = this.readEvents(ois);
            eventList.add(e2);
        }
        ois.close();
    }

    @Override
    public void close() throws IOException {
        this.ncis.realClose();
    }
}

